/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Decision_Trees.DT_GA;

import java.util.ArrayList;
import java.util.StringTokenizer;
import keel.Algorithms.Decision_Trees.DT_GA.DT_GA;
import keel.Algorithms.Decision_Trees.DT_GA.Poblacion;
import keel.Algorithms.Decision_Trees.DT_GA.Regla;
import keel.Algorithms.Decision_Trees.DT_GA.myDataset;

public class BaseR {
    ArrayList<Regla> baseReglas = new ArrayList();
    myDataset train;
    int umbralS;

    public BaseR() {
    }

    public BaseR(myDataset train, String reglas) {
        this.train = train;
        StringTokenizer tokens = new StringTokenizer(reglas, "\n");
        while (tokens.hasMoreTokens()) {
            String regla = tokens.nextToken();
            Regla r = new Regla(train, regla);
            this.baseReglas.add(r);
        }
    }

    public BaseR genetico(int type, int S, int nGenerations, int popSize, double crossProb, double mutProb) {
        BaseR br = new BaseR();
        br.train = this.train;
        this.umbralS = S;
        boolean hacerLarge = false;
        boolean[] ejemplosTr = new boolean[this.train.size()];
        for (int i = 0; i < ejemplosTr.length; ++i) {
            ejemplosTr[i] = false;
        }
        double[] norm_acc = this.calculaAccuracy();
        for (int i = 0; i < this.baseReglas.size(); ++i) {
            if (this.baseReglas.get(i).cubiertos() >= S) continue;
            if (type == DT_GA.GA_SMALL) {
                for (int k = 0; k < this.train.getnClasses(); ++k) {
                    ArrayList<Object> reglas = new ArrayList();
                    Poblacion p = new Poblacion(i, this.baseReglas.get(i).copia(), nGenerations, popSize, crossProb, mutProb, this.train, this.train.nombreClase(k));
                    p.GA_Small();
                    reglas = p.dameReglas();
                    for (int j = 0; j < reglas.size(); ++j) {
                        br.baseReglas.add(((Regla)reglas.get(j)).copia());
                    }
                }
                continue;
            }
            hacerLarge = true;
            int[] cubiertos = (int[])this.baseReglas.get((int)i).ejemplosCubiertos.clone();
            int nCubiertos = this.baseReglas.get(i).cubiertos();
            for (int j = 0; j < nCubiertos; ++j) {
                ejemplosTr[cubiertos[j]] = true;
            }
        }
        if (hacerLarge) {
            ArrayList<Object> reglas = new ArrayList();
            Poblacion p = new Poblacion(ejemplosTr, nGenerations, popSize, crossProb, mutProb, this.train, norm_acc);
            p.GA_Large();
            reglas = p.dameReglas();
            for (int j = 0; j < reglas.size(); ++j) {
                br.baseReglas.add(((Regla)reglas.get(j)).copia());
            }
        }
        return br;
    }

    public String printString() {
        String cadena = new String("");
        cadena = cadena + "Number of Rules: " + this.baseReglas.size() + "\n";
        for (int i = 0; i < this.baseReglas.size(); ++i) {
            cadena = cadena + "Rule[" + (i + 1) + "]: " + this.baseReglas.get(i).printString();
        }
        return cadena;
    }

    public int size() {
        return this.baseReglas.size();
    }

    public void cubrirEjemplos() {
        for (int i = 0; i < this.size(); ++i) {
            this.baseReglas.get(i).cubrirEjemplos();
        }
    }

    public boolean clasifica(boolean tree, double[] ejemplo, StringBuffer clase_) {
        boolean smallDisjunct = false;
        String clase = "<unclassified>";
        if (tree) {
            int i;
            for (i = 0; i < this.size() && clase.equals("<unclassified>"); ++i) {
                if (!this.baseReglas.get(i).cubre(ejemplo)) continue;
                clase = this.baseReglas.get((int)i).clase;
            }
            smallDisjunct = this.baseReglas.get(--i).cubiertos() < this.umbralS;
        } else {
            double pesoMax = 0.0;
            for (int i = 0; i < this.size(); ++i) {
                if (!this.baseReglas.get(i).cubre(ejemplo)) continue;
                String claseAux = this.baseReglas.get((int)i).clase;
                double peso = this.baseReglas.get((int)i).fitness;
                if (!(peso > pesoMax)) continue;
                clase = claseAux;
                pesoMax = peso;
            }
        }
        clase_.append(clase);
        return smallDisjunct;
    }

    private double[] calculaAccuracy() {
        int i;
        int atts = this.train.getnInputs();
        double[] acc = new double[atts];
        int attsNoUsados = 0;
        boolean[] noUsado = new boolean[atts];
        double minAcc = 1.0;
        int[] clasificados = new int[atts];
        int[] correctamenteClas = new int[atts];
        for (int i2 = 0; i2 < atts; ++i2) {
            boolean aparece = false;
            for (int j = 0; j < this.size(); ++j) {
                if (!this.baseReglas.get(j).contieneAtributo(i2)) continue;
                int n = i2;
                clasificados[n] = clasificados[n] + this.baseReglas.get(j).cubiertos();
                int n2 = i2;
                correctamenteClas[n2] = correctamenteClas[n2] + this.baseReglas.get(j).cubiertosOK();
                aparece = true;
            }
            boolean bl = noUsado[i2] = !aparece;
            if (!aparece) {
                ++attsNoUsados;
                continue;
            }
            acc[i2] = 1.0 * (double)correctamenteClas[i2] / (double)clasificados[i2];
            if (!(acc[i2] < minAcc)) continue;
            minAcc = acc[i2];
        }
        double totalAcc = 0.0;
        for (i = 0; i < atts; ++i) {
            if (noUsado[i]) {
                acc[i] = minAcc / (double)attsNoUsados;
            }
            totalAcc += acc[i];
        }
        i = 0;
        while (i < atts) {
            int n = i++;
            acc[n] = acc[n] / totalAcc;
        }
        return acc;
    }
}

