/*
 * Decompiled with CFR 0.152.
 */
package javolution.xml;

import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import javolution.lang.Reusable;
import javolution.xml.ObjectReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlInputStream<T>
extends InputStream
implements Reusable {
    private final ObjectReader<T> _objectReader;
    private final XmlReader _xmlReader = new XmlReader();

    public XmlInputStream() {
        this(new ObjectReader());
    }

    public XmlInputStream(ObjectReader<T> objectReader) {
        this._objectReader = objectReader;
    }

    public XmlInputStream setInputStream(InputStream inputStream) {
        if (this._xmlReader._inputStream != null) {
            throw new IllegalStateException("Stream not closed or reset");
        }
        this._xmlReader._inputStream = inputStream;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T readObject() throws IOException {
        try {
            T t = this._objectReader.read(this._xmlReader);
            return t;
        }
        finally {
            this._xmlReader.resume();
        }
    }

    @Override
    public void close() throws IOException {
        if (this._xmlReader._inputStream != null) {
            this._xmlReader._inputStream.close();
            this.reset();
        }
    }

    @Override
    public int read() throws IOException {
        if (this._xmlReader._start < this._xmlReader._end) {
            return this._xmlReader._bytes[this._xmlReader._start++];
        }
        return this._xmlReader.fillBuffer() ? this._xmlReader._bytes[this._xmlReader._start++] : -1;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this._xmlReader._end - this._xmlReader._start;
        if (n3 == 0) {
            return this._xmlReader._inputStream.read(byArray, n, n2);
        }
        int n4 = n2 < n3 ? n2 : n3;
        System.arraycopy(this._xmlReader._bytes, this._xmlReader._start, byArray, n, n4);
        this._xmlReader._start += n4;
        return n4;
    }

    @Override
    public void reset() {
        this._objectReader.reset();
        this._xmlReader.reset();
    }

    private static final class XmlReader
    extends Reader
    implements Reusable {
        private InputStream _inputStream;
        private int _code;
        private int _moreBytes;
        private int _start;
        private int _end;
        private final byte[] _bytes = new byte[2048];
        private boolean _isHalted;

        private XmlReader() {
        }

        public void resume() {
            this._isHalted = false;
        }

        public boolean fillBuffer() throws IOException {
            if (this._inputStream == null) {
                throw new IOException("Stream closed");
            }
            this._start = 0;
            this._end = this._inputStream.read(this._bytes, 0, this._bytes.length);
            return this._end > 0;
        }

        public int read(char[] cArray, int n, int n2) throws IOException {
            if (this._isHalted) {
                return -1;
            }
            if (this._start >= this._end && !this.fillBuffer()) {
                return -1;
            }
            int n3 = n + n2;
            int n4 = n;
            while (n4 < n3) {
                byte by = this._bytes[this._start];
                if (by >= 0 && ++this._start < this._end) {
                    cArray[n4++] = (char)by;
                    continue;
                }
                if (by < 0) {
                    if (by == -2) {
                        ++this._start;
                        this._isHalted = true;
                        return n4 - n;
                    }
                    if (n4 < n3 - 1) {
                        int n5 = this.read2();
                        if (n5 < 65536) {
                            cArray[n4++] = (char)n5;
                        } else if (n5 <= 0x10FFFF) {
                            cArray[n4++] = (char)((n5 - 65536 >> 10) + 55296);
                            cArray[n4++] = (char)((n5 - 65536 & 0x3FF) + 56320);
                        } else {
                            throw new CharConversionException("Cannot convert U+" + Integer.toHexString(n5) + " to char (code greater than U+10FFFF)");
                        }
                        if (this._start < this._end) continue;
                    }
                    return n4 - n;
                }
                cArray[n4++] = (char)by;
                return n4 - n;
            }
            return n2;
        }

        public void close() throws IOException {
        }

        private int read2() throws IOException {
            if (this._start < this._end) {
                byte by;
                if ((by = this._bytes[this._start++]) >= 0 && this._moreBytes == 0) {
                    return by;
                }
                if ((by & 0xC0) == 128 && this._moreBytes != 0) {
                    this._code = this._code << 6 | by & 0x3F;
                    if (--this._moreBytes == 0) {
                        return this._code;
                    }
                    return this.read2();
                }
                if ((by & 0xE0) == 192 && this._moreBytes == 0) {
                    this._code = by & 0x1F;
                    this._moreBytes = 1;
                    return this.read2();
                }
                if ((by & 0xF0) == 224 && this._moreBytes == 0) {
                    this._code = by & 0xF;
                    this._moreBytes = 2;
                    return this.read2();
                }
                if ((by & 0xF8) == 240 && this._moreBytes == 0) {
                    this._code = by & 7;
                    this._moreBytes = 3;
                    return this.read2();
                }
                throw new CharConversionException("Invalid UTF-8 Encoding");
            }
            if (this.fillBuffer()) {
                return this.read2();
            }
            if (this._moreBytes == 0) {
                return -1;
            }
            throw new CharConversionException("Unexpected end of stream");
        }

        public void reset() {
            this._code = 0;
            this._end = 0;
            this._inputStream = null;
            this._moreBytes = 0;
            this._start = 0;
        }
    }
}

