/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jclec.binarray;

import net.sf.jclec.ISpecies;
import net.sf.jclec.base.AbstractCreator;
import net.sf.jclec.binarray.BinArrayIndividual;
import net.sf.jclec.binarray.IBinArraySpecies;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinArrayCreator<I extends BinArrayIndividual>
extends AbstractCreator<I> {
    private static final long serialVersionUID = -2638928425169895614L;
    protected transient IBinArraySpecies<I> species;
    protected transient byte[] schema;

    public boolean equals(Object other) {
        return other instanceof BinArrayCreator;
    }

    @Override
    protected void prepareCreation() {
        ISpecies spc = this.context.getSpecies();
        if (!(spc instanceof IBinArraySpecies)) {
            throw new IllegalStateException("Illegal species in context");
        }
        this.species = (IBinArraySpecies)spc;
        this.schema = this.species.getGenotypeSchema();
    }

    @Override
    protected void createNext() {
        this.createdBuffer.add(this.species.createIndividual(this.createGenotype()));
    }

    private final byte[] createGenotype() {
        int gl = this.schema.length;
        byte[] result = new byte[gl];
        int i = 0;
        while (i < gl) {
            result[i] = this.schema[i] == -1 ? (byte)this.randgen.choose(0, 2) : this.schema[i];
            ++i;
        }
        return result;
    }
}

