/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.NICGAR;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.NICGAR.AssociationRule;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.NICGAR.Gene;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.NICGAR.NICGARProcess;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.NICGAR.myDataset;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.NICGAR.parseParameters;
import keel.Dataset.Attributes;
import org.core.Files;
import org.core.Randomize;

public class NICGAR {
    private myDataset dataset;
    private String rulesFilename;
    private String valuesFilename;
    private String EPFilename;
    private String fileTime;
    private String fileHora;
    private String namedataset;
    private NICGARProcess proc;
    private ArrayList<AssociationRule> associationRulesEP;
    private int nTrials;
    private int popSize;
    private double pm;
    private double af;
    private double nichMin;
    private double evMin;
    long startTime;
    long totalTime;
    private double percentUpdate;
    private boolean somethingWrong = false;

    public NICGAR() {
    }

    public NICGAR(parseParameters parameters) {
        this.startTime = System.currentTimeMillis();
        this.dataset = new myDataset();
        try {
            this.namedataset = parameters.getTransactionsInputFile();
            System.out.println("\nReading the transaction set: " + parameters.getTransactionsInputFile());
            this.dataset.readDataSet(parameters.getTransactionsInputFile());
        }
        catch (IOException e) {
            System.err.println("There was a problem while reading the input transaction set: " + e);
            this.somethingWrong = true;
        }
        this.somethingWrong = this.somethingWrong || this.dataset.hasMissingAttributes();
        this.rulesFilename = parameters.getAssociationRulesFile();
        this.valuesFilename = parameters.getOutputFile(0);
        this.EPFilename = parameters.getOutputFile(1);
        this.fileTime = parameters.getOutputFile(1).substring(0, parameters.getOutputFile(1).lastIndexOf(47)) + "/time.txt";
        this.fileHora = parameters.getOutputFile(1).substring(0, parameters.getOutputFile(1).lastIndexOf(47)) + "/hora.txt";
        long seed = Long.parseLong(parameters.getParameter(0));
        this.nTrials = Integer.parseInt(parameters.getParameter(1));
        this.popSize = Integer.parseInt(parameters.getParameter(2));
        this.pm = Double.parseDouble(parameters.getParameter(3));
        this.af = Double.parseDouble(parameters.getParameter(4));
        this.nichMin = Double.parseDouble(parameters.getParameter(5));
        this.evMin = Double.parseDouble(parameters.getParameter(6));
        this.percentUpdate = Double.parseDouble(parameters.getParameter(7));
        Randomize.setSeed(seed);
    }

    public void execute() {
        if (this.somethingWrong) {
            System.err.println("An error was found");
            System.err.println("Aborting the program");
        } else {
            this.proc = new NICGARProcess(this.dataset, this.nTrials, this.popSize, this.pm, this.af, this.nichMin, this.evMin, this.percentUpdate);
            this.proc.run();
            this.associationRulesEP = this.proc.generateRulesEP();
            try {
                PrintWriter rules_writer = new PrintWriter(this.rulesFilename);
                PrintWriter values_writer = new PrintWriter(this.valuesFilename);
                PrintWriter EP_writer = new PrintWriter(this.EPFilename);
                rules_writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                rules_writer.println("<association_rules>");
                values_writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                values_writer.println("<values>");
                EP_writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                EP_writer.println("<values>");
                for (int r = 0; r < this.associationRulesEP.size(); ++r) {
                    Gene gen;
                    int i;
                    AssociationRule a_r = this.associationRulesEP.get(r);
                    ArrayList<Gene> ant = a_r.getAntecedents();
                    ArrayList<Gene> cons = a_r.getConsequents();
                    rules_writer.println("<rule id=\"" + r + "\">");
                    values_writer.println("<rule id=\"" + r + "\" rule_support=\"" + a_r.getSupport() + "\" antecedent_support=\"" + a_r.getAntSupport() + "\" consequent_support=\"" + a_r.getConsSupport() + "\" confidence=\"" + a_r.getConfidence() + "\" lift=\"" + a_r.getLift() + "\" conviction=\"" + a_r.getConv() + "\" certainFactor=\"" + a_r.getCF() + "\" netConf=\"" + a_r.getNetConf() + "\" yulesQ=\"" + a_r.yulesQ + "\" nAnts=\"" + a_r.getnAnts() + "\"/>");
                    rules_writer.println("<antecedents>");
                    for (i = 0; i < ant.size(); ++i) {
                        gen = ant.get(i);
                        this.createRule(gen, gen.getAttr(), rules_writer);
                    }
                    rules_writer.println("</antecedents>");
                    rules_writer.println("<consequents>");
                    for (i = 0; i < cons.size(); ++i) {
                        gen = cons.get(i);
                        this.createRule(gen, gen.getAttr(), rules_writer);
                    }
                    rules_writer.println("</consequents>");
                    rules_writer.println("</rule>");
                }
                rules_writer.println("</association_rules>");
                values_writer.println("</values>");
                rules_writer.close();
                values_writer.close();
                EP_writer.print(this.proc.getrulesEP());
                EP_writer.println("</values>");
                EP_writer.close();
                this.totalTime = System.currentTimeMillis() - this.startTime;
                this.writeTime();
                System.out.println("Algorithm Finished");
                System.gc();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    public void writeTime() {
        String stringOut = new String("");
        stringOut = "" + this.totalTime / 1000L + "  " + this.namedataset + this.rulesFilename + "\n";
        Files.addToFile(this.fileTime, stringOut);
        this.totalTime /= 1000L;
        long seg = this.totalTime % 60L;
        this.totalTime /= 60L;
        long min = this.totalTime % 60L;
        long hor = this.totalTime / 60L;
        stringOut = "";
        stringOut = hor < 10L ? stringOut + "0" + hor + ":" : stringOut + hor + ":";
        stringOut = min < 10L ? stringOut + "0" + min + ":" : stringOut + min + ":";
        stringOut = seg < 10L ? stringOut + "0" + seg : stringOut + seg;
        stringOut = stringOut + "  " + this.rulesFilename + "\n";
        Files.addToFile(this.fileHora, stringOut);
    }

    private void createRule(Gene g, int id_attr, PrintWriter w) {
        w.println("<attribute name=\"" + Attributes.getAttribute(id_attr).getName() + "\" value=\"");
        if (!g.getIsPositiveInterval()) {
            w.print("NOT ");
        }
        if (this.dataset.getAttributeType(id_attr) == 0) {
            w.print(Attributes.getAttribute(id_attr).getNominalValue((int)g.getLowerBound()));
        } else {
            w.print("[" + g.getLowerBound() + ", " + g.getUpperBound() + "]");
        }
        w.print("\" />");
    }
}

