/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Associative_Classification.ClassifierCMAR;

import java.io.BufferedReader;
import java.io.File;
import java.util.StringTokenizer;
import javax.swing.JFrame;
import keel.Algorithms.Associative_Classification.ClassifierCMAR.DataBase;
import keel.Algorithms.Associative_Classification.ClassifierCMAR.myDataset;

public class AssocRuleMining
extends JFrame {
    protected short[][] dataArray = null;
    protected int[][] conversionArray = null;
    protected short[] reconversionArray = null;
    private static final double MIN_SUPPORT = 0.0;
    private static final double MAX_SUPPORT = 100.0;
    private static final double MIN_CONFIDENCE = 0.0;
    private static final double MAX_CONFIDENCE = 100.0;
    protected String fileName = null;
    protected int numCols = 0;
    protected int numRows = 0;
    protected double support = 1.0;
    protected double minSupport = 0.0;
    protected double confidence = 50.0;
    protected int numOneItemSets = 0;
    protected int numClasses = 0;
    protected boolean errorFlag = true;
    protected boolean inputFormatOkFlag = true;
    private boolean haveDataFlag = false;
    private boolean isOrderedFlag = false;
    private boolean isPrunedFlag = false;
    protected BufferedReader fileInput;
    protected File filePath = null;

    public AssocRuleMining(double minConf, double minSup) {
        this.confidence = minConf;
        this.support = minSup;
    }

    public AssocRuleMining() {
    }

    public void inputDataSet(myDataset train, DataBase dataBase) {
        this.readFile(train, dataBase);
        this.countNumCols();
        this.minSupport = (double)this.numRows * this.support / 100.0;
    }

    public void readFile(myDataset train, DataBase dataBase) {
        this.numClasses = train.getnClasses();
        this.numRows = train.getnData();
        this.dataArray = new short[this.numRows][];
        for (int i = 0; i < this.numRows; ++i) {
            int[] example = train.getExample(i);
            this.dataArray[i] = new short[dataBase.numVariablesUsed() + 1];
            short value = 1;
            int k = 0;
            for (int j = 0; j < example.length; ++j) {
                if (dataBase.numLabels(j) <= 1) continue;
                this.dataArray[i][k] = (short)example[j];
                short[] sArray = this.dataArray[i];
                int n = k++;
                sArray[n] = (short)(sArray[n] + value);
                value = (short)(value + dataBase.numLabels(j));
            }
            this.dataArray[i][k] = (short)train.getOutputAsInteger(i);
            short[] sArray = this.dataArray[i];
            int n = k;
            sArray[n] = (short)(sArray[n] + value);
        }
    }

    private void countNumCols() {
        int maxAttribute = 0;
        for (int index = 0; index < this.dataArray.length; ++index) {
            int lastIndex = this.dataArray[index].length - 1;
            if (this.dataArray[index][lastIndex] <= maxAttribute) continue;
            maxAttribute = this.dataArray[index][lastIndex];
        }
        this.numOneItemSets = this.numCols = maxAttribute;
    }

    protected short[] binConversion(StringTokenizer dataLine, int numberOfTokens) {
        short[] newItemSet = null;
        for (int tokenCounter = 0; tokenCounter < numberOfTokens; ++tokenCounter) {
            short number = new Short(dataLine.nextToken());
            newItemSet = this.realloc1(newItemSet, number);
        }
        return newItemSet;
    }

    public void idInputDataOrdering(DataBase dataBase) {
        int[][] countArray = this.countSingles(dataBase);
        this.orderCountArray(countArray);
        this.defConvertArrays(countArray);
        this.isOrderedFlag = true;
    }

    protected int[][] countSingles(DataBase dataBase) {
        int[][] countArray = new int[this.numCols + 1][2];
        for (int index = 0; index < countArray.length; ++index) {
            countArray[index][0] = index;
            countArray[index][1] = 0;
        }
        for (int rowIndex = 0; rowIndex < this.dataArray.length; ++rowIndex) {
            if (this.dataArray[rowIndex] == null) continue;
            for (int colIndex = 0; colIndex < this.dataArray[rowIndex].length; ++colIndex) {
                if (dataBase.numLabels(colIndex) <= 1) continue;
                int[] nArray = countArray[this.dataArray[rowIndex][colIndex]];
                nArray[1] = nArray[1] + 1;
            }
        }
        return countArray;
    }

    private void orderCountArray(int[][] countArray) {
        boolean isOrdered;
        do {
            isOrdered = true;
            int index = 1;
            while (index < countArray.length - 1) {
                if (countArray[index][1] >= countArray[index + 1][1]) {
                    ++index;
                    continue;
                }
                isOrdered = false;
                int attribute = countArray[index][0];
                int quantity = countArray[index][1];
                countArray[index][0] = countArray[index + 1][0];
                countArray[index][1] = countArray[index + 1][1];
                countArray[index + 1][0] = attribute;
                countArray[index + 1][1] = quantity;
                ++index;
            }
        } while (!isOrdered);
    }

    protected void orderFirstNofCountArray(int[][] countArray, int endIndex) {
        boolean isOrdered;
        do {
            isOrdered = true;
            int index = 1;
            while (index < endIndex) {
                if (countArray[index][1] >= countArray[index + 1][1]) {
                    ++index;
                    continue;
                }
                isOrdered = false;
                int attribute = countArray[index][0];
                int quantity = countArray[index][1];
                countArray[index][0] = countArray[index + 1][0];
                countArray[index][1] = countArray[index + 1][1];
                countArray[index + 1][0] = attribute;
                countArray[index + 1][1] = quantity;
                ++index;
            }
        } while (!isOrdered);
    }

    protected void defConvertArrays(int[][] countArray) {
        this.conversionArray = new int[this.numCols + 1][2];
        this.reconversionArray = new short[this.numCols + 1];
        for (int index = 1; index < countArray.length; ++index) {
            this.conversionArray[countArray[index][0]][0] = index;
            this.conversionArray[countArray[index][0]][1] = countArray[index][1];
            this.reconversionArray[index] = (short)countArray[index][0];
        }
    }

    public void recastInputData() {
        for (int rowIndex = 0; rowIndex < this.dataArray.length; ++rowIndex) {
            short[] itemSet = new short[this.dataArray[rowIndex].length];
            for (int colIndex = 0; colIndex < this.dataArray[rowIndex].length; ++colIndex) {
                short attribute = this.dataArray[rowIndex][colIndex];
                itemSet[colIndex] = (short)this.conversionArray[attribute][0];
            }
            this.sortItemSet(itemSet);
            this.dataArray[rowIndex] = itemSet;
        }
    }

    public void recastInputDataAndPruneUnsupportedAtts() {
        for (int rowIndex = 0; rowIndex < this.dataArray.length; ++rowIndex) {
            if (this.dataArray[rowIndex] == null) continue;
            short[] itemSet = null;
            for (int colIndex = 0; colIndex < this.dataArray[rowIndex].length; ++colIndex) {
                short attribute = this.dataArray[rowIndex][colIndex];
                if (!((double)this.conversionArray[attribute][1] >= this.minSupport)) continue;
                itemSet = this.reallocInsert(itemSet, (short)this.conversionArray[attribute][0]);
            }
            this.dataArray[rowIndex] = itemSet;
        }
        this.isPrunedFlag = true;
        this.numOneItemSets = this.getNumSupOneItemSets();
    }

    protected int getNumSupOneItemSets() {
        int counter = 0;
        for (int index = 1; index < this.conversionArray.length; ++index) {
            if (!((double)this.conversionArray[index][1] >= this.minSupport)) continue;
            ++counter;
        }
        return counter;
    }

    public void resizeInputData(double percentage) {
        this.numRows = (int)((double)this.numRows * (percentage / 100.0));
        System.out.println("Recast input data, new num rows = " + this.numRows);
        short[][] trainingSet = new short[this.numRows][];
        for (int index = 0; index < this.numRows; ++index) {
            trainingSet[index] = this.dataArray[index];
        }
        this.dataArray = trainingSet;
        this.minSupport = (double)this.numRows * this.support / 100.0;
    }

    protected short[] append(short[] itemSet1, short[] itemSet2) {
        if (itemSet1 == null) {
            return this.copyItemSet(itemSet2);
        }
        if (itemSet2 == null) {
            return this.copyItemSet(itemSet1);
        }
        short[] newItemSet = new short[itemSet1.length + itemSet2.length];
        for (int index1 = 0; index1 < itemSet1.length; ++index1) {
            newItemSet[index1] = itemSet1[index1];
        }
        for (int index2 = 0; index2 < itemSet2.length; ++index2) {
            newItemSet[index1 + index2] = itemSet2[index2];
        }
        return newItemSet;
    }

    protected short[] reallocInsert(short[] oldItemSet, short newElement) {
        if (oldItemSet == null) {
            short[] newItemSet = new short[]{newElement};
            return newItemSet;
        }
        int oldItemSetLength = oldItemSet.length;
        short[] newItemSet = new short[oldItemSetLength + 1];
        for (int index1 = 0; index1 < oldItemSetLength; ++index1) {
            if (newElement < oldItemSet[index1]) {
                newItemSet[index1] = newElement;
                for (int index2 = index1 + 1; index2 < newItemSet.length; ++index2) {
                    newItemSet[index2] = oldItemSet[index2 - 1];
                }
                return newItemSet;
            }
            newItemSet[index1] = oldItemSet[index1];
        }
        newItemSet[newItemSet.length - 1] = newElement;
        return newItemSet;
    }

    protected short[] realloc1(short[] oldItemSet, short newElement) {
        if (oldItemSet == null) {
            short[] newItemSet = new short[]{newElement};
            return newItemSet;
        }
        int oldItemSetLength = oldItemSet.length;
        short[] newItemSet = new short[oldItemSetLength + 1];
        for (int index = 0; index < oldItemSetLength; ++index) {
            newItemSet[index] = oldItemSet[index];
        }
        newItemSet[index] = newElement;
        return newItemSet;
    }

    protected short[] realloc2(short[] oldItemSet, short newElement) {
        if (oldItemSet == null) {
            short[] newItemSet = new short[]{newElement};
            return newItemSet;
        }
        int oldItemSetLength = oldItemSet.length;
        short[] newItemSet = new short[oldItemSetLength + 1];
        newItemSet[0] = newElement;
        for (int index = 0; index < oldItemSetLength; ++index) {
            newItemSet[index + 1] = oldItemSet[index];
        }
        return newItemSet;
    }

    protected short[] realloc3(short[] oldItemSet) {
        if (oldItemSet.length == 1) {
            return null;
        }
        int newItemSetLength = oldItemSet.length - 1;
        short[] newItemSet = new short[newItemSetLength];
        for (int index = 0; index < newItemSetLength; ++index) {
            newItemSet[index] = oldItemSet[index + 1];
        }
        return newItemSet;
    }

    protected short[] realloc4(short[] oldItemSet, short[] array2) {
        int array2length = array2.length;
        int newItemSetLength = oldItemSet.length - array2length;
        short[] newItemSet = new short[newItemSetLength];
        for (int index = 0; index < newItemSetLength; ++index) {
            newItemSet[index] = oldItemSet[index + array2length];
        }
        return newItemSet;
    }

    protected short[] removeFirstNelements(short[] oldItemSet, int n) {
        if (oldItemSet.length == n) {
            return null;
        }
        short[] newItemSet = new short[oldItemSet.length - n];
        for (int index = 0; index < newItemSet.length; ++index) {
            newItemSet[index] = oldItemSet[index + n];
        }
        return newItemSet;
    }

    protected short getLastElement(short[] itemSet) {
        if (itemSet == null) {
            return 0;
        }
        return itemSet[itemSet.length - 1];
    }

    protected short[] complement(short[] itemSet1, short[] itemSet2) {
        int lengthOfComp = itemSet2.length - itemSet1.length;
        if (lengthOfComp < 1) {
            return null;
        }
        short[] complement = new short[lengthOfComp];
        int complementIndex = 0;
        for (int index = 0; index < itemSet2.length; ++index) {
            if (!this.notMemberOf(itemSet2[index], itemSet1)) continue;
            complement[complementIndex] = itemSet2[index];
            ++complementIndex;
        }
        return complement;
    }

    protected void sortItemSet(short[] itemSet) {
        boolean isOrdered;
        do {
            isOrdered = true;
            int index = 0;
            while (index < itemSet.length - 1) {
                if (itemSet[index] <= itemSet[index + 1]) {
                    ++index;
                    continue;
                }
                isOrdered = false;
                short temp = itemSet[index];
                itemSet[index] = itemSet[index + 1];
                itemSet[index + 1] = temp;
                ++index;
            }
        } while (!isOrdered);
    }

    protected int checkItemSets(short[] itemSet1, short[] itemSet2) {
        if (this.isEqual(itemSet1, itemSet2)) {
            return 1;
        }
        if (AssocRuleMining.isBefore(itemSet1, itemSet2)) {
            if (this.isSubset(itemSet1, itemSet2)) {
                return 2;
            }
            return 3;
        }
        if (this.isSubset(itemSet2, itemSet1)) {
            return 4;
        }
        return 5;
    }

    protected boolean isEqual(short[] itemSet1, short[] itemSet2) {
        if (itemSet2 == null) {
            return false;
        }
        int length1 = itemSet1.length;
        int length2 = itemSet2.length;
        if (length1 != length2) {
            return false;
        }
        for (int index = 0; index < length1; ++index) {
            if (itemSet1[index] == itemSet2[index]) continue;
            return false;
        }
        return true;
    }

    public static boolean isBefore(short[] itemSet1, short[] itemSet2) {
        int length2 = itemSet2.length;
        for (int index1 = 0; index1 < itemSet1.length; ++index1) {
            if (index1 == length2) {
                return false;
            }
            if (itemSet1[index1] < itemSet2[index1]) {
                return true;
            }
            if (itemSet1[index1] <= itemSet2[index1]) continue;
            return false;
        }
        return true;
    }

    protected boolean isSubset(short[] itemSet1, short[] itemSet2) {
        if (itemSet1 == null) {
            return true;
        }
        if (itemSet2 == null) {
            return false;
        }
        for (int index1 = 0; index1 < itemSet1.length; ++index1) {
            if (!this.notMemberOf(itemSet1[index1], itemSet2)) continue;
            return false;
        }
        return true;
    }

    protected boolean notMemberOf(short number, short[] itemSet) {
        for (int index = 0; index < itemSet.length; ++index) {
            if (number < itemSet[index]) {
                return true;
            }
            if (number != itemSet[index]) continue;
            return false;
        }
        return true;
    }

    protected short[] checkForLeadingSubString(short[] itemSet1, short[] itemSet2) {
        short[] itemSet3 = null;
        for (int index = 0; index < itemSet1.length && index != itemSet2.length && itemSet1[index] == itemSet2[index]; ++index) {
            itemSet3 = this.realloc1(itemSet3, itemSet1[index]);
        }
        return itemSet3;
    }

    protected short[][] combinations(short[] inputSet) {
        if (inputSet == null) {
            return null;
        }
        short[][] outputSet = new short[this.getCombinations(inputSet)][];
        this.combinations(inputSet, 0, null, outputSet, 0);
        return outputSet;
    }

    private int combinations(short[] inputSet, int inputIndex, short[] sofar, short[][] outputSet, int outputIndex) {
        for (int index = inputIndex; index < inputSet.length; ++index) {
            short[] tempSet = this.realloc1(sofar, inputSet[index]);
            outputSet[outputIndex] = tempSet;
            outputIndex = this.combinations(inputSet, index + 1, this.copyItemSet(tempSet), outputSet, outputIndex + 1);
        }
        return outputIndex;
    }

    private int getCombinations(short[] set) {
        boolean counter = false;
        int numComb = (int)Math.pow(2.0, set.length) - 1;
        return numComb;
    }

    protected short[] copyItemSet(short[] itemSet) {
        if (itemSet == null) {
            return null;
        }
        short[] newItemSet = new short[itemSet.length];
        for (int index = 0; index < itemSet.length; ++index) {
            newItemSet[index] = itemSet[index];
        }
        return newItemSet;
    }

    protected short[][] copyItemSet(short[][] itemSets) {
        if (itemSets == null) {
            return null;
        }
        short[][] newItemSets = new short[itemSets.length][];
        for (int index1 = 0; index1 < itemSets.length; ++index1) {
            if (itemSets[index1] == null) {
                newItemSets[index1] = null;
                continue;
            }
            newItemSets[index1] = new short[itemSets[index1].length];
            for (int index2 = 0; index2 < itemSets[index1].length; ++index2) {
                newItemSets[index1][index2] = itemSets[index1][index2];
            }
        }
        return newItemSets;
    }

    public double getConfidence() {
        return this.confidence;
    }

    public void outputDataArray() {
        if (this.isPrunedFlag) {
            System.out.println("DATA SET (Ordered and Pruned)\n-----------------------------");
        } else if (this.isOrderedFlag) {
            System.out.println("DATA SET (Ordered)\n------------------");
        } else {
            System.out.println("DATA SET\n--------");
        }
        for (int index = 0; index < this.dataArray.length; ++index) {
            this.outputItemSet(this.dataArray[index]);
            System.out.println();
        }
    }

    protected void outputDataArray(short[][] dataSet) {
        if (dataSet == null) {
            System.out.println("null");
            return;
        }
        for (int index = 0; index < dataSet.length; ++index) {
            this.outputItemSet(dataSet[index]);
            System.out.println();
        }
    }

    protected String outputItemSet(short[] itemSet) {
        String stringOut = new String("");
        if (itemSet == null) {
            stringOut = " null ";
        } else {
            int counter = 0;
            for (int index = 0; index < itemSet.length; ++index) {
                if (counter == 0) {
                    ++counter;
                    stringOut = stringOut + " {";
                } else {
                    stringOut = stringOut + " ";
                }
                stringOut = stringOut + "" + itemSet[index];
            }
            stringOut = stringOut + "} ";
        }
        return stringOut;
    }

    protected void outputItemSetWithReconversion(short[] itemSet) {
        if (itemSet == null) {
            System.out.print(" null ");
        } else {
            int counter = 0;
            for (int index = 0; index < itemSet.length; ++index) {
                if (counter == 0) {
                    ++counter;
                    System.out.print(" [");
                } else {
                    System.out.print(" ");
                }
                System.out.print(this.reconversionArray[itemSet[index]]);
            }
            System.out.print("] ");
        }
    }

    public void outputDataArraySize() {
        int numRecords = 0;
        int numElements = 0;
        for (int index = 0; index < this.dataArray.length; ++index) {
            if (this.dataArray[index] == null) continue;
            ++numRecords;
            numElements += this.dataArray[index].length;
        }
        System.out.println("Number of records        = " + numRecords);
        System.out.println("Number of elements       = " + numElements);
    }

    public void outputConversionArrays() {
        int index;
        System.out.println("Conversion Array = ");
        for (index = 1; index < this.conversionArray.length; ++index) {
            System.out.println("(" + index + ") " + this.conversionArray[index][0] + " = " + this.conversionArray[index][1]);
        }
        System.out.println("Reonversion Array = ");
        for (index = 1; index < this.reconversionArray.length; ++index) {
            System.out.println("(" + index + ") " + this.reconversionArray[index]);
        }
    }

    protected void outputMenu() {
        System.out.println();
        System.out.println("-C  = Confidence (default 80%)");
        System.out.println("-F  = File name");
        System.out.println("-N  = Number of classes (Optional)");
        System.out.println("-S  = Support (default 20%)");
        System.out.println();
        System.exit(1);
    }

    protected void outputSettings() {
        System.out.println("SETTINGS\n--------");
        System.out.println("File name                = " + this.fileName);
        System.out.println("Support (default 20%)    = " + this.support);
        System.out.println("Confidence (default 80%) = " + this.confidence);
        System.out.println("Num. classes (Optional)  = " + this.numClasses);
        System.out.println();
    }

    protected void outputSettings2() {
        System.out.println("SETTINGS\n--------");
        System.out.println("Number of records        = " + this.numRows);
        System.out.println("Number of columns        = " + this.numCols);
        System.out.println("Support (default 20%)    = " + this.support);
        System.out.println("Confidence (default 80%) = " + this.confidence);
        System.out.println("Min support              = " + this.minSupport + " (records)");
        System.out.println("Num one itemsets         = " + this.numOneItemSets);
        System.out.println("Num. classes (Optional)  = " + this.numClasses);
    }

    public void outputSuppAndConf() {
        System.out.println("Support = " + this.twoDecPlaces(this.support) + ", Confidence = " + this.twoDecPlaces(this.confidence));
    }

    public double outputDuration(double time1, double time2) {
        double duration = (time2 - time1) / 1000.0;
        System.out.println("Generation time = " + duration + " seconds (" + duration / 60.0 + " mins)");
        return duration;
    }

    protected String getDuration(double time1, double time2) {
        double duration = (time2 - time1) / 1000.0;
        return "Generation time = " + duration + " seconds (" + duration / 60.0 + " mins)";
    }

    protected boolean similar2dec(double number1, double number2) {
        int numInt1 = (int)((number1 + 0.005) * 100.0);
        int numInt2 = (int)((number2 + 0.005) * 100.0);
        return numInt1 == numInt2;
    }

    protected double twoDecPlaces(double number) {
        int numInt = (int)((number + 0.005) * 100.0);
        number = (double)numInt / 100.0;
        return number;
    }

    protected double threeDecPlaces(double number) {
        int numInt = (int)((number + 5.0E-4) * 1000.0);
        number = (double)numInt / 1000.0;
        return number;
    }
}

