/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.ImbalancedClassification.Ensembles.Basic;

import java.util.StringTokenizer;
import keel.Algorithms.ImbalancedClassification.Ensembles.Basic.CheckException;
import keel.Dataset.Attribute;
import keel.Dataset.Attributes;
import keel.Dataset.Instance;
import keel.Dataset.InstanceSet;

public class Metodo {
    protected String ficheroTraining;
    protected String ficheroTest;
    protected String[] ficheroSalida;
    protected InstanceSet training;
    protected InstanceSet test;
    protected Attribute[] entradas;
    protected Attribute salida;
    protected int nEntradas;
    protected String relation;
    protected double[][] datosTrain;
    protected int[] clasesTrain;
    protected boolean[][] nulosTrain;
    protected int[][] nominalTrain;
    protected double[][] realTrain;
    protected boolean distanceEu;
    protected static double[][][] nominalDistance;
    protected static double[] stdDev;

    public Metodo() {
    }

    public Metodo(String ficheroScript) {
        this.distanceEu = false;
        this.leerConfiguracion(ficheroScript);
        try {
            this.training = new InstanceSet();
            this.training.readSet(this.ficheroTraining, false);
            this.normalizar();
        }
        catch (Exception e) {
            System.err.println(e);
            System.exit(1);
        }
        try {
            this.test = new InstanceSet();
            this.test.readSet(this.ficheroTest, false);
        }
        catch (Exception e) {
            System.err.println(e);
            System.exit(1);
        }
        if (!this.distanceEu) {
            stdDev = new double[Attributes.getInputNumAttributes()];
            nominalDistance = new double[Attributes.getInputNumAttributes()][][];
            int nClases = Attributes.getOutputAttribute(0).getNumNominalValues();
            for (int i = 0; i < nominalDistance.length; ++i) {
                int j;
                if (Attributes.getInputAttribute(i).getType() == 0) {
                    Metodo.nominalDistance[i] = new double[Attributes.getInputAttribute(i).getNumNominalValues()][Attributes.getInputAttribute(i).getNumNominalValues()];
                    for (j = 0; j < Attributes.getInputAttribute(i).getNumNominalValues(); ++j) {
                        Metodo.nominalDistance[i][j][j] = 0.0;
                    }
                    for (j = 0; j < Attributes.getInputAttribute(i).getNumNominalValues(); ++j) {
                        for (int l = j + 1; l < Attributes.getInputAttribute(i).getNumNominalValues(); ++l) {
                            int m;
                            double VDM = 0.0;
                            int Nay = 0;
                            int Nax = 0;
                            for (m = 0; m < this.training.getNumInstances(); ++m) {
                                if (this.nominalTrain[m][i] == j) {
                                    ++Nax;
                                }
                                if (this.nominalTrain[m][i] != l) continue;
                                ++Nay;
                            }
                            for (m = 0; m < nClases; ++m) {
                                int Nayc = 0;
                                int Naxc = 0;
                                for (int n = 0; n < this.training.getNumInstances(); ++n) {
                                    if (this.nominalTrain[n][i] == j && this.clasesTrain[n] == m) {
                                        ++Naxc;
                                    }
                                    if (this.nominalTrain[n][i] != l || this.clasesTrain[n] != m) continue;
                                    ++Nayc;
                                }
                                VDM += ((double)Naxc / (double)Nax - (double)Nayc / (double)Nay) * ((double)Naxc / (double)Nax - (double)Nayc / (double)Nay);
                            }
                            Metodo.nominalDistance[i][j][l] = Math.sqrt(VDM);
                            Metodo.nominalDistance[i][l][j] = Math.sqrt(VDM);
                        }
                    }
                    continue;
                }
                double media = 0.0;
                double SD = 0.0;
                for (j = 0; j < this.training.getNumInstances(); ++j) {
                    media += this.realTrain[j][i];
                    SD += this.realTrain[j][i] * this.realTrain[j][i];
                }
                Metodo.stdDev[i] = Math.sqrt(Math.abs(SD / (double)this.realTrain.length - (media /= (double)this.realTrain.length) * media));
            }
        }
    }

    protected void normalizar() throws CheckException {
        int i;
        if (Attributes.getOutputNumAttributes() < 1) {
            throw new CheckException("This dataset haven\u00ef\u00bf\u00bdt outputs, so it not corresponding to a classification problem.");
        }
        if (Attributes.getOutputNumAttributes() > 1) {
            throw new CheckException("This dataset have more of one output.");
        }
        if (Attributes.getOutputAttribute(0).getType() == 2) {
            throw new CheckException("This dataset have an input attribute with floating values, so it not corresponding to a classification problem.");
        }
        this.entradas = Attributes.getInputAttributes();
        this.salida = Attributes.getOutputAttribute(0);
        this.nEntradas = Attributes.getInputNumAttributes();
        StringTokenizer tokens = new StringTokenizer(this.training.getHeader(), " \n\r");
        tokens.nextToken();
        this.relation = tokens.nextToken();
        this.datosTrain = new double[this.training.getNumInstances()][Attributes.getInputNumAttributes()];
        this.clasesTrain = new int[this.training.getNumInstances()];
        double[] caja = new double[1];
        this.nulosTrain = new boolean[this.training.getNumInstances()][Attributes.getInputNumAttributes()];
        this.nominalTrain = new int[this.training.getNumInstances()][Attributes.getInputNumAttributes()];
        this.realTrain = new double[this.training.getNumInstances()][Attributes.getInputNumAttributes()];
        double[] emin = new double[Attributes.getInputNumAttributes()];
        double[] emax = new double[Attributes.getInputNumAttributes()];
        for (i = 0; i < Attributes.getInputNumAttributes(); ++i) {
            emin[i] = Double.MAX_VALUE;
            emax[i] = Double.MIN_VALUE;
        }
        for (i = 0; i < this.training.getNumInstances(); ++i) {
            Instance temp = this.training.getInstance(i);
            boolean[] nulls = temp.getInputMissingValues();
            this.datosTrain[i] = (double[])this.training.getInstance(i).getAllInputValues().clone();
            for (int j = 0; j < nulls.length; ++j) {
                if (this.datosTrain[i][j] < emin[j]) {
                    emin[j] = this.datosTrain[i][j];
                }
                if (this.datosTrain[i][j] > emax[j]) {
                    emax[j] = this.datosTrain[i][j];
                }
                if (!nulls[j]) continue;
                this.datosTrain[i][j] = 0.0;
                this.nulosTrain[i][j] = true;
            }
            caja = (double[])this.training.getInstance(i).getAllOutputValues().clone();
            this.clasesTrain[i] = (int)caja[0];
        }
        for (i = 0; i < this.training.getNumInstances(); ++i) {
            for (int k = 0; k < this.datosTrain[i].length; ++k) {
                if (Attributes.getInputAttribute(k).getType() == 0) {
                    this.nominalTrain[i][k] = (int)this.datosTrain[i][k];
                    double[] dArray = this.datosTrain[i];
                    int n = k;
                    dArray[n] = dArray[n] / (double)(Attributes.getInputAttribute(k).getNominalValuesList().size() - 1);
                    continue;
                }
                this.realTrain[i][k] = this.datosTrain[i][k];
                double[] dArray = this.datosTrain[i];
                int n = k;
                dArray[n] = dArray[n] - emin[k];
                double[] dArray2 = this.datosTrain[i];
                int n2 = k;
                dArray2[n2] = dArray2[n2] / (emax[k] - emin[k]);
            }
        }
        for (i = 0; i < Attributes.getInputNumAttributes(); ++i) {
            this.entradas[i].setBounds(emin[i], emax[i]);
        }
    }

    public void leerConfiguracion(String ficheroScript) {
    }
}

