/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Rule_Learning.PART;

import java.util.Vector;
import keel.Algorithms.Rule_Learning.PART.Mask;
import keel.Algorithms.Rule_Learning.PART.MyDataset;
import keel.Algorithms.Rule_Learning.PART.Rule;
import keel.Algorithms.Rule_Learning.PART.Stats;

public class Ruleset {
    private Vector rules = new Vector();
    private String type;

    public void addRule(Rule r) {
        this.rules.add(r);
    }

    public Stats apply(MyDataset data) {
        Stats stats = new Stats();
        Mask positives = new Mask(data.size());
        data.filterByClass(positives, this.type);
        Mask negatives = positives.complement();
        int npositives = positives.getnActive();
        int nnegatives = negatives.getnActive();
        for (int i = 0; i < this.rules.size(); ++i) {
            data.substract(positives, (Rule)this.rules.elementAt(i));
            data.substract(negatives, (Rule)this.rules.elementAt(i));
        }
        stats.fn = positives.getnActive();
        stats.tp = npositives - stats.fn;
        stats.tn = negatives.getnActive();
        stats.fp = nnegatives - stats.tn;
        return stats;
    }

    public Stats apply(MyDataset data, Mask positives, Mask negatives) {
        Stats stats = new Stats();
        int npositives = positives.getnActive();
        int nnegatives = negatives.getnActive();
        Mask p = positives.copy();
        Mask n = negatives.copy();
        for (int i = 0; i < this.rules.size(); ++i) {
            data.substract(p, (Rule)this.rules.elementAt(i));
            data.substract(n, (Rule)this.rules.elementAt(i));
        }
        stats.fn = p.getnActive();
        stats.tp = npositives - stats.fn;
        stats.tn = n.getnActive();
        stats.fp = nnegatives - stats.tn;
        return stats;
    }

    public double getMDL(MyDataset data, Mask positives, Mask negatives) {
        Stats quartet = this.apply(data, positives, negatives);
        double tp = quartet.tp;
        double tn = quartet.tn;
        double fp = quartet.fp;
        double fn = quartet.fn;
        double U = tn + fn;
        double C = tp + fp;
        double D = U + C;
        double e = fn + fp;
        double mdl = Double.MAX_VALUE;
        if (C != 0.0 && U != 0.0) {
            double fn_prob;
            double tn_prob;
            double fp_prob;
            double tp_prob;
            if (C >= U) {
                double aux_prob1 = e / (2.0 * C);
                double aux_prob2 = fn / U;
                tp_prob = 1.0 - aux_prob1 == 0.0 ? tp : tp * -Math.log(1.0 - aux_prob1);
                fp_prob = aux_prob1 == 0.0 ? fp : fp * -Math.log(aux_prob1);
                tn_prob = 1.0 - aux_prob2 == 0.0 ? tn : tn * -Math.log(1.0 - aux_prob2);
                fn_prob = aux_prob2 == 0.0 ? fp : fp * -Math.log(aux_prob2);
            } else {
                double aux_prob1 = fp / C;
                double aux_prob2 = e / (2.0 * U);
                tp_prob = 1.0 - aux_prob1 == 0.0 ? tp : tp * -Math.log(1.0 - aux_prob1);
                fp_prob = aux_prob1 == 0.0 ? fp : fp * -Math.log(aux_prob1);
                tn_prob = 1.0 - aux_prob2 == 0.0 ? tn : tn * -Math.log(1.0 - aux_prob2);
                fn_prob = aux_prob2 == 0.0 ? fp : fp * -Math.log(aux_prob2);
            }
            mdl = Math.log(D + 1.0) + tp_prob + tn_prob + fp_prob + fn_prob;
        }
        return mdl;
    }

    public double getMDL(MyDataset data) {
        Mask positives = new Mask(data.size());
        data.filterByClass(positives, this.type);
        Mask negatives = positives.complement();
        return this.getMDL(data, positives, negatives);
    }

    public Rule getRule(int pos) {
        return (Rule)this.rules.elementAt(pos);
    }

    public String getType() {
        return this.type;
    }

    public void insertRule(Rule r, int pos) {
        this.rules.insertElementAt(r, pos);
    }

    public void removeRule(int pos) {
        this.rules.remove(pos);
    }

    public void setType(String type) {
        this.type = type;
    }

    public int size() {
        return this.rules.size();
    }

    public String toString() {
        String output = "";
        for (int i = 0; i < this.rules.size(); ++i) {
            output = output + ((Rule)this.rules.elementAt(i)).toString() + " -> " + this.type + "\n";
        }
        return output;
    }
}

