/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.MOEA_Ghosh;

import org.core.Randomize;

public class Gene {
    public static final int NOT_INVOLVED = 0;
    public static final int ANTECEDENT = 1;
    public static final int CONSEQUENT = 2;
    public static final int MINOR = 1;
    public static final int MAJOR = 2;
    public static final int EQUAL = 3;
    public static final int UNEQUAL = 4;
    private int attr;
    private int ac;
    private int operator;
    private double value;

    public Gene copy() {
        Gene gene = new Gene();
        gene.attr = this.attr;
        gene.ac = this.ac;
        gene.operator = this.operator;
        gene.value = this.value;
        return gene;
    }

    public int getActAs() {
        return this.ac;
    }

    public void setActAs(int ac) {
        this.ac = ac;
    }

    public boolean equals(Gene g) {
        return g.attr == this.attr && g.ac == this.ac && g.operator == this.operator && g.value == this.value;
    }

    public String toString() {
        return "Attr: " + this.attr + "AC: " + this.ac + "; Operator: " + this.operator + "; Value: " + this.value;
    }

    public int getAttr() {
        return this.attr;
    }

    public void setAttr(int var) {
        this.attr = var;
    }

    public int randAct() {
        return Randomize.RandintClosed(0, 2);
    }

    public int randOperatorNumeric() {
        return Randomize.RandintClosed(1, 2);
    }

    public int randOperatorNominal() {
        return Randomize.RandintClosed(3, 4);
    }

    public boolean isCover(int var, double value) {
        if (this.attr != var) {
            return false;
        }
        boolean covered = true;
        if (this.operator == 2) {
            if (value < this.value) {
                covered = false;
            }
        } else if (this.operator == 1) {
            if (value > this.value) {
                covered = false;
            }
        } else if (this.operator == 3) {
            if (value != this.value) {
                covered = false;
            }
        } else if (this.operator == 4 && value == this.value) {
            covered = false;
        }
        return covered;
    }

    public int getOperator() {
        return this.operator;
    }

    public void setOperator(int operator) {
        this.operator = operator;
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double value) {
        this.value = value;
    }
}

