/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.UnsupervisedLearning.AssociationRules.FuzzyRuleLearning.Alcalaetal;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.FuzzyRuleLearning.Alcalaetal.AlcalaetalProcess;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.FuzzyRuleLearning.Alcalaetal.AssociationRule;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.FuzzyRuleLearning.Alcalaetal.FuzzyAttribute;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.FuzzyRuleLearning.Alcalaetal.FuzzyRegion;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.FuzzyRuleLearning.Alcalaetal.Item;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.FuzzyRuleLearning.Alcalaetal.Itemset;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.FuzzyRuleLearning.Alcalaetal.myDataset;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.FuzzyRuleLearning.Alcalaetal.parseParameters;
import org.core.Randomize;

public class Alcalaetal {
    private myDataset trans;
    private String rulesFilename;
    private String valuesFilename;
    private String uniformFuzzyAttributesFilename;
    private String adjustedFuzzyAttributesFilename;
    private String geneticLearningLogFilename;
    private AlcalaetalProcess proc;
    private ArrayList<AssociationRule> associationRulesSet;
    private int nEvaluations;
    private int popSize;
    private int nBitsGene;
    private double phi;
    private double d;
    private int nFuzzyRegionsForNumericAttributes;
    private boolean useMaxForOneFrequentItemsets;
    private double minSupport;
    private double minConfidence;
    private boolean somethingWrong = false;

    public Alcalaetal() {
    }

    public Alcalaetal(parseParameters parameters) {
        this.rulesFilename = parameters.getAssociationRulesFile();
        this.adjustedFuzzyAttributesFilename = parameters.getOutputFile(0);
        this.valuesFilename = parameters.getOutputFile(1);
        this.uniformFuzzyAttributesFilename = parameters.getOutputFile(2);
        this.geneticLearningLogFilename = parameters.getOutputFile(3);
        try {
            System.out.println("\nReading the transaction set: " + parameters.getTransactionsInputFile());
            this.trans = new myDataset();
            this.trans.readDataSet(parameters.getTransactionsInputFile());
        }
        catch (IOException e) {
            System.err.println("There was a problem while reading the input transaction set: " + e);
            this.somethingWrong = true;
        }
        long seed = Long.parseLong(parameters.getParameter(0));
        this.nEvaluations = Integer.parseInt(parameters.getParameter(1));
        this.popSize = Integer.parseInt(parameters.getParameter(2));
        this.nBitsGene = Integer.parseInt(parameters.getParameter(3));
        this.phi = Double.parseDouble(parameters.getParameter(4));
        this.d = Double.parseDouble(parameters.getParameter(5));
        this.nFuzzyRegionsForNumericAttributes = Integer.parseInt(parameters.getParameter(6));
        this.useMaxForOneFrequentItemsets = Boolean.parseBoolean(parameters.getParameter(7));
        this.minSupport = Double.parseDouble(parameters.getParameter(8));
        this.minConfidence = Double.parseDouble(parameters.getParameter(9));
        Randomize.setSeed(seed);
    }

    public void execute() {
        if (this.somethingWrong) {
            System.err.println("An error was found");
            System.err.println("Aborting the program");
        } else {
            this.proc = new AlcalaetalProcess(this.trans, this.nEvaluations, this.popSize, this.nBitsGene, this.phi, this.d, this.nFuzzyRegionsForNumericAttributes, this.useMaxForOneFrequentItemsets, this.minSupport, this.minConfidence);
            this.proc.run();
            this.associationRulesSet = this.proc.getRulesSet();
            this.proc.printReport(this.associationRulesSet);
            try {
                this.saveFuzzyAttributes(this.uniformFuzzyAttributesFilename, this.proc.getUniformFuzzyAttributes());
                this.saveFuzzyAttributes(this.adjustedFuzzyAttributesFilename, this.proc.getAdjustedFuzzyAttributes());
                this.saveGeneticLearningLog(this.geneticLearningLogFilename, this.proc.getGeneticLearningLog());
                PrintWriter rules_writer = new PrintWriter(this.rulesFilename);
                PrintWriter values_writer = new PrintWriter(this.valuesFilename);
                rules_writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                rules_writer.println("<rules>");
                values_writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                values_writer.print("<values ");
                values_writer.println("n_one_frequent_itemsets=\"" + this.proc.getNumberOfOneFrequentItemsets() + "\" n_rules=\"" + this.associationRulesSet.size() + "\">");
                for (int r = 0; r < this.associationRulesSet.size(); ++r) {
                    int i;
                    AssociationRule ar = this.associationRulesSet.get(r);
                    rules_writer.println("<rule id = \"" + r + "\">");
                    values_writer.println("<rule id=\"" + r + "\" rule_support=\"" + ar.getRuleSupport() + "\" antecedent_support=\"" + ar.getAntecedentSupport() + "\" consequent_support=\"" + ar.getConsequentSupport() + "\" confidence=\"" + ar.getConfidence() + "\"/>");
                    rules_writer.println("<antecedents>");
                    Itemset itemset = ar.getAntecedent();
                    for (i = 0; i < itemset.size(); ++i) {
                        this.createRule(itemset.get(i), this.proc.getAdjustedFuzzyAttributes(), rules_writer);
                    }
                    rules_writer.println("</antecedents>");
                    rules_writer.println("<consequents>");
                    itemset = ar.getConsequent();
                    for (i = 0; i < itemset.size(); ++i) {
                        this.createRule(itemset.get(i), this.proc.getAdjustedFuzzyAttributes(), rules_writer);
                    }
                    rules_writer.println("</consequents>");
                    rules_writer.println("</rule>");
                }
                rules_writer.println("</rules>");
                values_writer.println("</values>");
                rules_writer.close();
                values_writer.close();
                System.out.println("\nAlgorithm Finished");
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    private void createRule(Item item, ArrayList<FuzzyAttribute> fuzzy_attributes, PrintWriter w) {
        int attr = item.getIDAttribute();
        if (this.trans.isNominal(attr)) {
            w.print("<attribute name = \"" + this.trans.getAttributeName(attr) + "\" value=\"");
            w.print("" + this.trans.getNominalValue(attr, item.getIDLabel()));
        } else {
            boolean stop = false;
            FuzzyAttribute fuzzy_attr = fuzzy_attributes.get(0);
            for (int i = 0; i < fuzzy_attributes.size() && !stop; ++i) {
                fuzzy_attr = fuzzy_attributes.get(i);
                if (fuzzy_attr.getIdAttr() != item.getIDAttribute()) continue;
                stop = true;
            }
            FuzzyRegion[] fuzzy_regions = fuzzy_attr.getFuzzyRegions();
            w.print("<attribute name = \"" + this.trans.getAttributeName(fuzzy_attr.getIdAttr()) + "\" value = \"");
            w.print(fuzzy_regions[item.getIDLabel()].getLabel());
        }
        w.println("\" />");
    }

    private void saveFuzzyAttributes(String fuzzy_attrs_fname, ArrayList<FuzzyAttribute> fuzzy_attributes) throws FileNotFoundException {
        PrintWriter fuzzy_attrs_writer = new PrintWriter(fuzzy_attrs_fname);
        fuzzy_attrs_writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        fuzzy_attrs_writer.println("<data_base>");
        for (int attr = 0; attr < this.trans.getnVars(); ++attr) {
            int region;
            if (this.trans.isNominal(attr)) {
                fuzzy_attrs_writer.println("<attribute name = \"" + this.trans.getAttributeName(attr) + "\" nValues = \"" + this.trans.nValueNominal(attr) + "\" Type = \"" + this.trans.getAttributeTypeString(attr) + "\" >");
                for (region = 0; region < this.trans.nValueNominal(attr); ++region) {
                    fuzzy_attrs_writer.println("<value x=\"" + this.trans.getNominalValue(attr, region) + "\" />");
                }
            } else {
                fuzzy_attrs_writer.println("<attribute name = \"" + this.trans.getAttributeName(attr) + "\" nValues = \"" + this.nFuzzyRegionsForNumericAttributes + "\" Type = \"" + this.trans.getAttributeTypeString(attr) + "\" >");
                boolean stop = false;
                FuzzyAttribute fuzzy_attr = fuzzy_attributes.get(0);
                for (int i = 0; i < fuzzy_attributes.size() && !stop; ++i) {
                    fuzzy_attr = fuzzy_attributes.get(i);
                    if (fuzzy_attr.getIdAttr() != attr) continue;
                    stop = true;
                }
                FuzzyRegion[] fuzzy_regions = fuzzy_attr.getFuzzyRegions();
                for (region = 0; region < fuzzy_regions.length; ++region) {
                    fuzzy_attrs_writer.print("<value labelname=\"" + fuzzy_regions[region].getLabel() + "\" ");
                    fuzzy_attrs_writer.print("x1=\"" + fuzzy_regions[region].getX0() + "\" ");
                    fuzzy_attrs_writer.print("x2=\"" + fuzzy_regions[region].getX1() + "\" ");
                    fuzzy_attrs_writer.println("x3=\"" + fuzzy_regions[region].getX3() + "\" />");
                }
            }
            fuzzy_attrs_writer.println("</attribute>");
        }
        fuzzy_attrs_writer.println("</data_base>");
        fuzzy_attrs_writer.close();
    }

    private void saveGeneticLearningLog(String genetic_learning_log_fname, String xml_str) throws FileNotFoundException {
        PrintWriter genetic_learning_log_writer = new PrintWriter(genetic_learning_log_fname);
        genetic_learning_log_writer.println(xml_str);
        genetic_learning_log_writer.close();
    }
}

