/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Neural_Networks.gann;

import keel.Algorithms.Neural_Networks.gann.ConnNetwork;
import keel.Algorithms.Neural_Networks.gann.Data;
import keel.Algorithms.Neural_Networks.gann.Parameters;
import keel.Algorithms.Neural_Networks.gann.Rand;
import keel.Algorithms.Neural_Networks.gann.SetupParameters;

public class Individual {
    int size;
    boolean[] connect;
    double[] w;

    public Individual(int s) {
        this.size = s;
        this.connect = new boolean[s];
        this.w = new double[s];
    }

    public Individual(SetupParameters global) {
        int i;
        this.size = global.Ninputs * global.Nhidden[0];
        for (i = 1; i < global.Nhidden_layers; ++i) {
            this.size += global.Nhidden[i] * global.Nhidden[i - 1];
        }
        this.size += global.Noutputs * global.Nhidden[global.Nhidden_layers - 1];
        this.connect = new boolean[this.size];
        this.w = new double[this.size];
        for (i = 0; i < this.size; ++i) {
            if (Rand.frandom(0.0, 1.0) < global.connectivity) {
                this.connect[i] = true;
                this.w[i] = Rand.frandom(-global.w_range, global.w_range);
                continue;
            }
            this.connect[i] = false;
            this.w[i] = 0.0;
        }
    }

    void TwoPointsCrossover(SetupParameters global, Individual father, Individual mother, Data data) {
        double daughter_fitness;
        int i;
        Individual son = new Individual(this.size);
        Individual daughter = new Individual(this.size);
        int one = Rand.irandom(0.0, this.size);
        int two = Rand.irandom(one, this.size);
        for (i = 0; i < one; ++i) {
            son.connect[i] = father.connect[i];
            son.w[i] = father.w[i];
            daughter.connect[i] = mother.connect[i];
            daughter.w[i] = mother.w[i];
        }
        for (i = one; i < two; ++i) {
            son.connect[i] = mother.connect[i];
            son.w[i] = mother.w[i];
            daughter.connect[i] = father.connect[i];
            daughter.w[i] = father.w[i];
        }
        for (i = two; i < this.size; ++i) {
            son.connect[i] = father.connect[i];
            son.w[i] = father.w[i];
            daughter.connect[i] = mother.connect[i];
            daughter.w[i] = mother.w[i];
        }
        double son_fitness = son.EvaluateIndividual(global, data);
        if (son_fitness > (daughter_fitness = daughter.EvaluateIndividual(global, data))) {
            son.CopyIndividualTo(this);
        } else {
            daughter.CopyIndividualTo(this);
        }
    }

    void ParametricMutation(SetupParameters global) {
        for (int i = 0; i < this.size; ++i) {
            if (!this.connect[i]) continue;
            int n = i;
            this.w[n] = this.w[n] + Rand.Normal(0.0, 1.0);
        }
    }

    void BPMutation(SetupParameters global, double[][] data, int n) {
        ConnNetwork net = new ConnNetwork((Parameters)global);
        this.PhenotypeToNetwork(net);
        net.BackPropagation(global, global.cycles, data, n);
        this.NetworkToGenotype(net);
    }

    void StructuralMutation(SetupParameters global) {
        int i = Rand.irandom(0.0, this.size);
        boolean bl = this.connect[i] = !this.connect[i];
        if (this.connect[i]) {
            this.w[i] = Rand.frandom(-global.w_range, global.w_range);
        }
    }

    void CopyIndividualTo(Individual dest) {
        for (int i = 0; i < this.size; ++i) {
            dest.connect[i] = this.connect[i];
            dest.w[i] = this.w[i];
        }
    }

    double EvaluateIndividual(SetupParameters global, Data data) {
        double fitness = 0.0;
        ConnNetwork net = new ConnNetwork((Parameters)global);
        this.PhenotypeToNetwork(net);
        if (global.problem.compareToIgnoreCase("Classification") == 0) {
            fitness = net.TestNetworkInClassification(global, data.train, global.n_train_patterns);
        } else if (global.problem.compareToIgnoreCase("Regression") == 0) {
            fitness = net.TestNetworkInRegression(global, data.train, global.n_train_patterns);
        }
        return fitness;
    }

    void NetworkToGenotype(ConnNetwork net) {
        int l = 0;
        for (int i = 0; i < net.Nlayers - 1; ++i) {
            for (int j = 0; j < net.Nhidden[i + 1]; ++j) {
                for (int k = 0; k < net.Nhidden[i]; ++k) {
                    if (net.conns[i][j][k]) {
                        this.w[l] = net.w[i][j][k];
                        this.connect[l] = true;
                    } else {
                        this.w[l] = 0.0;
                        this.connect[l] = false;
                    }
                    ++l;
                }
            }
        }
    }

    void PhenotypeToNetwork(ConnNetwork net) {
        int l = 0;
        for (int i = 0; i < net.Nlayers - 1; ++i) {
            for (int j = 0; j < net.Nhidden[i + 1]; ++j) {
                for (int k = 0; k < net.Nhidden[i]; ++k) {
                    if (this.connect[l]) {
                        net.w[i][j][k] = this.w[l];
                        net.conns[i][j][k] = true;
                    } else {
                        net.w[i][j][k] = 0.0;
                        net.conns[i][j][k] = false;
                    }
                    ++l;
                }
            }
        }
    }
}

