/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jclec.syntaxtree;

import net.sourceforge.jclec.IConfigure;
import net.sourceforge.jclec.ISpecies;
import net.sourceforge.jclec.base.AbstractMutator;
import net.sourceforge.jclec.syntaxtree.IMutateSyntaxTree;
import net.sourceforge.jclec.syntaxtree.SyntaxTree;
import net.sourceforge.jclec.syntaxtree.SyntaxTreeIndividual;
import net.sourceforge.jclec.syntaxtree.SyntaxTreeSchema;
import net.sourceforge.jclec.syntaxtree.SyntaxTreeSpecies;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationRuntimeException;

public class SyntaxTreeMutator
extends AbstractMutator
implements IConfigure {
    private static final long serialVersionUID = 450351162139336504L;
    protected transient SyntaxTreeSpecies species;
    protected transient SyntaxTreeSchema schema;
    protected IMutateSyntaxTree baseOp;

    public IMutateSyntaxTree getBaseOp() {
        return this.baseOp;
    }

    public void setBaseOp(IMutateSyntaxTree baseOp) {
        this.baseOp = baseOp;
    }

    @Override
    public void configure(Configuration settings) {
        try {
            String baseOpClassname = settings.getString("base-op[@type]");
            Class<?> baseOpClass = Class.forName(baseOpClassname);
            IMutateSyntaxTree baseOp = (IMutateSyntaxTree)baseOpClass.newInstance();
            if (baseOp instanceof IConfigure) {
                ((IConfigure)((Object)baseOp)).configure(settings.subset("base-op"));
            }
            this.setBaseOp(baseOp);
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationRuntimeException("Illegal operator classname");
        }
        catch (InstantiationException e) {
            throw new ConfigurationRuntimeException("Problems creating an instance of operator", e);
        }
        catch (IllegalAccessException e) {
            throw new ConfigurationRuntimeException("Problems creating an instance of operator", e);
        }
    }

    @Override
    protected void prepareMutation() {
        ISpecies species = this.context.getSpecies();
        if (!(species instanceof SyntaxTreeSpecies)) {
            throw new IllegalStateException("Invalid species in context");
        }
        this.species = (SyntaxTreeSpecies)species;
        this.schema = ((SyntaxTreeSpecies)species).getGenotypeSchema();
    }

    @Override
    protected void mutateNext() {
        SyntaxTree parentGenotype = (SyntaxTree)((SyntaxTreeIndividual)this.parentsBuffer.get(this.parentsCounter)).getGenotype();
        SyntaxTree sonGenotype = this.baseOp.mutateSyntaxTree(parentGenotype, this.schema, this.randgen);
        this.sonsBuffer.add(this.species.createIndividual(sonGenotype));
    }
}

