/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Associative_Classification.ClassifierFuzzyFARCHD;

import java.util.ArrayList;
import java.util.Collections;
import keel.Algorithms.Associative_Classification.ClassifierFuzzyFARCHD.DataBase;
import keel.Algorithms.Associative_Classification.ClassifierFuzzyFARCHD.ExampleWeight;
import keel.Algorithms.Associative_Classification.ClassifierFuzzyFARCHD.Item;
import keel.Algorithms.Associative_Classification.ClassifierFuzzyFARCHD.Itemset;
import keel.Algorithms.Associative_Classification.ClassifierFuzzyFARCHD.Rule;
import keel.Algorithms.Associative_Classification.ClassifierFuzzyFARCHD.myDataset;
import org.core.Files;

public class RuleBase {
    ArrayList<Rule> ruleBase;
    DataBase dataBase;
    myDataset train;
    int n_variables;
    int K;
    int nUncover;
    int typeInference;
    int defaultRule;
    int[] nUncoverClas;
    double fitness;

    public boolean BETTER(int a, int b) {
        return a > b;
    }

    public RuleBase() {
    }

    public RuleBase(DataBase dataBase, myDataset train, int K, int typeInference) {
        this.ruleBase = new ArrayList();
        this.dataBase = dataBase;
        this.train = train;
        this.n_variables = dataBase.numVariables();
        this.fitness = 0.0;
        this.K = K;
        this.typeInference = typeInference;
        this.defaultRule = -1;
        this.nUncover = 0;
        this.nUncoverClas = new int[this.train.getnClasses()];
    }

    public RuleBase clone() {
        int i;
        RuleBase br = new RuleBase();
        br.ruleBase = new ArrayList();
        for (i = 0; i < this.ruleBase.size(); ++i) {
            br.ruleBase.add(this.ruleBase.get(i).clone());
        }
        br.dataBase = this.dataBase;
        br.train = this.train;
        br.n_variables = this.n_variables;
        br.fitness = this.fitness;
        br.K = this.K;
        br.typeInference = this.typeInference;
        br.defaultRule = this.defaultRule;
        br.nUncover = this.nUncover;
        br.nUncoverClas = new int[this.train.getnClasses()];
        for (i = 0; i < this.train.getnClasses(); ++i) {
            br.nUncoverClas[i] = this.nUncoverClas[i];
        }
        return br;
    }

    public void add(Rule rule) {
        this.ruleBase.add(rule);
    }

    public void add(RuleBase ruleBase) {
        for (int i = 0; i < ruleBase.size(); ++i) {
            this.ruleBase.add(ruleBase.get(i).clone());
        }
    }

    public void add(Itemset itemset) {
        int i;
        int[] antecedent = new int[this.n_variables];
        for (i = 0; i < this.n_variables; ++i) {
            antecedent[i] = -1;
        }
        for (i = 0; i < itemset.size(); ++i) {
            Item item = itemset.get(i);
            antecedent[item.getVariable()] = item.getValue();
        }
        Rule r = new Rule(this.dataBase);
        r.asignaAntecedente(antecedent);
        r.setConsequent(itemset.getClas());
        r.setConfidence(itemset.getSupportClass() / itemset.getSupport());
        r.setSupport(itemset.getSupportClass());
        this.ruleBase.add(r);
    }

    public Rule get(int pos) {
        return this.ruleBase.get(pos);
    }

    public int size() {
        return this.ruleBase.size();
    }

    public void sort() {
        Collections.sort(this.ruleBase);
    }

    public Rule remove(int pos) {
        return this.ruleBase.remove(pos);
    }

    public void clear() {
        this.ruleBase.clear();
        this.fitness = 0.0;
    }

    public int getTypeInference() {
        return this.typeInference;
    }

    public double getAccuracy() {
        return this.fitness;
    }

    public void setDefaultRule() {
        int bestRule = 0;
        for (int i = 1; i < this.train.getnClasses(); ++i) {
            if (this.train.numberInstances(bestRule) >= this.train.numberInstances(i)) continue;
            bestRule = i;
        }
        this.defaultRule = bestRule;
    }

    public boolean hasUncover() {
        return this.nUncover > 0;
    }

    public int getUncover() {
        return this.nUncover;
    }

    public int getK() {
        return this.K;
    }

    public void evaluate() {
        int j;
        int nHits = 0;
        this.nUncover = 0;
        for (j = 0; j < this.train.getnClasses(); ++j) {
            this.nUncoverClas[j] = 0;
        }
        for (j = 0; j < this.train.size(); ++j) {
            int prediction = this.FRM(this.train.getExample(j));
            if (this.train.getOutputAsInteger(j) == prediction) {
                ++nHits;
            }
            if (prediction >= 0) continue;
            ++this.nUncover;
            int n = this.train.getOutputAsInteger(j);
            this.nUncoverClas[n] = this.nUncoverClas[n] + 1;
        }
        this.fitness = 100.0 * (double)nHits / (1.0 * (double)this.train.size());
    }

    public void evaluate(double[] gene, int[] selected) {
        int j;
        this.dataBase.decode(gene);
        int nHits = 0;
        this.nUncover = 0;
        for (j = 0; j < this.train.getnClasses(); ++j) {
            this.nUncoverClas[j] = 0;
        }
        for (j = 0; j < this.train.size(); ++j) {
            int prediction = this.FRM(this.train.getExample(j), selected);
            if (this.train.getOutputAsInteger(j) == prediction) {
                ++nHits;
            }
            if (prediction >= 0) continue;
            ++this.nUncover;
            int n = this.train.getOutputAsInteger(j);
            this.nUncoverClas[n] = this.nUncoverClas[n] + 1;
        }
        this.fitness = 100.0 * (double)nHits / (1.0 * (double)this.train.size());
    }

    public int FRM(double[] example) {
        if (this.typeInference == 0) {
            return this.FRM_WR(example);
        }
        return this.FRM_AC(example);
    }

    public int FRM(double[] example, int[] selected) {
        if (this.typeInference == 0) {
            return this.FRM_WR(example, selected);
        }
        return this.FRM_AC(example, selected);
    }

    private int FRM_WR(double[] example, int[] selected) {
        double max = 0.0;
        int clas = this.defaultRule;
        for (int i = 0; i < this.ruleBase.size(); ++i) {
            Rule r;
            double degree;
            if (selected[i] <= 0 || !((degree = (r = this.ruleBase.get(i)).matching(example)) > max)) continue;
            max = degree;
            clas = r.getClas();
        }
        return clas;
    }

    private int FRM_WR(double[] example) {
        double max = 0.0;
        int clas = this.defaultRule;
        for (int i = 0; i < this.ruleBase.size(); ++i) {
            Rule r = this.ruleBase.get(i);
            double degree = r.matching(example);
            if (!(degree > max)) continue;
            max = degree;
            clas = r.getClas();
        }
        return clas;
    }

    private int FRM_AC(double[] example, int[] selected) {
        int i;
        int clas = this.defaultRule;
        double[] degreeClass = new double[this.train.getnClasses()];
        for (i = 0; i < this.train.getnClasses(); ++i) {
            degreeClass[i] = 0.0;
        }
        for (i = 0; i < this.ruleBase.size(); ++i) {
            if (selected[i] <= 0) continue;
            Rule r = this.ruleBase.get(i);
            double degree = r.matching(example);
            int n = r.getClas();
            degreeClass[n] = degreeClass[n] + degree;
        }
        double maxDegree = 0.0;
        for (i = 0; i < this.train.getnClasses(); ++i) {
            if (!(degreeClass[i] > maxDegree)) continue;
            maxDegree = degreeClass[i];
            clas = i;
        }
        return clas;
    }

    private int FRM_AC(double[] example) {
        int i;
        int clas = this.defaultRule;
        double[] degreeClass = new double[this.train.getnClasses()];
        for (i = 0; i < this.train.getnClasses(); ++i) {
            degreeClass[i] = 0.0;
        }
        for (i = 0; i < this.ruleBase.size(); ++i) {
            Rule r = this.ruleBase.get(i);
            double degree = r.matching(example);
            int n = r.getClas();
            degreeClass[n] = degreeClass[n] + degree;
        }
        double maxDegree = 0.0;
        for (i = 0; i < this.train.getnClasses(); ++i) {
            if (!(degreeClass[i] > maxDegree)) continue;
            maxDegree = degreeClass[i];
            clas = i;
        }
        return clas;
    }

    public int hasClassUncovered(int[] selected) {
        int i;
        int[] cover = new int[this.train.getnClasses()];
        for (i = 0; i < cover.length; ++i) {
            cover[i] = this.train.numberInstances(i) > 0 ? 0 : 1;
        }
        for (i = 0; i < this.ruleBase.size(); ++i) {
            if (selected[i] <= 0) continue;
            int n = this.ruleBase.get(i).getClas();
            cover[n] = cover[n] + 1;
        }
        int count = 0;
        for (i = 0; i < cover.length; ++i) {
            if (cover[i] != 0) continue;
            ++count;
        }
        return count;
    }

    public void reduceRules(int clas) {
        int posBestWracc;
        int i;
        ArrayList<ExampleWeight> exampleWeight = new ArrayList<ExampleWeight>();
        for (i = 0; i < this.train.size(); ++i) {
            exampleWeight.add(new ExampleWeight(this.K));
        }
        int[] selected = new int[this.ruleBase.size()];
        for (i = 0; i < this.ruleBase.size(); ++i) {
            selected[i] = 0;
        }
        int nExamples = this.train.numberInstances(clas);
        int nRuleSelect = 0;
        do {
            Rule rule;
            double bestWracc = -1.0;
            posBestWracc = -1;
            for (i = 0; i < this.ruleBase.size(); ++i) {
                if (selected[i] != 0) continue;
                rule = this.ruleBase.get(i);
                rule.calculateWracc(this.train, exampleWeight);
                if (!(rule.getWracc() > bestWracc)) continue;
                bestWracc = rule.getWracc();
                posBestWracc = i;
            }
            if (posBestWracc <= -1) continue;
            selected[posBestWracc] = 1;
            ++nRuleSelect;
            rule = this.ruleBase.get(posBestWracc);
            nExamples -= rule.reduceWeight(this.train, exampleWeight);
        } while (nExamples > 0 && nRuleSelect < this.ruleBase.size() && posBestWracc > -1);
        for (i = this.ruleBase.size() - 1; i >= 0; --i) {
            if (selected[i] != 0) continue;
            this.ruleBase.remove(i);
        }
        exampleWeight.clear();
        System.gc();
    }

    public String printString() {
        int i;
        String[] names = this.train.names();
        String[] clases = this.train.clases();
        String stringOut = new String("");
        int ant = 0;
        for (i = 0; i < this.ruleBase.size(); ++i) {
            int j;
            Rule r = this.ruleBase.get(i);
            stringOut = stringOut + (i + 1) + ": ";
            for (j = 0; j < this.n_variables && r.antecedent[j] < 0; ++j) {
            }
            if (j < this.n_variables && r.antecedent[j] >= 0) {
                stringOut = stringOut + names[j] + " IS " + r.dataBase.print(j, r.antecedent[j]);
                ++ant;
            }
            ++j;
            while (j < this.n_variables - 1) {
                if (r.antecedent[j] >= 0) {
                    stringOut = stringOut + " AND " + names[j] + " IS " + r.dataBase.print(j, r.antecedent[j]);
                    ++ant;
                }
                ++j;
            }
            if (j < this.n_variables && r.antecedent[j] >= 0) {
                stringOut = stringOut + " AND " + names[j] + " IS " + r.dataBase.print(j, r.antecedent[j]) + ": " + clases[r.clas];
                ++ant;
            } else {
                stringOut = stringOut + ": " + clases[r.clas];
            }
            stringOut = stringOut + " CF: " + r.getConfidence() + "\n";
        }
        stringOut = stringOut + "\n\n";
        stringOut = stringOut + "@supp and CF:\n\n";
        for (i = 0; i < this.ruleBase.size(); ++i) {
            Rule rule = this.ruleBase.get(i);
            stringOut = stringOut + (i + 1) + ": ";
            stringOut = stringOut + "supp: " + rule.getSupport() + " AND CF: " + rule.getConfidence() + "\n";
        }
        stringOut = "@Number of rules: " + this.ruleBase.size() + " Number of Antecedents by rule: " + (double)ant * 1.0 / (double)this.ruleBase.size() + "\n\n" + stringOut;
        return stringOut;
    }

    public void saveFile(String filename) {
        String stringOut = new String("");
        stringOut = this.printString();
        Files.writeFile(filename, stringOut);
    }
}

