/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Statistical_Models.ModelLinear;

import java.io.FileNotFoundException;
import java.io.IOException;
import keel.Algorithms.Shared.ClassicalOptim.GCNet;
import keel.Algorithms.Shared.Parsing.ProcessConfig;
import keel.Algorithms.Shared.Parsing.ProcessDataset;
import org.core.Randomize;

public class ModelLinearLMS {
    static Randomize rand;

    private static void linearModel(boolean tty, ProcessConfig pc) {
        try {
            String line = new String();
            ProcessDataset pd = new ProcessDataset();
            line = (String)ProcessConfig.parInputData.get(0);
            if (ProcessConfig.parNewFormat) {
                pd.processModelDataset(line, true);
            } else {
                pd.oldClassificationProcess(line);
            }
            int nData = pd.getNdata();
            int nVariables = pd.getNvariables();
            int nInputs = pd.getNinputs();
            int nOutputs = 1;
            double[][] X = pd.getX();
            double[] Y = pd.getY();
            double[] Yt = new double[Y.length];
            pd.showDatasetStatistics();
            double[][] Y1 = new double[Y.length][1];
            for (int i = 0; i < nData; ++i) {
                Y1[i][0] = Y[i];
            }
            double[] maxInput = pd.getImaximum();
            double[] minInput = pd.getIminimum();
            double maxOutput = pd.getOmaximum();
            double minOutput = pd.getOminimum();
            int nLayers = 0;
            int[] ELEM = new int[nLayers];
            int dimWeights = 0;
            if (nLayers == 0) {
                dimWeights = (nInputs + 1) * nOutputs;
            } else {
                dimWeights = (nInputs + 1) * ELEM[0];
                for (int i = 1; i < nLayers; ++i) {
                    dimWeights += (ELEM[i - 1] + 1) * ELEM[i];
                }
                dimWeights += nOutputs * (ELEM[nLayers - 1] + 1);
            }
            double[] weights = new double[dimWeights];
            GCNet gcn = new GCNet();
            double error = gcn.nntrain(nInputs, 1, X, Y1, ELEM, weights, rand);
            System.out.println("Train MSE = " + error);
            for (int i = 0; i < Yt.length; ++i) {
                double[] salida = gcn.nnoutput(X[i]);
                Yt[i] = salida[0];
            }
            pc.trainingResults(Y, Yt);
            ProcessDataset pdt = new ProcessDataset();
            line = (String)ProcessConfig.parInputData.get(2);
            if (ProcessConfig.parNewFormat) {
                pdt.processModelDataset(line, false);
            } else {
                pdt.oldClassificationProcess(line);
            }
            int nTest = pdt.getNdata();
            int npVariables = pdt.getNvariables();
            int npInputs = pdt.getNinputs();
            pdt.showDatasetStatistics();
            if (npInputs != nInputs) {
                throw new IOException("IOERR in test file");
            }
            double[][] Xp = pdt.getX();
            double[] Yp = pdt.getY();
            double[] Yo = new double[Yp.length];
            double RMS = 0.0;
            for (int i = 0; i < nTest; ++i) {
                double[] output = gcn.nnoutput(Xp[i]);
                RMS += (output[0] - Yp[i]) * (output[0] - Yp[i]);
                Yo[i] = output[0];
            }
            System.out.println("Test ECM = " + (RMS /= (double)nTest));
            pc.results(Yp, Yo);
        }
        catch (FileNotFoundException e) {
            System.err.println(e + " File not found");
        }
        catch (IOException e) {
            System.err.println(e + " Read Error");
        }
    }

    public static void main(String[] args) {
        boolean tty = false;
        ProcessConfig pc = new ProcessConfig();
        System.out.println("Reading configuration file: " + args[0]);
        if (pc.fileProcess(args[0]) < 0) {
            return;
        }
        int algorithm = ProcessConfig.parAlgorithmType;
        rand = new Randomize();
        Randomize.setSeed(ProcessConfig.parSeed);
        ModelLinearLMS cp = new ModelLinearLMS();
        ModelLinearLMS.linearModel(tty, pc);
    }
}

