/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Neural_Networks.NNEP_Common.mutators.structural;

import keel.Algorithms.Neural_Networks.NNEP_Common.mutators.structural.INeuronStructuralMutator;
import keel.Algorithms.Neural_Networks.NNEP_Common.neuralnet.ExpNeuron;
import keel.Algorithms.Neural_Networks.NNEP_Common.neuralnet.ILayer;
import keel.Algorithms.Neural_Networks.NNEP_Common.neuralnet.INeuron;
import keel.Algorithms.Neural_Networks.NNEP_Common.neuralnet.Link;
import keel.Algorithms.Neural_Networks.NNEP_Common.neuralnet.LinkedLayer;
import keel.Algorithms.Neural_Networks.NNEP_Common.neuralnet.LinkedNeuron;
import net.sf.jclec.util.random.IRandGen;

public class ExpNeuronStructuralMutator
implements INeuronStructuralMutator<ExpNeuron> {
    protected IRandGen randgen;
    protected double significativeWeigth;

    public IRandGen getRandgen() {
        return this.randgen;
    }

    public void setRandgen(IRandGen randgen) {
        this.randgen = randgen;
    }

    public double getSignificativeWeigth() {
        return this.significativeWeigth;
    }

    public void setSignificativeWeigth(double significativeWeigth) {
        this.significativeWeigth = significativeWeigth;
    }

    @Override
    public void addNeuron(ExpNeuron neuron, LinkedLayer layer, ILayer<? extends INeuron> previousLayer, LinkedLayer nextLayer) {
        int selectedNeuron;
        int i;
        Link[] links;
        if (layer.isBiased()) {
            links = new Link[previousLayer.getMaxnofneurons() + 1];
            links[previousLayer.getMaxnofneurons()] = new Link();
            links[previousLayer.getMaxnofneurons()].setBroken(false);
            links[previousLayer.getMaxnofneurons()].setWeight(neuron.randomWeight(this.randgen, this.significativeWeigth));
            neuron.setBiased(true);
        } else {
            links = new Link[previousLayer.getMaxnofneurons()];
        }
        for (int i2 = 0; i2 < previousLayer.getMaxnofneurons(); ++i2) {
            links[i2] = new Link();
            links[i2].setBroken(true);
            links[i2].setWeight(0.0);
        }
        int noflinks = this.randgen.choose(1, previousLayer.getNofneurons() + 1);
        for (i = 0; i < noflinks; ++i) {
            selectedNeuron = this.randgen.choose(0, previousLayer.getNofneurons());
            links[selectedNeuron].setBroken(false);
            links[selectedNeuron].setOrigin(previousLayer.getNeuron(selectedNeuron));
            links[selectedNeuron].setWeight(neuron.randomWeight(this.randgen, this.significativeWeigth));
            links[selectedNeuron].setTarget(neuron);
        }
        neuron.setLinks(links);
        layer.addNeuron(neuron);
        noflinks = this.randgen.choose(1, nextLayer.getNofneurons() + 1);
        for (i = 0; i < noflinks; ++i) {
            while (!nextLayer.getNeuron(selectedNeuron = this.randgen.choose(0, nextLayer.getNofneurons())).getLinks()[layer.getNofneurons() - 1].isBroken()) {
            }
            LinkedNeuron linkedNeuron = nextLayer.getNeuron(selectedNeuron);
            Link newLink = new Link();
            newLink.setBroken(false);
            newLink.setOrigin(neuron);
            newLink.setWeight(linkedNeuron.randomWeight(this.randgen, this.significativeWeigth));
            newLink.setTarget(linkedNeuron);
            linkedNeuron.setLink(layer.getNofneurons() - 1, newLink);
        }
    }

    @Override
    public void removeNeuron(LinkedLayer layer, LinkedLayer nextLayer, int indexNeuron) {
        layer.removeNeuron(indexNeuron);
        for (int i = 0; i < nextLayer.getNofneurons(); ++i) {
            int j;
            LinkedNeuron neuron = nextLayer.getNeuron(i);
            Link[] links = neuron.getLinks();
            if (!neuron.isBiased()) {
                for (j = indexNeuron; j < links.length; ++j) {
                    if (j + 1 == links.length) {
                        links[j].setBroken(true);
                        links[j].setWeight(0.0);
                        continue;
                    }
                    links[j].setBroken(links[j + 1].isBroken());
                    links[j].setOrigin(links[j + 1].getOrigin());
                    links[j].setTarget(links[j + 1].getTarget());
                    links[j].setWeight(links[j + 1].getWeight());
                }
                continue;
            }
            for (j = indexNeuron; j < links.length - 1; ++j) {
                if (j + 1 == links.length - 1) {
                    links[j].setBroken(true);
                    links[j].setWeight(0.0);
                    continue;
                }
                links[j].setBroken(links[j + 1].isBroken());
                links[j].setOrigin(links[j + 1].getOrigin());
                links[j].setTarget(links[j + 1].getTarget());
                links[j].setWeight(links[j + 1].getWeight());
            }
        }
    }

    @Override
    public boolean addLink(ExpNeuron neuron, LinkedLayer layer, ILayer<? extends INeuron> previousLayer, int indexNeuron, int indexOrigin) {
        Link[] links = neuron.getLinks();
        links[indexOrigin].setBroken(false);
        links[indexOrigin].setWeight(this.randgen.raw());
        links[indexOrigin].setOrigin(previousLayer.getNeuron(indexOrigin));
        links[indexOrigin].setTarget(layer.getNeuron(indexNeuron));
        return true;
    }

    @Override
    public boolean removeLink(ExpNeuron neuron, int indexOrigin) {
        Link[] links = neuron.getLinks();
        links[indexOrigin].setBroken(true);
        links[indexOrigin].setWeight(0.0);
        links[indexOrigin].setOrigin(null);
        links[indexOrigin].setTarget(null);
        return true;
    }

    @Override
    public void unitNeuronsWeights(ExpNeuron firstNeuron, ExpNeuron secondNeuron, LinkedLayer layer, LinkedLayer nextLayer, int indexFirstNeuron, int indexSecondNeuron) {
        int i;
        Link[] firstLinks = firstNeuron.getLinks();
        Link[] secondLinks = secondNeuron.getLinks();
        for (i = 0; i < firstLinks.length; ++i) {
            if (!firstLinks[i].isBroken() && !secondLinks[i].isBroken()) {
                firstLinks[i].setWeight((firstLinks[i].getWeight() + secondLinks[i].getWeight()) / 2.0);
                continue;
            }
            if (!(firstLinks[i].isBroken() && secondLinks[i].isBroken() || !(this.randgen.raw() < 0.5))) {
                if (!firstLinks[i].isBroken()) continue;
                firstLinks[i].setBroken(false);
                firstLinks[i].setWeight(secondLinks[i].getWeight());
                firstLinks[i].setOrigin(secondLinks[i].getOrigin());
                firstLinks[i].setTarget(secondLinks[i].getTarget());
                continue;
            }
            firstLinks[i].setBroken(true);
            firstLinks[i].setWeight(0.0);
            firstLinks[i].setOrigin(null);
            firstLinks[i].setTarget(null);
        }
        for (i = 0; i < nextLayer.getNofneurons(); ++i) {
            LinkedNeuron neuron = nextLayer.getNeuron(i);
            Link[] links = neuron.getLinks();
            if (!links[indexFirstNeuron].isBroken() && !links[indexSecondNeuron].isBroken()) {
                links[indexFirstNeuron].setWeight(links[indexFirstNeuron].getWeight() + links[indexSecondNeuron].getWeight());
                continue;
            }
            if (!links[indexFirstNeuron].isBroken() || links[indexSecondNeuron].isBroken()) continue;
            links[indexFirstNeuron].setBroken(false);
            links[indexFirstNeuron].setWeight(links[indexSecondNeuron].getWeight());
            links[indexFirstNeuron].setOrigin(firstNeuron);
            links[indexFirstNeuron].setTarget(neuron);
        }
    }
}

