/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jclec.algorithm.memetic;

import java.util.ArrayList;
import java.util.List;
import net.sf.jclec.IConfigure;
import net.sf.jclec.IPopulation;
import net.sf.jclec.ISpecies;
import net.sf.jclec.ISystem;
import net.sf.jclec.algorithm.memetic.AbstractOptimizer;
import net.sf.jclec.base.AbstractIndividual;
import net.sf.jclec.realarray.IRealArraySpecies;
import net.sf.jclec.realarray.RealArrayIndividual;
import net.sf.jclec.selector.BettersSelector;
import net.sf.jclec.util.range.IRange;
import net.sf.jclec.util.range.Interval;
import org.apache.commons.configuration.Configuration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NelderMeadOptimizer<I extends RealArrayIndividual>
extends AbstractOptimizer<I>
implements IConfigure {
    private static final long serialVersionUID = 7436334275449929175L;
    protected double contractionFactor;
    protected double expansionFactor;
    protected double reflectionFactor;
    protected int maxIterations;
    BettersSelector<I> bettersSelector;
    protected IRange[] schema;

    public double getContractionFactor() {
        return this.contractionFactor;
    }

    public void setContractionFactor(double contractionFactor) {
        this.contractionFactor = contractionFactor;
    }

    public double getExpansionFactor() {
        return this.expansionFactor;
    }

    public void setExpansionFactor(double expansionFactor) {
        this.expansionFactor = expansionFactor;
    }

    public double getReflectionFactor() {
        return this.reflectionFactor;
    }

    public void setReflectionFactor(double reflectionFactor) {
        this.reflectionFactor = reflectionFactor;
    }

    public int getMaxIterations() {
        return this.maxIterations;
    }

    public void setMaxIterations(int maxIterations) {
        this.maxIterations = maxIterations;
    }

    @Override
    public void contextualize(ISystem<I> context) {
        super.contextualize(context);
        ISpecies spc = ((IPopulation)context).getSpecies();
        if (!(spc instanceof IRealArraySpecies)) {
            throw new IllegalArgumentException("IRealArraySpecies expected");
        }
        this.schema = ((IRealArraySpecies)spc).getGenotypeSchema();
        this.bettersSelector = new BettersSelector<I>(context);
    }

    protected void restart(List<I> soluciones, I mejorSolucion, int longitud) {
        int elem = soluciones.size();
        int i = 0;
        while (i < elem) {
            if (((RealArrayIndividual)soluciones.get(i)).equals(mejorSolucion)) {
                int j = 0;
                while (j < longitud) {
                    ((double[])((RealArrayIndividual)soluciones.get((int)i)).getGenotype())[j] = 0.5 * (((double[])((RealArrayIndividual)soluciones.get(i)).getGenotype())[j] + ((double[])((AbstractIndividual)mejorSolucion).getGenotype())[j]);
                    ++j;
                }
            }
            ++i;
        }
        this.evaluator.evaluate(soluciones);
    }

    protected void move(I actual, I indRespecto, int longitud, double factor, double[] valorCentroide) {
        double[] realArray = new double[longitud];
        int i = 0;
        while (i < longitud) {
            realArray[i] = valorCentroide[i] + factor * (valorCentroide[i] - ((double[])((AbstractIndividual)indRespecto).getGenotype())[i]);
            double a = ((Interval)this.schema[i]).getLeft();
            double b = ((Interval)this.schema[i]).getRight();
            double extremoInferior = Math.min(a, b);
            double extremoSuperior = Math.max(a, b);
            if (realArray[i] < extremoInferior) {
                realArray[i] = extremoInferior;
            }
            if (realArray[i] > extremoSuperior) {
                realArray[i] = extremoSuperior;
            }
            ++i;
        }
        ((AbstractIndividual)actual).setGenotype((double[])realArray);
    }

    protected List<I> obtainExtremeSolutions(List<I> source, int longitud) {
        ArrayList<RealArrayIndividual> result = new ArrayList<RealArrayIndividual>();
        List<I> aux = this.bettersSelector.select(source, source.size());
        result.add((RealArrayIndividual)aux.get(source.size() - 1));
        result.add((RealArrayIndividual)aux.get(source.size() - 2));
        result.add((RealArrayIndividual)aux.get(0));
        return result;
    }

    protected void calculateCentroide(List<I> soluciones, I worst, double[] valorCentroide, int longitud) {
        int i = 0;
        while (i < longitud) {
            valorCentroide[i] = 0.0;
            ++i;
        }
        int j = 0;
        while (j < longitud) {
            int i2 = 0;
            while (i2 < soluciones.size()) {
                if (!((RealArrayIndividual)soluciones.get(i2)).equals(worst)) {
                    int n = j;
                    valorCentroide[n] = valorCentroide[n] + ((double[])((RealArrayIndividual)soluciones.get(i2)).getGenotype())[j];
                }
                ++i2;
            }
            ++j;
        }
        i = 0;
        while (i < longitud) {
            int n = i++;
            valorCentroide[n] = valorCentroide[n] / (double)longitud;
        }
    }

    protected List<I> generateSolutions(I solucionInicial, int longitud) {
        ArrayList<RealArrayIndividual> result = new ArrayList<RealArrayIndividual>();
        RealArrayIndividual copiaSolucionInicial = (RealArrayIndividual)((RealArrayIndividual)solucionInicial).copy();
        result.add(copiaSolucionInicial);
        double[] realArray = new double[longitud];
        int i = 0;
        while (i < longitud) {
            RealArrayIndividual nuevaSolucion = (RealArrayIndividual)((RealArrayIndividual)solucionInicial).copy();
            realArray = (double[])nuevaSolucion.getGenotype();
            double a = ((Interval)this.schema[i]).getLeft();
            double b = ((Interval)this.schema[i]).getRight();
            double dif = Math.abs(a - b);
            int n = i;
            realArray[n] = realArray[n] + 0.1 * dif;
            double extremoInferior = Math.min(a, b);
            double extremoSuperior = Math.max(a, b);
            if (realArray[i] < extremoInferior) {
                realArray[i] = extremoInferior;
            }
            if (realArray[i] > extremoSuperior) {
                realArray[i] = extremoSuperior;
            }
            nuevaSolucion.setGenotype(realArray);
            result.add(nuevaSolucion);
            ++i;
        }
        this.evaluator.evaluate(result);
        return result;
    }

    @Override
    public I optimize(I ind) {
        ArrayList<RealArrayIndividual> lextension = new ArrayList<RealArrayIndividual>();
        ArrayList<RealArrayIndividual> lreflection = new ArrayList<RealArrayIndividual>();
        ArrayList<RealArrayIndividual> lcontraction = new ArrayList<RealArrayIndividual>();
        RealArrayIndividual extension = (RealArrayIndividual)((RealArrayIndividual)ind).copy();
        RealArrayIndividual reflection = (RealArrayIndividual)((RealArrayIndividual)ind).copy();
        RealArrayIndividual contraction = (RealArrayIndividual)((RealArrayIndividual)ind).copy();
        lextension.add(extension);
        lreflection.add(reflection);
        lcontraction.add(contraction);
        int length = ((double[])((AbstractIndividual)ind).getGenotype()).length;
        double[] centroideValue = new double[length];
        int i = 0;
        while (i < length) {
            centroideValue[i] = 0.0;
            ++i;
        }
        List<I> solutions = this.generateSolutions(ind, length);
        List<I> extremeSolutions = this.obtainExtremeSolutions(solutions, length);
        i = 0;
        while (i < this.maxIterations) {
            extremeSolutions = this.obtainExtremeSolutions(solutions, length);
            this.calculateCentroide(solutions, (RealArrayIndividual)extremeSolutions.get(0), centroideValue, length);
            this.move(reflection, (RealArrayIndividual)extremeSolutions.get(0), length, this.reflectionFactor, centroideValue);
            this.evaluator.evaluate(lreflection);
            if (this.evaluator.getComparator().compare(((RealArrayIndividual)extremeSolutions.get(2)).getFitness(), reflection.getFitness()) == -1) {
                this.move(extension, reflection, length, this.expansionFactor, centroideValue);
                this.evaluator.evaluate(lextension);
                if (this.evaluator.getComparator().compare(reflection.getFitness(), extension.getFitness()) == -1) {
                    ((RealArrayIndividual)extremeSolutions.get(0)).setGenotype((double[])extension.getGenotype());
                    ((RealArrayIndividual)extremeSolutions.get(0)).setFitness(extension.getFitness());
                } else {
                    ((RealArrayIndividual)extremeSolutions.get(0)).setGenotype((double[])reflection.getGenotype());
                    ((RealArrayIndividual)extremeSolutions.get(0)).setFitness(reflection.getFitness());
                }
            } else if (this.evaluator.getComparator().compare(reflection.getFitness(), ((RealArrayIndividual)extremeSolutions.get(1)).getFitness()) == 1) {
                ((RealArrayIndividual)extremeSolutions.get(0)).setGenotype((double[])reflection.getGenotype());
                ((RealArrayIndividual)extremeSolutions.get(0)).setFitness(reflection.getFitness());
            } else if (this.evaluator.getComparator().compare(reflection.getFitness(), ((RealArrayIndividual)extremeSolutions.get(0)).getFitness()) == 1) {
                ((RealArrayIndividual)extremeSolutions.get(0)).setGenotype((double[])reflection.getGenotype());
                ((RealArrayIndividual)extremeSolutions.get(0)).setFitness(reflection.getFitness());
            } else {
                this.move(contraction, (RealArrayIndividual)extremeSolutions.get(0), length, this.contractionFactor, centroideValue);
                this.evaluator.evaluate(lcontraction);
                if (this.evaluator.getComparator().compare(contraction.getFitness(), ((RealArrayIndividual)extremeSolutions.get(0)).getFitness()) == 1) {
                    ((RealArrayIndividual)extremeSolutions.get(0)).setGenotype((double[])contraction.getGenotype());
                    ((RealArrayIndividual)extremeSolutions.get(0)).setFitness(contraction.getFitness());
                } else {
                    this.restart(solutions, (RealArrayIndividual)extremeSolutions.get(0), length);
                }
            }
            int j = 0;
            while (j < length) {
                centroideValue[j] = 0.0;
                ++j;
            }
            ++i;
        }
        extremeSolutions = this.obtainExtremeSolutions(solutions, length);
        return (I)((RealArrayIndividual)extremeSolutions.get(2));
    }

    @Override
    public void configure(Configuration configuration) {
        double contractionFactor = configuration.getDouble("contraction-factor", 0.5);
        this.setContractionFactor(contractionFactor);
        double reflectionFactor = configuration.getDouble("reflection-factor", 1.0);
        this.setReflectionFactor(reflectionFactor);
        double expansionFactor = configuration.getDouble("expansion-factor", 2.0);
        this.setExpansionFactor(expansionFactor);
        int maxIterations = configuration.getInt("max-iterations", 10);
        this.setMaxIterations(maxIterations);
    }
}

