/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jclec.syntaxtree;

import javolution.xml.XmlElement;
import javolution.xml.XmlFormat;
import net.sf.jclec.IData;
import net.sf.jclec.exprtree.ExprTree;
import net.sf.jclec.syntaxtree.SyntaxTreeNode;
import net.sf.jclec.syntaxtree.TerminalNode;

public class SyntaxTree
implements IData {
    protected static final XmlFormat<SyntaxTree> SYNTAX_TREE_XML = new XmlFormat<SyntaxTree>(SyntaxTree.class){

        @Override
        public void format(SyntaxTree source, XmlElement xml) {
            xml.setAttribute("tree-size", source.treeSize);
            xml.setAttribute("deriv-size", source.derivSize);
            SyntaxTreeNode[] syntaxTreeNodeArray = source.nodes;
            int n = 0;
            int n2 = syntaxTreeNodeArray.length;
            while (n < n2) {
                SyntaxTreeNode node = syntaxTreeNodeArray[n];
                xml.add(node, "node");
                ++n;
            }
        }

        @Override
        public SyntaxTree parse(XmlElement xml) {
            int treeSize = xml.getAttribute("tree-size", 0);
            int derivSize = xml.getAttribute("deriv-size", 0);
            SyntaxTreeNode[] nodes = new SyntaxTreeNode[treeSize];
            int i = 0;
            while (i < treeSize) {
                nodes[i] = (SyntaxTreeNode)xml.get("node");
                ++i;
            }
            SyntaxTree result = new SyntaxTree();
            result.treeSize = treeSize;
            result.derivSize = derivSize;
            result.nodes = nodes;
            return result;
        }

        @Override
        public String defaultName() {
            return "syntax-tree";
        }
    };
    private static final long serialVersionUID = 6978139392787525827L;
    private SyntaxTreeNode[] nodes = new SyntaxTreeNode[10];
    private int treeSize = 0;
    private int derivSize = 0;

    public void addNode(SyntaxTreeNode node) {
        if (this.treeSize == this.nodes.length) {
            SyntaxTreeNode[] aux = new SyntaxTreeNode[2 * this.treeSize];
            int i = 0;
            while (i < this.treeSize) {
                aux[i] = this.nodes[i];
                ++i;
            }
            this.nodes = aux;
        }
        if (node.arity() != 0) {
            ++this.derivSize;
        }
        this.nodes[this.treeSize++] = node;
    }

    public SyntaxTreeNode getNode(int nodeIndex) {
        return this.nodes[nodeIndex];
    }

    public void setNode(SyntaxTreeNode node, int nodeIndex) {
        this.nodes[nodeIndex] = node;
    }

    public int size() {
        return this.treeSize;
    }

    public int derivSize() {
        return this.derivSize;
    }

    public SyntaxTree copy() {
        SyntaxTreeNode[] nodesCopy = new SyntaxTreeNode[this.nodes.length];
        int i = 0;
        while (i < this.treeSize) {
            nodesCopy[i] = this.nodes[i].copy();
            ++i;
        }
        SyntaxTree result = new SyntaxTree();
        result.treeSize = this.treeSize;
        result.derivSize = this.derivSize;
        result.nodes = nodesCopy;
        return result;
    }

    public void clear() {
        this.derivSize = 0;
        this.treeSize = 0;
    }

    public int subTree(int blockIndex) {
        int resultIndex = blockIndex;
        int aux = 0;
        do {
            aux += this.nodes[resultIndex].arity();
            ++resultIndex;
        } while (aux-- != 0);
        return resultIndex;
    }

    public ExprTree getExprTree() {
        ExprTree result = new ExprTree();
        int i = 0;
        while (i < this.treeSize) {
            if (this.nodes[i].arity() == 0) {
                result.addBlock(((TerminalNode)this.nodes[i]).getCode());
            }
            ++i;
        }
        return result;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("(");
        int i = 0;
        while (i < this.treeSize) {
            sb.append(this.nodes[i]);
            if (i != this.treeSize - 1) {
                sb.append(" ");
            } else {
                sb.append(")");
            }
            ++i;
        }
        sb.append(" -> " + this.derivSize);
        return sb.toString();
    }

    public boolean equals(Object other) {
        if (other instanceof SyntaxTree) {
            SyntaxTree cother = (SyntaxTree)other;
            if (this.treeSize == cother.treeSize && this.derivSize == cother.derivSize) {
                int i = 0;
                while (i < this.treeSize) {
                    if (!this.nodes[i].equals(cother.nodes[i])) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            return false;
        }
        return false;
    }
}

