/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Rule_Learning.Ripper;

import keel.Algorithms.Rule_Learning.Ripper.Mask;

class IncrementalMask {
    private int[] mask;
    private int nactivos;
    private int index;

    public IncrementalMask() {
    }

    public IncrementalMask(int size) {
        this.mask = new int[size];
        this.nactivos = 0;
        for (int i = 0; i < size; ++i) {
            this.mask[i] = 0;
        }
        this.index = -1;
    }

    public IncrementalMask(int size, int initial) {
        this.mask = new int[size];
        if (initial != 0) {
            this.nactivos = size;
        }
        for (int i = 0; i < size; ++i) {
            this.mask[i] = initial;
        }
        this.index = -1;
    }

    private IncrementalMask(int[] mask, int nactivos) {
        this.mask = mask;
        this.nactivos = nactivos;
        this.index = -1;
    }

    public IncrementalMask copy() {
        int[] replicate = new int[this.mask.length];
        for (int i = 0; i < this.mask.length; ++i) {
            replicate[i] = this.mask[i];
        }
        return new IncrementalMask(replicate, this.nactivos);
    }

    public void copyTo(IncrementalMask replicate) {
        for (int i = 0; i < this.mask.length; ++i) {
            replicate.mask[i] = this.mask[i];
        }
        replicate.nactivos = this.nactivos;
        replicate.index = -1;
    }

    public void set(int i, int value) {
        if (this.mask[i] == 0 && value != 0) {
            ++this.nactivos;
        }
        this.mask[i] = value;
    }

    public void set(int value) {
        if (this.mask[this.index] == 0 && value != 0) {
            ++this.nactivos;
        }
        this.mask[this.index] = value;
    }

    public int get(int i) {
        return this.mask[i];
    }

    public int getnActive() {
        return this.nactivos;
    }

    public boolean next() {
        do {
            ++this.index;
        } while (this.index < this.mask.length && this.mask[this.index] == 0);
        return this.index < this.mask.length;
    }

    public int getIndex() {
        return this.index;
    }

    public void resetIndex() {
        this.index = -1;
    }

    public Mask and(Mask m) {
        Mask output = new Mask(this.mask.length);
        for (int i = 0; i < this.mask.length; ++i) {
            output.set(i, this.mask[i] != 0 && m.isActive(i));
        }
        return output;
    }

    public Mask and(IncrementalMask im) {
        Mask output = new Mask(this.mask.length);
        for (int i = 0; i < this.mask.length; ++i) {
            output.set(i, this.mask[i] != 0 && im.mask[i] != 0);
        }
        return output;
    }

    public Mask or(Mask m) {
        Mask output = new Mask(this.mask.length);
        for (int i = 0; i < this.mask.length; ++i) {
            output.set(i, this.mask[i] != 0 || m.isActive(i));
        }
        return output;
    }

    public Mask or(IncrementalMask im) {
        Mask output = new Mask(this.mask.length);
        for (int i = 0; i < this.mask.length; ++i) {
            output.set(i, this.mask[i] != 0 || im.mask[i] != 0);
        }
        return output;
    }

    public IncrementalMask plus(IncrementalMask im) {
        IncrementalMask output = new IncrementalMask(this.mask.length);
        output.nactivos = 0;
        for (int i = 0; i < this.mask.length; ++i) {
            output.mask[i] = this.mask[i] + im.mask[i];
            if (output.mask[i] == 0) continue;
            ++output.nactivos;
        }
        return output;
    }

    public IncrementalMask plus(Mask m) {
        IncrementalMask output = new IncrementalMask(this.mask.length);
        output.nactivos = 0;
        for (int i = 0; i < this.mask.length; ++i) {
            output.mask[i] = this.mask[i];
            if (m.isActive(i)) {
                int n = i;
                output.mask[n] = output.mask[n] + 1;
            }
            if (output.mask[i] == 0) continue;
            ++output.nactivos;
        }
        return output;
    }

    public IncrementalMask plus(IncrementalMask[] m) {
        IncrementalMask output = new IncrementalMask(this.mask.length, 0);
        output = output.plus(this);
        for (int i = 0; i < m.length; ++i) {
            output = output.plus(m[i]);
        }
        return output;
    }

    public IncrementalMask plus(Mask[] m) {
        IncrementalMask output = new IncrementalMask(this.mask.length, 0);
        output = output.plus(this);
        for (int i = 0; i < m.length; ++i) {
            output = output.plus(m[i]);
        }
        return output;
    }

    public IncrementalMask minus(IncrementalMask im) {
        IncrementalMask output = new IncrementalMask(this.mask.length);
        output.nactivos = 0;
        for (int i = 0; i < this.mask.length; ++i) {
            output.mask[i] = this.mask[i] - im.mask[i];
            if (output.mask[i] == 0) continue;
            ++output.nactivos;
        }
        return output;
    }

    public IncrementalMask minus(Mask m) {
        IncrementalMask output = new IncrementalMask(this.mask.length);
        output.nactivos = 0;
        for (int i = 0; i < this.mask.length; ++i) {
            output.mask[i] = this.mask[i];
            if (m.isActive(i)) {
                int n = i;
                output.mask[n] = output.mask[n] - 1;
            }
            if (output.mask[i] == 0) continue;
            ++output.nactivos;
        }
        return output;
    }
}

