/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Rule_Learning.Ripper;

import java.io.IOException;
import keel.Algorithms.Rule_Learning.Ripper.Mask;
import keel.Algorithms.Rule_Learning.Ripper.MyDataset;
import keel.Algorithms.Rule_Learning.Ripper.Pair;
import keel.Algorithms.Rule_Learning.Ripper.Rule;
import keel.Algorithms.Rule_Learning.Ripper.Ruleset;
import keel.Algorithms.Rule_Learning.Ripper.Score;
import keel.Algorithms.Rule_Learning.Ripper.Utilities;
import keel.Algorithms.Rule_Learning.Ripper.parseParameters;
import keel.Dataset.Attributes;
import org.core.Fichero;
import org.core.Randomize;

public class Ripper {
    public static int W = 1;
    public static int A = 2;
    MyDataset train = new MyDataset();
    MyDataset val = new MyDataset();
    MyDataset test = new MyDataset();
    String outputTr;
    String outputTst;
    String outputRules;
    Randomize rand;
    double pct;
    int K;
    private boolean somethingWrong = false;

    public Ripper(parseParameters parameters) {
        try {
            System.out.println("\nReading the training set: " + parameters.getTrainingInputFile());
            this.train.readClassificationSet(parameters.getTrainingInputFile(), true);
            System.out.println("\nReading the validation set: " + parameters.getValidationInputFile());
            this.val.readClassificationSet(parameters.getValidationInputFile(), false);
            System.out.println("\nReading the test set: " + parameters.getTestInputFile());
            this.test.readClassificationSet(parameters.getTestInputFile(), false);
        }
        catch (IOException e) {
            System.err.println("There was a problem while reading the input data-sets: " + e);
            this.somethingWrong = true;
        }
        this.outputTr = parameters.getTrainingOutputFile();
        this.outputTst = parameters.getTestOutputFile();
        if (parameters.getNOutputFiles() == 0) {
            System.err.println("No se ha especificado archivo para las reglas.");
            System.err.println("Usando nombre por defecto: rules-out.txt");
            this.outputRules = "rules-out.txt";
        } else {
            this.outputRules = parameters.getOutputFile(0);
        }
        long seed = Long.parseLong(parameters.getParameter(0));
        this.pct = Double.parseDouble(parameters.getParameter(1));
        this.K = Integer.parseInt(parameters.getParameter(2));
        this.rand = new Randomize();
        Randomize.setSeed(seed);
    }

    public void execute() {
        if (this.somethingWrong) {
            System.err.println("An error was found, the data-set have numerical values.");
            System.err.println("Aborting the program");
        } else {
            Ruleset[] rulesets = this.ripperMulticlass(this.train);
            String[] classification_train = this.train.classify(rulesets, rulesets.length);
            String[] classification_val = this.val.classify(rulesets, rulesets.length);
            String[] classification_test = this.test.classify(rulesets, rulesets.length);
            this.doOutput(this.val, this.outputTr, classification_val);
            this.doOutput(this.test, this.outputTst, classification_test);
            this.doRulesOutput2(this.outputRules, rulesets);
            System.out.println("Algorithm Finished");
        }
    }

    private void doOutput(MyDataset dataset, String filename, String[] classification) {
        String output = new String("");
        output = dataset.copyHeader();
        for (int i = 0; i < dataset.getnData(); ++i) {
            output = output + dataset.getOutputAsString(i) + " " + classification[i] + "\n";
        }
        Fichero.escribeFichero(filename, output);
    }

    private void doRulesOutput(String filename, Ruleset[] rulesets) {
        String output = new String("");
        for (int i = 0; i < rulesets.length - 1; ++i) {
            output = output + "if(";
            for (int j = 0; j < rulesets[i].size(); ++j) {
                Rule current = rulesets[i].getRule(j);
                output = output + "(";
                for (int k = 0; k < current.size(); ++k) {
                    output = output + current.getSimpleRule(k);
                    if (k == current.size() - 1) continue;
                    output = output + " && ";
                }
                output = output + ")";
                if (j == rulesets[i].size() - 1) continue;
                output = output + " || ";
            }
            output = output + ")\n\t";
            output = output + "output=" + rulesets[i].getType() + "\nelse ";
        }
        output = output + "\n\toutput=" + rulesets[rulesets.length - 1].getType();
        Fichero.escribeFichero(filename, output);
    }

    private void doRulesOutput2(String filename, Ruleset[] rulesets) {
        int i;
        String output = new String("");
        int rules = 0;
        for (i = 0; i < rulesets.length; ++i) {
            rules += rulesets[i].size();
        }
        output = output + "@Number of Rules: " + rules + "\n";
        for (i = 0; i < rulesets.length - 1; ++i) {
            Mask class_filter = new Mask(this.train.size());
            this.train.filterByClass(class_filter, rulesets[i].getType());
            for (int j = 0; j < rulesets[i].size(); ++j) {
                output = output + "if(";
                Rule current = rulesets[i].getRule(j);
                for (int k = 0; k < current.size(); ++k) {
                    output = output + current.getSimpleRule(k);
                    if (k == current.size() - 1) continue;
                    output = output + " && ";
                }
                int covered = current.apply(this.train);
                int accuracy = current.apply(this.train, class_filter);
                output = output + ") (" + accuracy + "/" + covered + ")\n\t";
                output = output + "output=" + rulesets[i].getType() + "\nelse ";
            }
        }
        output = output + "\n\toutput=" + rulesets[rulesets.length - 1].getType();
        Fichero.escribeFichero(filename, output);
    }

    public Rule grow(MyDataset data, Mask positives, Mask negatives) {
        return this.grow(new Rule(), data, positives, negatives);
    }

    public Rule grow(Rule rule, MyDataset data, Mask grow_pos, Mask grow_neg) {
        double best_v = 0.0;
        double best_h = -1.7976931348623157E308;
        if (grow_pos.getnActive() < 0) {
            return new Rule();
        }
        Mask positives = grow_pos.copy();
        Mask negatives = grow_neg.copy();
        int[] attributes = new int[data.getnInputs()];
        int nattributes = attributes.length;
        for (int i = 0; i < attributes.length; ++i) {
            attributes[i] = i;
        }
        if (rule.size() > 0) {
            int[] aux = new int[data.getnInputs()];
            for (int i = 0; i < rule.size(); ++i) {
                attributes[rule.getSimpleRule((int)i).getAttribute()] = -1;
            }
            int j = 0;
            for (int i = 0; i < nattributes; ++i) {
                if (attributes[i] == -1) continue;
                aux[j] = attributes[i];
                ++j;
            }
            attributes = aux;
            nattributes = j;
            data.filter(positives, rule);
            data.filter(negatives, rule);
        }
        while (negatives.getnActive() > 0 && nattributes > 0 && positives.getnActive() > 0) {
            int A = -1;
            int P = -1;
            double V = 0.0;
            double best_global = -1.7976931348623157E308;
            int Op = -1;
            double C = Utilities.log2((double)positives.getnActive() / (double)(positives.getnActive() + negatives.getnActive()));
            for (int i = 0; i < nattributes; ++i) {
                int pos;
                double[] exemple;
                int ai = attributes[i];
                Score score = new Score();
                positives.resetIndex();
                while (positives.next()) {
                    if (data.isMissing(positives, ai)) continue;
                    exemple = data.getExample(positives);
                    pos = score.findKey(exemple[ai]);
                    if (pos != -1) {
                        score.addPositive(pos);
                        continue;
                    }
                    score.addKey(exemple[ai], Score.POSITIVE);
                }
                negatives.resetIndex();
                while (negatives.next()) {
                    if (data.isMissing(negatives, ai)) continue;
                    exemple = data.getExample(negatives);
                    pos = score.findKey(exemple[ai]);
                    if (pos != -1) {
                        score.addNegative(pos);
                        continue;
                    }
                    score.addKey(exemple[ai], Score.NEGATIVE);
                }
                best_v = 0.0;
                best_h = -1.7976931348623157E308;
                int best_operator = -1;
                if (Attributes.getInputAttribute(ai).getType() == 0) {
                    for (int j = 0; j < score.size(); ++j) {
                        double h = (double)score.getPositive(j) * (Utilities.log2((double)score.getPositive(j) / (double)score.getTotal(j)) - C);
                        if (!(h > best_h)) continue;
                        best_h = h;
                        best_v = score.getKey(j);
                        best_operator = Rule.EQUAL;
                    }
                } else {
                    score.sort();
                    int total_pos = positives.getnActive();
                    int total_neg = negatives.getnActive();
                    int count_pos = 0;
                    int count_neg = 0;
                    if (score.size() == 1 && score.getPositive(0) != 0) {
                        best_h = (double)count_pos * (Utilities.log2((double)score.getPositive(0) / ((double)score.getNegative(0) + (double)score.getPositive(0))) - C);
                        best_v = score.getKey(0);
                        best_operator = Rule.EQUAL;
                    } else if (score.size() == 1) {
                        best_h = -1.7976931348623157E308;
                        best_v = score.getKey(0);
                        best_operator = Rule.EQUAL;
                    } else {
                        best_h = -1.7976931348623157E308;
                    }
                    for (int j = 0; j < score.size() - 1; ++j) {
                        double h_lower = (count_pos += score.getPositive(j)) != 0 ? (double)count_pos * (Utilities.log2((double)count_pos / ((double)(count_neg += score.getNegative(j)) + (double)count_pos)) - C) : -1.7976931348623157E308;
                        int count_pos_g = total_pos - count_pos;
                        int count_neg_g = total_neg - count_neg;
                        double h_greater = count_pos_g != 0 ? (double)count_pos_g * (Utilities.log2((double)count_pos_g / ((double)count_neg_g + (double)count_pos_g)) - C) : -1.7976931348623157E308;
                        if (h_lower > h_greater && h_lower > best_h) {
                            best_h = h_lower;
                            best_v = score.getKey(j);
                            best_operator = Rule.LOWER;
                            continue;
                        }
                        if (!(h_greater > best_h)) continue;
                        best_h = h_greater;
                        best_v = score.getKey(j);
                        best_operator = Rule.GREATER;
                    }
                }
                if (!(best_h > best_global)) continue;
                P = i;
                A = ai;
                V = best_v;
                Op = best_operator;
                best_global = best_h;
            }
            if (A != -1) {
                rule.grow(A, V, Op);
                data.filter(positives, A, V, Op);
                data.filter(negatives, A, V, Op);
                attributes[P] = attributes[nattributes - 1];
            }
            --nattributes;
        }
        return rule;
    }

    public Rule prune(Rule rule, MyDataset data, Mask positives, Mask negatives, int metric) {
        double h;
        double t;
        double next_h = 0.0;
        double p = rule.apply(data, positives);
        double T = positives.getnActive() + negatives.getnActive();
        double n = rule.apply(data, negatives);
        double n_prime = (double)negatives.getnActive() - n;
        if (metric == A) {
            next_h = (p + n_prime) / T;
        }
        if (metric == W) {
            t = p + n;
            next_h = (p + 1.0) / (t + 2.0);
        }
        do {
            h = next_h;
            p = rule.apply(data, positives, rule.size() - 1);
            T = positives.getnActive() + negatives.getnActive();
            n = rule.apply(data, negatives, rule.size() - 1);
            n_prime = (double)negatives.getnActive() - n;
            if (metric == A) {
                next_h = (p + n_prime) / T;
            }
            if (metric == W) {
                t = p + n;
                next_h = (p + 1.0) / (t + 2.0);
            }
            if (!(h < next_h) || rule.size() <= 1) continue;
            rule.prune(rule.size() - 1);
        } while (h < next_h && rule.size() > 0 && rule.size() > 1);
        return rule;
    }

    public Ruleset[] ripperMulticlass(MyDataset data) {
        Ruleset[] rules = new Ruleset[data.getnClasses()];
        Pair[] ordered_classes = new Pair[data.getnClasses()];
        for (int i = 0; i < data.getnClasses(); ++i) {
            ordered_classes[i] = new Pair();
            ordered_classes[i].key = i;
            ordered_classes[i].value = data.numberInstances(i);
        }
        Utilities.mergeSort(ordered_classes, data.getnClasses());
        Mask base = new Mask(data.size());
        for (int i = 0; i < data.getnClasses() - 1; ++i) {
            String target_class = Attributes.getOutputAttribute(0).getNominalValue(ordered_classes[i].key);
            Mask positives = base.copy();
            data.filterByClass(positives, target_class);
            Mask negatives = base.and(positives.complement());
            rules[i] = this.ripperK(data, positives, negatives);
            rules[i].setType(target_class);
            base = negatives.copy();
        }
        rules[rules.length - 1] = new Ruleset();
        rules[rules.length - 1].addRule(new Rule());
        rules[rules.length - 1].setType(Attributes.getOutputAttribute(0).getNominalValue(ordered_classes[data.getnClasses() - 1].key));
        return rules;
    }

    public Ruleset IREPstar(Ruleset rules, MyDataset data, Mask pos, Mask neg) {
        double smallest_mdl = Double.MAX_VALUE;
        double new_mdl = Double.MAX_VALUE;
        Mask positives = pos.copy();
        Mask negatives = neg.copy();
        do {
            Mask[] gp_pos = positives.split(this.pct, this.rand);
            Mask grow_pos = gp_pos[0];
            Mask prune_pos = gp_pos[1];
            Mask[] gp_neg = negatives.split(this.pct, this.rand);
            Mask grow_neg = gp_neg[0];
            Mask prune_neg = gp_neg[1];
            Rule new_rule = this.grow(data, grow_pos, grow_neg);
            System.out.println("Regla criada\n" + new_rule);
            this.prune(new_rule, data, prune_pos, prune_neg, W);
            System.out.println("Regla podada\n" + new_rule);
            rules.addRule(new_rule);
            new_mdl = rules.getMDL(data, positives, negatives);
            if (new_mdl <= smallest_mdl + 64.0) {
                System.out.println("Regla a\u00f1adida\n" + new_rule);
                data.substract(positives, new_rule);
                data.substract(negatives, new_rule);
                if (!(new_mdl < smallest_mdl)) continue;
                smallest_mdl = new_mdl;
                continue;
            }
            rules.removeRule(rules.size() - 1);
        } while (positives.getnActive() > 0 && new_mdl <= smallest_mdl + 64.0);
        return rules;
    }

    public Ruleset optimize(Ruleset rules, MyDataset data, Mask positives, Mask negatives) {
        for (int i = 0; i < rules.size(); ++i) {
            Mask[] gp_pos = positives.split(this.pct, this.rand);
            Mask grow_pos = gp_pos[0];
            Mask prune_pos = gp_pos[1];
            Mask[] gp_neg = negatives.split(this.pct, this.rand);
            Mask grow_neg = gp_neg[0];
            Mask prune_neg = gp_neg[1];
            data.substract(prune_pos, rules, i);
            data.substract(prune_neg, rules, i);
            Rule revision = this.grow(data, grow_pos, grow_neg);
            Rule replacement = rules.getRule(i).getCopy();
            this.grow(replacement, data, grow_pos, grow_neg);
            this.prune(revision, data, prune_pos, prune_neg, A);
            this.prune(replacement, data, prune_pos, prune_neg, A);
            Rule current = rules.getRule(i);
            double current_mdl = rules.getMDL(data, positives, negatives);
            rules.removeRule(i);
            rules.insertRule(revision, i);
            double revision_mdl = rules.getMDL(data, positives, negatives);
            rules.removeRule(i);
            rules.insertRule(replacement, i);
            double replacement_mdl = rules.getMDL(data, positives, negatives);
            rules.removeRule(i);
            if (current_mdl <= revision_mdl && current_mdl <= replacement_mdl) {
                rules.insertRule(current, i);
                continue;
            }
            if (revision_mdl <= replacement_mdl) {
                rules.insertRule(revision, i);
                continue;
            }
            rules.insertRule(replacement, i);
        }
        return rules;
    }

    public Ruleset ripperK(MyDataset data, Mask positives, Mask negatives) {
        Ruleset rules = new Ruleset();
        this.IREPstar(rules, data, positives, negatives);
        for (int i = 0; i < this.K; ++i) {
            this.optimize(rules, data, positives, negatives);
            Mask p = positives.copy();
            data.substract(p, rules);
            if (p.getnActive() <= 0) continue;
            this.IREPstar(rules, data, p, negatives);
        }
        rules.removeDuplicates();
        rules.pulish(data, positives, negatives);
        return rules;
    }

    public MyDataset getData() {
        return this.train;
    }
}

