/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jclec.syntaxtree.rec;

import java.util.Comparator;
import net.sourceforge.jclec.syntaxtree.IRecombineSyntaxTree;
import net.sourceforge.jclec.syntaxtree.NonTerminalNode;
import net.sourceforge.jclec.syntaxtree.SyntaxTree;
import net.sourceforge.jclec.syntaxtree.SyntaxTreeNode;
import net.sourceforge.jclec.syntaxtree.SyntaxTreeSchema;
import net.sourceforge.jclec.util.random.IRandGen;
import org.apache.commons.lang.builder.EqualsBuilder;

public class NTCrossover
implements IRecombineSyntaxTree {
    private static final long serialVersionUID = -6447244450691681809L;
    protected Comparator<SyntaxTreeNode> symbolsComparator = new Comparator<SyntaxTreeNode>(){

        @Override
        public int compare(SyntaxTreeNode o1, SyntaxTreeNode o2) {
            if (o1 instanceof NonTerminalNode && o2 instanceof NonTerminalNode) {
                NonTerminalNode co1 = (NonTerminalNode)o1;
                NonTerminalNode co2 = (NonTerminalNode)o2;
                EqualsBuilder eb = new EqualsBuilder();
                eb.append(co1.getSymbol(), co2.getSymbol());
                if (eb.isEquals()) {
                    return 0;
                }
                return -1;
            }
            return -1;
        }
    };

    public boolean equals(Object other) {
        return other instanceof NTCrossover;
    }

    @Override
    public void recombine(SyntaxTree ptree0, SyntaxTree tree1, SyntaxTree stree0, SyntaxTree stree1, SyntaxTreeSchema schema, IRandGen randgen) {
        boolean cond1;
        int p0_branchStart = this.selectSymbol(ptree0, tree1, schema, randgen);
        if (p0_branchStart == -1) {
            int i = 0;
            while (i < ptree0.size()) {
                stree0.addNode(ptree0.getNode(i));
                ++i;
            }
            i = 0;
            while (i < tree1.size()) {
                stree1.addNode(tree1.getNode(i));
                ++i;
            }
            return;
        }
        NonTerminalNode selectedSymbol = (NonTerminalNode)ptree0.getNode(p0_branchStart);
        int p1_branchStart = this.searchSymbolIn(selectedSymbol, tree1, randgen);
        int p0_branchEnd = ptree0.subTree(p0_branchStart);
        int p1_branchEnd = tree1.subTree(p1_branchStart);
        int p0_branchDepth = ptree0.derivSize();
        int p0_swapBranch = 0;
        int i = p0_branchStart;
        while (i < p0_branchEnd) {
            if (ptree0.getNode(i).arity() != 0) {
                ++p0_swapBranch;
            }
            ++i;
        }
        int p1_branchDepth = tree1.derivSize();
        int p1_swapBranch = 0;
        int i2 = p1_branchStart;
        while (i2 < p1_branchEnd) {
            if (tree1.getNode(i2).arity() != 0) {
                ++p1_swapBranch;
            }
            ++i2;
        }
        int maxDerivSize = schema.getMaxDerivSize();
        boolean cond0 = p0_branchDepth - p0_swapBranch + p1_swapBranch > maxDerivSize;
        boolean bl = cond1 = p1_branchDepth - p1_swapBranch + p0_swapBranch > maxDerivSize;
        if (cond0 || cond1) {
            int i3 = 0;
            while (i3 < ptree0.size()) {
                stree0.addNode(ptree0.getNode(i3));
                ++i3;
            }
            i3 = 0;
            while (i3 < tree1.size()) {
                stree1.addNode(tree1.getNode(i3));
                ++i3;
            }
            return;
        }
        int i4 = 0;
        while (i4 < p0_branchStart) {
            stree0.addNode(ptree0.getNode(i4).copy());
            ++i4;
        }
        i4 = 0;
        while (i4 < p1_branchStart) {
            stree1.addNode(tree1.getNode(i4).copy());
            ++i4;
        }
        i4 = p0_branchStart;
        while (i4 < p0_branchEnd) {
            stree1.addNode(ptree0.getNode(i4).copy());
            ++i4;
        }
        i4 = p1_branchStart;
        while (i4 < p1_branchEnd) {
            stree0.addNode(tree1.getNode(i4).copy());
            ++i4;
        }
        int p0_length = ptree0.size();
        int i5 = p0_branchEnd;
        while (i5 < p0_length) {
            stree0.addNode(ptree0.getNode(i5).copy());
            ++i5;
        }
        int p1_length = tree1.size();
        int i6 = p1_branchEnd;
        while (i6 < p1_length) {
            stree1.addNode(tree1.getNode(i6).copy());
            ++i6;
        }
    }

    private final int selectSymbol(SyntaxTree tree0, SyntaxTree tree1, SyntaxTreeSchema schema, IRandGen randgen) {
        int startPos;
        int treeLength = tree0.size();
        int actPos = startPos = randgen.choose(0, treeLength);
        int i = 0;
        while (i < treeLength) {
            actPos = (startPos + i) % treeLength;
            if (!schema.isTerminal(tree0.getNode(actPos).getSymbol()) && this.searchSymbolIn((NonTerminalNode)tree0.getNode(actPos), tree1, randgen) != -1) {
                return actPos;
            }
            ++i;
        }
        return -1;
    }

    private final int searchSymbolIn(NonTerminalNode symbol, SyntaxTree tree, IRandGen randgen) {
        int startPos;
        int treeLength = tree.size();
        int actPos = startPos = randgen.choose(0, treeLength);
        int i = 0;
        while (i < treeLength) {
            actPos = (startPos + i) % treeLength;
            if (this.symbolsComparator.compare(symbol, tree.getNode(actPos)) == 0) {
                return actPos;
            }
            ++i;
        }
        return -1;
    }
}

