/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Preprocess.NoiseFilters.SaturationFilter;

import keel.Algorithms.Preprocess.NoiseFilters.SaturationFilter.Parameters;
import keel.Algorithms.Preprocess.NoiseFilters.SaturationFilter.Quicksort;
import keel.Dataset.Attribute;
import keel.Dataset.Attributes;
import keel.Dataset.Instance;

public class Literals {
    private static final int POSITIVE = 0;
    private static final int NEGATIVE = 1;
    private static final int BOTH = 2;
    private Instance[] instances;
    private boolean[][] literals;
    private int numlit;

    public Literals(Instance[] inst, int positiveClass) {
        this.instances = inst;
        this.createLiteralsSet(positiveClass);
    }

    private void createLiteralsSet(int positiveClass) {
        Attribute att;
        int i;
        int aux = 0;
        int[] index = new int[Parameters.numAttributes];
        for (int i2 = 0; i2 < Parameters.numAttributes; ++i2) {
            index[i2] = aux++;
            if (Attributes.getInputAttribute(i2).getType() != 1) continue;
            aux += 2;
        }
        double[][][] valuesNoRep = new double[2][aux][];
        int[][] values = new int[2][aux];
        aux = 0;
        this.numlit = 0;
        for (i = 0; i < Parameters.numAttributes; ++i) {
            Object[] res;
            att = Attributes.getInputAttribute(i);
            if (att.getType() == 0) {
                res = this.nominales(i, positiveClass, true);
                values[0][aux] = (Integer)res[0];
                valuesNoRep[0][aux] = (double[])res[1];
                values[1][aux] = (Integer)res[2];
                valuesNoRep[1][aux++] = (double[])res[3];
                this.numlit += values[0][aux - 1] + values[1][aux - 1];
            }
            if (att.getType() == 2) {
                res = this.reales(i, positiveClass);
                values[0][aux] = (Integer)res[0];
                valuesNoRep[0][aux] = (double[])res[1];
                values[1][aux] = (Integer)res[2];
                valuesNoRep[1][aux++] = (double[])res[3];
                this.numlit += values[0][aux - 1] / 2 + values[1][aux - 1] / 2;
            }
            if (att.getType() != 1) continue;
            res = this.nominales(i, positiveClass, false);
            values[0][aux] = (Integer)res[0];
            valuesNoRep[0][aux] = (double[])res[1];
            values[1][aux] = (Integer)res[2];
            valuesNoRep[1][aux++] = (double[])res[3];
            this.numlit += values[0][aux - 1] + values[1][aux - 1];
            res = this.reales(i, positiveClass);
            values[0][aux] = (Integer)res[0];
            valuesNoRep[0][aux] = (double[])res[1];
            values[1][aux] = (Integer)res[2];
            valuesNoRep[1][aux++] = (double[])res[3];
            this.numlit += values[0][aux - 1] / 2 + values[1][aux - 1] / 2;
        }
        this.literals = new boolean[this.instances.length][this.numlit];
        this.numlit = 0;
        for (i = 0; i < Parameters.numAttributes; ++i) {
            att = Attributes.getInputAttribute(i);
            if (att.getType() == 0) {
                this.addNominalLiterals(values, valuesNoRep, index[i], i, false);
            }
            if (att.getType() == 2) {
                this.addNumericalLiterals(values, valuesNoRep, index[i], i);
            }
            if (att.getType() != 1) continue;
            this.addNominalLiterals(values, valuesNoRep, index[i], i, true);
            this.addNumericalLiterals(values, valuesNoRep, index[i] + 1, i);
        }
    }

    public int getNumLiterals() {
        return this.numlit;
    }

    public boolean[][] getLiteralsMatrix() {
        return this.literals;
    }

    private Object[] nominales(int att, int claspos, boolean nominalb) {
        int k;
        double[] valuesPOS = new double[this.instances.length];
        double[] valuesNEG = new double[this.instances.length];
        int numPOS = 0;
        int numNEG = 0;
        for (int j = 0; j < this.instances.length; ++j) {
            if (nominalb) {
                if (this.instances[j].getOutputNominalValuesInt(0) == claspos) {
                    valuesPOS[numPOS++] = this.instances[j].getInputNominalValuesInt(att);
                    continue;
                }
                valuesNEG[numNEG++] = this.instances[j].getInputNominalValuesInt(att);
                continue;
            }
            if (this.instances[j].getOutputNominalValuesInt(0) == claspos) {
                valuesPOS[numPOS++] = this.instances[j].getInputRealValues(att);
                continue;
            }
            valuesNEG[numNEG++] = this.instances[j].getInputRealValues(att);
        }
        int numValuesPOS = 0;
        int numValuesNEG = 0;
        double[] valuesNoRepPOS = null;
        double[] valuesNoRepNEG = null;
        if (numPOS > 0) {
            int[] posPOS = Quicksort.sort(valuesPOS, numPOS, 0);
            valuesNoRepPOS = new double[numPOS];
            numValuesPOS = 0;
            double value = valuesPOS[posPOS[0]];
            valuesNoRepPOS[numValuesPOS++] = value;
            for (k = 1; k < numPOS; ++k) {
                if (value == valuesPOS[posPOS[k]]) continue;
                valuesNoRepPOS[numValuesPOS++] = valuesPOS[posPOS[k]];
                value = valuesPOS[posPOS[k]];
            }
        }
        if (numNEG > 0) {
            int[] posNEG = Quicksort.sort(valuesNEG, numNEG, 0);
            valuesNoRepNEG = new double[numNEG];
            numValuesNEG = 0;
            double value = valuesNEG[posNEG[0]];
            valuesNoRepNEG[numValuesNEG++] = value;
            for (k = 1; k < numNEG; ++k) {
                if (value == valuesNEG[posNEG[k]]) continue;
                valuesNoRepNEG[numValuesNEG++] = valuesNEG[posNEG[k]];
                value = valuesNEG[posNEG[k]];
            }
        }
        Object[] res = new Object[4];
        res[1] = valuesNoRepPOS;
        res[0] = numValuesPOS;
        res[3] = valuesNoRepNEG;
        res[2] = numValuesNEG;
        return res;
    }

    private Object[] reales(int att, int positiveClass) {
        double value;
        int i;
        double[] values = new double[Parameters.numInstances];
        for (i = 0; i < Parameters.numInstances; ++i) {
            values[i] = this.instances[i].getInputRealValues(att);
        }
        int[] pos = Quicksort.sort(values, Parameters.numInstances, 0);
        double[] valuesNoRepeated = new double[Parameters.numInstances];
        int size = 0;
        int[] valueClass = new int[Parameters.numInstances];
        for (i = 0; i < Parameters.numInstances; ++i) {
            valueClass[i] = -1;
        }
        valuesNoRepeated[size] = value = this.instances[pos[0]].getInputRealValues(att);
        valueClass[size++] = this.instances[pos[0]].getOutputNominalValuesInt(0);
        for (i = 1; i < Parameters.numInstances; ++i) {
            if (value != this.instances[pos[i]].getInputRealValues(att)) {
                valuesNoRepeated[size] = value = this.instances[pos[i]].getInputRealValues(att);
                if (this.instances[pos[i]].getOutputNominalValuesInt(0) == positiveClass) {
                    valueClass[size++] = 0;
                    continue;
                }
                valueClass[size++] = 1;
                continue;
            }
            if ((this.instances[pos[i]].getOutputNominalValuesInt(0) != positiveClass || valueClass[size - 1] != 1) && (this.instances[pos[i]].getOutputNominalValuesInt(0) == positiveClass || valueClass[size - 1] != 0)) continue;
            valueClass[size - 1] = 2;
        }
        double[][] finalValues = new double[2][size];
        int numvPOS = 0;
        int numvNEG = 0;
        int clase = -1;
        int posit = 0;
        boolean actualClass = false;
        boolean salir = false;
        for (i = 0; i < size && !salir; ++i) {
            if (valueClass[i] != 0) continue;
            actualClass = false;
            finalValues[0][numvPOS++] = valuesNoRepeated[i];
            clase = valueClass[i];
            posit = i;
            salir = true;
        }
        if (numvPOS != 0) {
            for (i = posit + 1; i < size; ++i) {
                if (clase != valueClass[i]) {
                    if (!actualClass) {
                        finalValues[0][numvPOS++] = valuesNoRepeated[i];
                        clase = valueClass[i];
                        actualClass = true;
                        continue;
                    }
                    finalValues[0][numvPOS++] = valuesNoRepeated[i];
                    actualClass = false;
                    clase = valueClass[i];
                    continue;
                }
                if (actualClass) continue;
                finalValues[0][numvPOS - 1] = valuesNoRepeated[i];
            }
            if (clase == 0) {
                --numvPOS;
            }
        }
        salir = false;
        for (i = 0; i < size && !salir; ++i) {
            if (valueClass[i] != 1) continue;
            actualClass = true;
            finalValues[1][numvNEG++] = valuesNoRepeated[i];
            clase = valueClass[i];
            posit = i;
            salir = true;
        }
        if (numvNEG != 0) {
            for (i = posit + 1; i < size; ++i) {
                if (clase != valueClass[i]) {
                    if (!actualClass) {
                        finalValues[1][numvNEG++] = valuesNoRepeated[i];
                        actualClass = true;
                        clase = valueClass[i];
                        continue;
                    }
                    finalValues[1][numvNEG++] = valuesNoRepeated[i];
                    clase = valueClass[i];
                    actualClass = false;
                    continue;
                }
                if (!actualClass) continue;
                finalValues[1][numvNEG - 1] = valuesNoRepeated[i];
            }
            if (clase == 1) {
                --numvNEG;
            }
        }
        Object[] res = new Object[]{numvPOS, finalValues[0], numvNEG, finalValues[1]};
        return res;
    }

    private void addNominalLiterals(int[][] values, double[][][] valuesNoRep, int index, int i, boolean isInteger) {
        int k;
        int p;
        for (p = 0; p < values[0][index]; ++p) {
            for (k = 0; k < this.instances.length; ++k) {
                this.literals[k][this.numlit] = isInteger ? this.instances[k].getInputRealValues(i) == (double)((int)valuesNoRep[0][index][p]) : this.instances[k].getInputNominalValuesInt(i) == (int)valuesNoRep[0][index][p];
            }
            ++this.numlit;
        }
        for (p = 0; p < values[1][index]; ++p) {
            for (k = 0; k < this.instances.length; ++k) {
                this.literals[k][this.numlit] = isInteger ? this.instances[k].getInputRealValues(i) != (double)((int)valuesNoRep[1][index][p]) : this.instances[k].getInputNominalValuesInt(i) != (int)valuesNoRep[1][index][p];
            }
            ++this.numlit;
        }
    }

    private void addNumericalLiterals(int[][] values, double[][][] valuesNoRep, int index, int i) {
        int k;
        int p;
        for (p = 0; p < values[0][index] - 1; p += 2) {
            for (k = 0; k < this.instances.length; ++k) {
                this.literals[k][this.numlit] = this.instances[k].getInputRealValues(i) <= (valuesNoRep[0][index][p] + valuesNoRep[0][index][p + 1]) / 2.0;
            }
            ++this.numlit;
        }
        for (p = 0; p < values[1][index] - 1; p += 2) {
            for (k = 0; k < this.instances.length; ++k) {
                this.literals[k][this.numlit] = this.instances[k].getInputRealValues(i) > (valuesNoRep[1][index][p] + valuesNoRep[1][index][p + 1]) / 2.0;
            }
            ++this.numlit;
        }
    }

    public void printlit() {
        for (int i = 0; i < Parameters.numInstances; ++i) {
            for (int j = 0; j < this.numlit; ++j) {
                System.out.print(this.literals[i][j] + " , ");
            }
            System.out.println();
        }
    }
}

