## ---- include = FALSE---------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(tidyverse)
library(biogrowth)

## -----------------------------------------------------------------------------
data("example_coupled_twosteps")
example_coupled_twosteps

## -----------------------------------------------------------------------------
guess <- c(logC0 = -1, b = .1, Tmin = 5)

## -----------------------------------------------------------------------------
fit_twosteps <- fit_coupled_growth(example_coupled_twosteps, 
                   start = guess,
                   mode = "two_steps")

## -----------------------------------------------------------------------------
fit_twosteps

## -----------------------------------------------------------------------------
summary(fit_twosteps)

## -----------------------------------------------------------------------------
plot(fit_twosteps)

## -----------------------------------------------------------------------------
plot(fit_twosteps) + scale_y_sqrt()

## -----------------------------------------------------------------------------
known <- c(Tmin = 5)

## -----------------------------------------------------------------------------
guess <- c(logC0 = -1, b = .1)

## -----------------------------------------------------------------------------
fit_twosteps_fixed <- fit_coupled_growth(example_coupled_twosteps, 
                   start = guess,
                   known = known,
                   mode = "two_steps")

## -----------------------------------------------------------------------------
summary(fit_twosteps_fixed)

## -----------------------------------------------------------------------------
plot(fit_twosteps_fixed)

## -----------------------------------------------------------------------------
data("example_coupled_onestep")
head(example_coupled_onestep)

## -----------------------------------------------------------------------------
guess <- c(logN0 = 2, logNmax = 8, b = 0.04, logC0 = -4, Tmin = 5)

## -----------------------------------------------------------------------------
fit_onestep <- fit_coupled_growth(example_coupled_onestep,
                             start = guess,
                             mode = "one_step")

## -----------------------------------------------------------------------------
fit_onestep

## -----------------------------------------------------------------------------
summary(fit_onestep)

## -----------------------------------------------------------------------------
plot(fit_onestep)

## -----------------------------------------------------------------------------
known <- c(logN0 = 3)

## -----------------------------------------------------------------------------
guess <- c(logNmax = 8, b = 0.04, logC0 = -4, Tmin = 5)

## -----------------------------------------------------------------------------
fit_onestep <- fit_coupled_growth(example_coupled_onestep,
                             start = guess,
                             known = known,
                             mode = "one_step")

## -----------------------------------------------------------------------------
summary(fit_onestep)

## -----------------------------------------------------------------------------
plot(fit_onestep)

