## ---- include = FALSE---------------------------------------------------------
knitr::opts_chunk$set(
  message = FALSE,
  collapse = TRUE,
  comment = "#>"
)

## -----------------------------------------------------------------------------
library(fauxnaif)
library(magrittr)
fauxnaif::faux_census

## -----------------------------------------------------------------------------
faux_census$income

## -----------------------------------------------------------------------------
na_if_in(faux_census$income, 9999999)

## -----------------------------------------------------------------------------
faux_census$income %>% na_if_in(9999999)

## -----------------------------------------------------------------------------
faux_census$age

## -----------------------------------------------------------------------------
faux_census$age %>% dplyr::na_if(557) %>% dplyr::na_if(2)

## -----------------------------------------------------------------------------
faux_census$age %>% na_if_in(557, 2)

## -----------------------------------------------------------------------------
faux_census$age %>% na_if_not(18:122)

## -----------------------------------------------------------------------------
23 %in% 18:122

## -----------------------------------------------------------------------------
23.5 %in% 18:122

## -----------------------------------------------------------------------------
faux_census$age %>% na_if_in(~ . < 18, ~ . > 122)

## -----------------------------------------------------------------------------
library(dplyr)

faux_census$age %>% na_if_in(~ !between(., 18, 122))

## -----------------------------------------------------------------------------
faux_census$religion

## -----------------------------------------------------------------------------
faux_census$religion %>% na_if_in("Religion is the opiate of the people")

## -----------------------------------------------------------------------------
faux_census$religion %>% na_if_in(~ nchar(.) > 25)

## -----------------------------------------------------------------------------
library(dplyr)

faux_census %>% mutate(income = na_if_in(income, 9999999))

## -----------------------------------------------------------------------------
faux_census %>%
  mutate(across(c(religion, gender, race), na_if_in, ~ nchar(.) > 25))

## -----------------------------------------------------------------------------
faux_census %>% mutate(across(where(is.numeric), na_if_in, ~ grepl("999", .)))

## -----------------------------------------------------------------------------
faux_census %>% mutate(across(everything(), na_if_in, ~ nchar(.) > 25))

## -----------------------------------------------------------------------------
faux_census %>%
  mutate(
    age = na_if_not(age, 18:122),
    across(where(is.numeric), na_if_in, ~ grepl("999", .)),
    across(everything(), na_if_in, ~ nchar(.) > 25)
  )

