/*
 * Decompiled with CFR 0.152.
 */
package org.af.gMCP.gui.datatable;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.af.gMCP.gui.datatable.DataTable;
import org.af.gMCP.gui.datatable.RDataFrameRef;
import org.af.gMCP.gui.datatable.RowModel;

public class SingleDataFramePanel
extends JPanel {
    private DataTable table;
    private JScrollPane scrollPane;
    JTable rowHeader;

    public SingleDataFramePanel(RDataFrameRef dfRefW) {
        this.table = new DataTable(dfRefW);
        this.rowHeader = new JTable(new RowModel(this.table.getModel())){

            @Override
            public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
                Component renderer2 = super.prepareRenderer(renderer, row, column);
                renderer2.setEnabled(this.isEnabled());
                return renderer2;
            }
        };
        this.rowHeader.setRowHeight(this.table.getRowHeight());
        this.scrollPane = new JScrollPane(this.table);
        this.scrollPane.setRowHeaderView(this.rowHeader);
        this.rowHeader.setPreferredScrollableViewportSize(this.rowHeader.getPreferredSize());
        String cols = "fill:pref:grow";
        String rows = "fill:pref:grow";
        FormLayout layout = new FormLayout(cols, rows);
        this.setLayout((LayoutManager)layout);
        CellConstraints cc = new CellConstraints();
        this.add((Component)this.scrollPane, cc.xy(1, 1));
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.table.setEnabled(enabled);
        this.table.getTableHeader().setEnabled(enabled);
        this.rowHeader.setEnabled(enabled);
    }

    public DataTable getTable() {
        return this.table;
    }
}

