/*
 * Decompiled with CFR 0.152.
 */
package org.af.gMCP.gui.power;

import com.jgoodies.forms.layout.CellConstraints;
import java.awt.Component;
import java.util.List;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.af.commons.widgets.validate.RealTextField;
import org.af.commons.widgets.validate.ValidationException;
import org.af.gMCP.gui.graph.Node;
import org.af.gMCP.gui.power.SampleSizeDialog;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Arm {
    List<JCheckBox> includeL = new Vector<JCheckBox>();
    JTextField scname;
    SampleSizeDialog sd;
    RealTextField ratio = new RealTextField("0.0", 10, -1.7976931348623157E308, Double.MAX_VALUE);

    public Arm(SampleSizeDialog sd, String name) {
        this.sd = sd;
        this.scname = new JTextField(name, 25);
        this.ratio.setText("1");
        for (Node n : sd.getNodes()) {
            JCheckBox jc = new JCheckBox();
            this.includeL.add(jc);
        }
    }

    public void addComponents(JPanel panel, CellConstraints cc, int row) {
        int col = 2;
        panel.add((Component)this.scname, cc.xy(col, row));
        panel.add((Component)this.ratio, cc.xy(col += 2, row));
        if (row < 5) {
            this.ratio.setEnabled(false);
        }
        for (JCheckBox jc : this.includeL) {
            panel.add((Component)jc, cc.xy(col += 2, row));
        }
        row += 2;
    }

    public Double getRatio() throws ValidationException {
        return (Double)this.ratio.getValidatedValue();
    }

    public boolean isSelected(int i) {
        return this.includeL.get(i).isSelected();
    }

    public void loadConfig(Element e) {
        this.scname.setText(e.getAttribute("name"));
        this.ratio.setText(e.getAttribute("ratio"));
        NodeList nlist = e.getChildNodes();
        for (int i = 0; i < Math.min(nlist.getLength(), this.includeL.size()); ++i) {
            this.includeL.get(i).setSelected(Boolean.parseBoolean(((Element)nlist.item(i)).getAttribute("include")));
        }
    }

    public Element getConfigNode(Document document) {
        Element e = document.createElement("arm");
        e.setAttribute("name", this.scname.getText());
        e.setAttribute("ratio", this.ratio.getText());
        for (JCheckBox jc : this.includeL) {
            Element eNCP = document.createElement("include");
            eNCP.setAttribute("include", "" + jc.isSelected());
            e.appendChild(eNCP);
        }
        return e;
    }
}

