/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.probdist;

import optimization.Uncmin_f77;
import optimization.Uncmin_methods;
import umontreal.iro.lecuyer.probdist.ContinuousDistribution;
import umontreal.iro.lecuyer.probdist.EmpiricalDist;
import umontreal.iro.lecuyer.util.Misc;

public class CauchyDist
extends ContinuousDistribution {
    private double alpha;
    private double beta;

    public CauchyDist() {
        this.setParams(0.0, 1.0);
    }

    public CauchyDist(double alpha, double beta) {
        this.setParams(alpha, beta);
    }

    public double density(double x) {
        return CauchyDist.density(this.alpha, this.beta, x);
    }

    public double cdf(double x) {
        return CauchyDist.cdf(this.alpha, this.beta, x);
    }

    public double barF(double x) {
        return CauchyDist.barF(this.alpha, this.beta, x);
    }

    public double inverseF(double u) {
        return CauchyDist.inverseF(this.alpha, this.beta, u);
    }

    public double getMean() {
        return CauchyDist.getMean(this.alpha, this.beta);
    }

    public double getVariance() {
        return CauchyDist.getVariance(this.alpha, this.beta);
    }

    public double getStandardDeviation() {
        return CauchyDist.getStandardDeviation(this.alpha, this.beta);
    }

    public static double density(double alpha, double beta, double x) {
        if (beta <= 0.0) {
            throw new IllegalArgumentException("beta <= 0");
        }
        double t = (x - alpha) / beta;
        return 1.0 / (beta * Math.PI * (1.0 + t * t));
    }

    public static double cdf(double alpha, double beta, double x) {
        if (beta <= 0.0) {
            throw new IllegalArgumentException("beta <= 0");
        }
        double z = (x - alpha) / beta;
        if (z < -0.5) {
            return Math.atan(-1.0 / z) / Math.PI;
        }
        return Math.atan(z) / Math.PI + 0.5;
    }

    public static double barF(double alpha, double beta, double x) {
        if (beta <= 0.0) {
            throw new IllegalArgumentException("beta <= 0");
        }
        double z = (x - alpha) / beta;
        if (z > 0.5) {
            return Math.atan(1.0 / z) / Math.PI;
        }
        return 0.5 - Math.atan(z) / Math.PI;
    }

    public static double inverseF(double alpha, double beta, double u) {
        if (beta <= 0.0) {
            throw new IllegalArgumentException("beta <= 0");
        }
        if (u < 0.0 || u > 1.0) {
            throw new IllegalArgumentException("u must be in [0,1]");
        }
        if (u <= 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        if (u >= 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        if (u < 0.5) {
            return alpha - 1.0 / Math.tan(Math.PI * u) * beta;
        }
        return alpha + Math.tan(Math.PI * (u - 0.5)) * beta;
    }

    public static double[] getMLE(double[] x, int n) {
        double sum = 0.0;
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        Optim system = new Optim(x, n);
        double[] parameters = new double[2];
        double[] xpls = new double[3];
        double[] param = new double[3];
        double[] fpls = new double[3];
        double[] gpls = new double[3];
        int[] itrcmd = new int[2];
        double[][] a = new double[3][3];
        double[] udiag = new double[3];
        param[1] = EmpiricalDist.getMedian(x, n);
        int m = Math.round((float)n / 4.0f);
        double q3 = Misc.quickSelect(x, n, 3 * m);
        double q1 = Misc.quickSelect(x, n, m);
        param[2] = (q3 - q1) / 2.0;
        Uncmin_f77.optif0_f77((int)2, (double[])param, (Uncmin_methods)system, (double[])xpls, (double[])fpls, (double[])gpls, (int[])itrcmd, (double[][])a, (double[])udiag);
        for (int i = 0; i < 2; ++i) {
            parameters[i] = xpls[i + 1];
        }
        return parameters;
    }

    public static CauchyDist getInstanceFromMLE(double[] x, int n) {
        double[] parameters = CauchyDist.getMLE(x, n);
        return new CauchyDist(parameters[0], parameters[1]);
    }

    public static double getMean(double alpha, double beta) {
        if (beta <= 0.0) {
            throw new IllegalArgumentException("beta <= 0");
        }
        throw new UnsupportedOperationException("Undefined mean");
    }

    public static double getVariance(double alpha, double beta) {
        if (beta <= 0.0) {
            throw new IllegalArgumentException("beta <= 0");
        }
        return Double.POSITIVE_INFINITY;
    }

    public static double getStandardDeviation(double alpha, double beta) {
        return Double.POSITIVE_INFINITY;
    }

    public double getAlpha() {
        return this.alpha;
    }

    public double getBeta() {
        return this.beta;
    }

    public void setParams(double alpha, double beta) {
        if (beta <= 0.0) {
            throw new IllegalArgumentException("beta <= 0");
        }
        this.alpha = alpha;
        this.beta = beta;
    }

    public double[] getParams() {
        double[] retour = new double[]{this.alpha, this.beta};
        return retour;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " : alpha = " + this.alpha + ", beta = " + this.beta;
    }

    private static class Optim
    implements Uncmin_methods {
        private int n;
        private double[] xi;

        public Optim(double[] x, int n) {
            this.n = n;
            this.xi = new double[n];
            System.arraycopy(x, 0, this.xi, 0, n);
        }

        public double f_to_minimize(double[] p) {
            double sum = 0.0;
            if (p[2] <= 0.0) {
                return 1.0E200;
            }
            for (int i = 0; i < this.n; ++i) {
                sum -= Math.log(CauchyDist.density(p[1], p[2], this.xi[i]));
            }
            return sum;
        }

        public void gradient(double[] x, double[] g) {
        }

        public void hessian(double[] x, double[][] h) {
        }
    }
}

