/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.probdist;

import umontreal.iro.lecuyer.functions.MathFunction;
import umontreal.iro.lecuyer.probdist.ContinuousDistribution;
import umontreal.iro.lecuyer.probdist.GammaDist;
import umontreal.iro.lecuyer.util.Num;

public class ChiDist
extends ContinuousDistribution {
    private int nu;
    private double C1;

    public ChiDist(int nu) {
        this.setNu(nu);
    }

    public double density(double x) {
        if (x <= 0.0) {
            return 0.0;
        }
        return Math.exp((double)(this.nu - 1) * Math.log(x) - x * x / 2.0 - this.C1);
    }

    public double cdf(double x) {
        return ChiDist.cdf(this.nu, x);
    }

    public double barF(double x) {
        return ChiDist.barF(this.nu, x);
    }

    public double inverseF(double u) {
        return ChiDist.inverseF(this.nu, u);
    }

    public double getMean() {
        return ChiDist.getMean(this.nu);
    }

    public double getVariance() {
        return ChiDist.getVariance(this.nu);
    }

    public double getStandardDeviation() {
        return ChiDist.getStandardDeviation(this.nu);
    }

    public static double density(int nu, double x) {
        if (nu <= 0) {
            throw new IllegalArgumentException("nu <= 0");
        }
        if (x <= 0.0) {
            return 0.0;
        }
        return Math.exp((double)(nu - 1) * Math.log(x) - x * x / 2.0 - ((double)nu / 2.0 - 1.0) * 0.6931471805599453 - Num.lnGamma((double)nu / 2.0));
    }

    public static double cdf(int nu, double x) {
        if (x <= 0.0) {
            return 0.0;
        }
        return GammaDist.cdf((double)nu / 2.0, 15, x * x / 2.0);
    }

    public static double barF(int nu, double x) {
        if (x <= 0.0) {
            return 1.0;
        }
        return GammaDist.barF((double)nu / 2.0, 15, x * x / 2.0);
    }

    public static double inverseF(int nu, double u) {
        double res = GammaDist.inverseF((double)nu / 2.0, 15, u);
        return Math.sqrt(2.0 * res);
    }

    public static double[] getMLE(double[] x, int n) {
        double[] parameters = new double[1];
        double mean = 0.0;
        for (int i = 0; i < n; ++i) {
            mean += x[i];
        }
        mean /= (double)n;
        double var = 0.0;
        for (int i = 0; i < n; ++i) {
            var += (x[i] - mean) * (x[i] - mean);
        }
        double k = (double)Math.round((var /= (double)n) + mean * mean) - 5.0;
        if (k < 1.0) {
            k = 1.0;
        }
        double sum = 0.0;
        for (int i = 0; i < n; ++i) {
            if (x[i] > 0.0) {
                sum += Math.log(x[i]);
                continue;
            }
            sum -= 709.0;
        }
        Function f = new Function(sum, n);
        while (f.evaluate(k) > 0.0) {
            k += 1.0;
        }
        parameters[0] = k;
        return parameters;
    }

    public static ChiDist getInstanceFromMLE(double[] x, int n) {
        double[] parameters = ChiDist.getMLE(x, n);
        return new ChiDist((int)parameters[0]);
    }

    public static double getMean(int nu) {
        if (nu <= 0) {
            throw new IllegalArgumentException("nu <= 0");
        }
        return 1.4142135623730951 * Num.gammaRatioHalf((double)nu / 2.0);
    }

    public static double getVariance(int nu) {
        if (nu <= 0) {
            throw new IllegalArgumentException("nu <= 0");
        }
        double mean = ChiDist.getMean(nu);
        return (double)nu - mean * mean;
    }

    public static double getStandardDeviation(int nu) {
        return Math.sqrt(ChiDist.getVariance(nu));
    }

    public int getNu() {
        return this.nu;
    }

    public void setNu(int nu) {
        if (nu <= 0) {
            throw new IllegalArgumentException("nu <= 0");
        }
        this.nu = nu;
        this.supportA = 0.0;
        this.C1 = ((double)nu / 2.0 - 1.0) * 0.6931471805599453 + Num.lnGamma((double)nu / 2.0);
    }

    public double[] getParams() {
        double[] retour = new double[]{this.nu};
        return retour;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " : nu = " + this.nu;
    }

    private static class Function
    implements MathFunction {
        protected int n;
        protected double sum;

        public Function(double s, int n) {
            this.n = n;
            this.sum = s;
        }

        public double evaluate(double k) {
            if (k < 1.0) {
                return 1.0E200;
            }
            return this.sum + (double)this.n * (Num.lnGamma(k / 2.0) - 0.34657359027997264 - Num.lnGamma((k + 1.0) / 2.0));
        }
    }
}

