/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.probdist;

import umontreal.iro.lecuyer.probdist.ContinuousDistribution;
import umontreal.iro.lecuyer.util.Num;

public class HalfNormalDist
extends ContinuousDistribution {
    protected double mu;
    protected double sigma;
    protected double C1;

    public HalfNormalDist(double mu, double sigma) {
        this.setParams(mu, sigma);
    }

    public double density(double x) {
        double z = (x - this.mu) / this.sigma;
        if (z < 0.0) {
            return 0.0;
        }
        return this.C1 * Math.exp(-z * z / 2.0);
    }

    public double cdf(double x) {
        return HalfNormalDist.cdf(this.mu, this.sigma, x);
    }

    public double barF(double x) {
        return HalfNormalDist.barF(this.mu, this.sigma, x);
    }

    public double inverseF(double u) {
        return HalfNormalDist.inverseF(this.mu, this.sigma, u);
    }

    public double getMean() {
        return HalfNormalDist.getMean(this.mu, this.sigma);
    }

    public double getVariance() {
        return HalfNormalDist.getVariance(this.mu, this.sigma);
    }

    public double getStandardDeviation() {
        return HalfNormalDist.getStandardDeviation(this.mu, this.sigma);
    }

    public static double density(double mu, double sigma, double x) {
        if (sigma <= 0.0) {
            throw new IllegalArgumentException("sigma <= 0");
        }
        double Z = (x - mu) / sigma;
        if (Z < 0.0) {
            return 0.0;
        }
        return Math.sqrt(0.6366197723675814) / sigma * Math.exp(-Z * Z / 2.0);
    }

    public static double cdf(double mu, double sigma, double x) {
        if (sigma <= 0.0) {
            throw new IllegalArgumentException("sigma <= 0");
        }
        double Z = (x - mu) / sigma;
        if (Z <= 0.0) {
            return 0.0;
        }
        return Num.erf(Z / 1.4142135623730951);
    }

    public static double barF(double mu, double sigma, double x) {
        if (sigma <= 0.0) {
            throw new IllegalArgumentException("sigma <= 0");
        }
        double Z = (x - mu) / sigma;
        if (Z <= 0.0) {
            return 1.0;
        }
        return Num.erfc(Z / 1.4142135623730951);
    }

    public static double inverseF(double mu, double sigma, double u) {
        if (sigma <= 0.0) {
            throw new IllegalArgumentException("sigma <= 0");
        }
        if (u > 1.0 || u < 0.0) {
            throw new IllegalArgumentException("u not in [0,1]");
        }
        if (u <= 0.0) {
            return mu;
        }
        if (u >= 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        double Z = 1.4142135623730951 * Num.erfInv(u);
        return mu + sigma * Z;
    }

    public static double[] getMLE(double[] x, int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        double mu = Double.MAX_VALUE;
        for (int i = 0; i < n; ++i) {
            if (!(x[i] < mu)) continue;
            mu = x[i];
        }
        double sigma = 0.0;
        for (int i = 0; i < n; ++i) {
            sigma += (x[i] - mu) * (x[i] - mu);
        }
        double[] parametres = new double[]{mu, Math.sqrt(sigma / (double)n)};
        return parametres;
    }

    public static double[] getMLE(double[] x, int n, double mu) {
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        double sigma = 0.0;
        for (int i = 0; i < n; ++i) {
            sigma += (x[i] - mu) * (x[i] - mu);
        }
        double[] parametres = new double[]{Math.sqrt(sigma / (double)n)};
        return parametres;
    }

    public static double getMean(double mu, double sigma) {
        if (sigma <= 0.0) {
            throw new IllegalArgumentException("sigma <= 0");
        }
        return mu + sigma * Math.sqrt(0.6366197723675814);
    }

    public static double getVariance(double mu, double sigma) {
        if (sigma <= 0.0) {
            throw new IllegalArgumentException("sigma <= 0");
        }
        return 0.3633802276324186 * sigma * sigma;
    }

    public static double getStandardDeviation(double mu, double sigma) {
        return Math.sqrt(HalfNormalDist.getVariance(mu, sigma));
    }

    public double getMu() {
        return this.mu;
    }

    public double getSigma() {
        return this.sigma;
    }

    public void setParams(double mu, double sigma) {
        if (sigma <= 0.0) {
            throw new IllegalArgumentException("sigma <= 0");
        }
        this.mu = mu;
        this.sigma = sigma;
        this.C1 = Math.sqrt(0.6366197723675814) / sigma;
    }

    public double[] getParams() {
        double[] retour = new double[]{this.mu, this.sigma};
        return retour;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " : mu = " + this.mu + ", sigma = " + this.sigma;
    }
}

