/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.randvar;

import umontreal.iro.lecuyer.probdist.WeibullDist;
import umontreal.iro.lecuyer.randvar.RandomVariateGen;
import umontreal.iro.lecuyer.rng.RandomStream;

public class WeibullGen
extends RandomVariateGen {
    private double alpha = -1.0;
    private double lambda = -1.0;
    private double delta = -1.0;

    public WeibullGen(RandomStream s, double alpha, double lambda, double delta) {
        super(s, new WeibullDist(alpha, lambda, delta));
        this.setParams(alpha, lambda, delta);
    }

    public WeibullGen(RandomStream s, double alpha) {
        this(s, alpha, 1.0, 0.0);
    }

    public WeibullGen(RandomStream s, WeibullDist dist) {
        super(s, dist);
        if (dist != null) {
            this.setParams(dist.getAlpha(), dist.getLambda(), dist.getDelta());
        }
    }

    public static double nextDouble(RandomStream s, double alpha, double lambda, double delta) {
        return WeibullDist.inverseF(alpha, lambda, delta, s.nextDouble());
    }

    public double getAlpha() {
        return this.alpha;
    }

    public double getLambda() {
        return this.lambda;
    }

    public double getDelta() {
        return this.delta;
    }

    public void setParams(double alpha, double lambda, double delta) {
        if (alpha <= 0.0) {
            throw new IllegalArgumentException("alpha <= 0");
        }
        if (lambda <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        this.alpha = alpha;
        this.lambda = lambda;
        this.delta = delta;
    }
}

