/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.stochprocess;

import umontreal.iro.lecuyer.probdist.InverseGaussianDist;
import umontreal.iro.lecuyer.probdist.NormalDistQuick;
import umontreal.iro.lecuyer.rng.RandomStream;
import umontreal.iro.lecuyer.stochprocess.BrownianMotion;
import umontreal.iro.lecuyer.stochprocess.BrownianMotionPCA;
import umontreal.iro.lecuyer.stochprocess.InverseGaussianProcess;

public class InverseGaussianProcessPCA
extends InverseGaussianProcess {
    protected BrownianMotionPCA bmPCA;

    public InverseGaussianProcessPCA(double s0, double delta, double gamma, RandomStream stream) {
        super(s0, delta, gamma, stream);
        this.bmPCA = new BrownianMotionPCA(0.0, 0.0, delta, stream);
        this.numberOfRandomStreams = 1;
    }

    public double[] generatePath() {
        int i;
        double[] uniformIncrement = new double[this.d];
        double[] BMpath = this.bmPCA.generatePath();
        for (i = 0; i < this.d; ++i) {
            double dt = this.bmPCA.mudt[i];
            double sigma = this.bmPCA.sigmasqrdt[i];
            uniformIncrement[i] = NormalDistQuick.cdf01((BMpath[i + 1] - BMpath[i] - this.bmPCA.mu * dt) / sigma);
        }
        this.path[0] = this.x0;
        for (i = 0; i < this.d; ++i) {
            this.path[i + 1] = this.path[i] + InverseGaussianDist.inverseF(this.imu[i], this.ilam[i], uniformIncrement[i]);
        }
        this.observationIndex = this.d;
        this.observationCounter = this.d;
        return this.path;
    }

    public double[] generatePath(double[] uniforms01) {
        int i;
        double[] uniformIncrement = new double[this.d];
        double[] BMpath = this.bmPCA.generatePath(uniforms01);
        for (i = 0; i < this.d; ++i) {
            double dt = this.bmPCA.mudt[i];
            double sigma = this.bmPCA.sigmasqrdt[i];
            uniformIncrement[i] = NormalDistQuick.cdf01((BMpath[i + 1] - BMpath[i] - this.bmPCA.mu * dt) / sigma);
        }
        this.path[0] = this.x0;
        for (i = 0; i < this.d; ++i) {
            this.path[i + 1] = this.path[i] + InverseGaussianDist.inverseF(this.imu[i], this.ilam[i], uniformIncrement[i]);
        }
        this.observationIndex = this.d;
        this.observationCounter = this.d;
        return this.path;
    }

    public double nextObservation() {
        throw new UnsupportedOperationException("Not implementable for PCA.");
    }

    public void setObservationTimes(double[] t, int d) {
        super.setObservationTimes(t, d);
        this.bmPCA.setObservationTimes(t, d);
    }

    public RandomStream getStream() {
        if (this.stream != this.bmPCA.getStream()) {
            throw new IllegalStateException("Two different streams or more are present");
        }
        return this.stream;
    }

    public void setStream(RandomStream stream) {
        super.setStream(stream);
        this.bmPCA.setStream(stream);
    }

    public void setBrownianMotionPCA(BrownianMotionPCA bmPCA) {
        this.bmPCA = bmPCA;
    }

    public BrownianMotion getBrownianMotionPCA() {
        return this.bmPCA;
    }
}

