#### Setup #####################################################################

# save random seed
reallyoldseed <- get_random_seed()

#### Tests #####################################################################
invisible(runif(1))

## set_random_seed() et al.
o <- ironseed:::rm_random_seed()
expect_false(is.null(o))
expect_false(has_random_seed())

## set_random_seed() returns NULL if no seed is set.
expect_silent(o <- set_random_seed(o))
expect_silent(runif(1))
expect_null(o)

## set_random_seed() unsets the seed if passed NULL
expect_silent(o <- set_random_seed(o))
expect_false(has_random_seed())
expect_silent(runif(1))

## set_random_seed() does nothing if both old and new seed are "NULL"
expect_silent(set_random_seed(NULL))
expect_false(has_random_seed())
expect_silent(runif(1))

## fill_random_seed() supports ironseed or stream input
one_fe <- create_ironseed("aaLzYxsxyhf-4B9K67L14fH-XZzrm2vU6w5-CHFFPRH8UCb")
one_fe_stream <- ironseed_stream(one_fe)
expect_message(fill_random_seed(one_fe, quiet = FALSE))
expect_equal(sample(1000L, 4L), c(897, 834, 696, 863))
expect_silent(fill_random_seed(one_fe_stream, quiet = FALSE))
expect_equal(sample(1000L, 4L), c(897, 834, 696, 863))

## Reseeding with one_fe will be the same
expect_message(fill_random_seed(one_fe, quiet = FALSE))
expect_equal(sample(1000L, 4L), c(897, 834, 696, 863))

## But reseeding with one_fe_stream will differ
expect_silent(fill_random_seed(one_fe_stream, quiet = FALSE))
expect_equal(sample(1000L, 4L), c(635, 293, 907, 708))

#### Cleanup ###################################################################

# restore random seed
set_random_seed(reallyoldseed)
