/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.common.util.preprocessor.detector.scheduling;

import choco.Choco;
import choco.cp.common.util.preprocessor.detector.scheduling.AbstractSchedulingConstraintDetector;
import choco.cp.common.util.preprocessor.detector.scheduling.DisjunctiveModel;
import choco.cp.model.CPModel;
import choco.kernel.model.constraints.Constraint;
import choco.kernel.model.constraints.ConstraintType;
import choco.kernel.model.constraints.TemporalConstraint;

public abstract class AbstractTemporalDetector
extends AbstractSchedulingConstraintDetector {
    public AbstractTemporalDetector(CPModel model, DisjunctiveModel disjMod) {
        super(model, disjMod);
    }

    @Override
    protected boolean isInPreprocess(Constraint c) {
        if (super.isInPreprocess(c) && c instanceof TemporalConstraint) {
            TemporalConstraint ct = (TemporalConstraint)c;
            return ct.isInPreprocess();
        }
        return false;
    }

    @Override
    protected void setUp() {
    }

    @Override
    protected void tearDown() {
    }

    @Override
    protected final void apply(Constraint c) {
        this.apply((TemporalConstraint)c);
    }

    protected abstract void apply(TemporalConstraint var1);

    protected final void reformulateImpliedReified(TemporalConstraint ct) {
        assert (ct.getConstraintType() == ConstraintType.PRECEDENCE_IMPLIED || ct.getConstraintType() == ConstraintType.PRECEDENCE_REIFIED);
        if (this.disjMod.containsArc(ct.getOrigin(), ct.getDestination())) {
            this.delete(ct);
            this.replaceBy(ct.getDirection(), Choco.ONE);
            if (ct.forwardSetup() > this.disjMod.setupTime(ct.getOrigin(), ct.getDestination())) {
                this.add(Choco.precedence(ct.getOrigin(), ct.getDestination(), ct.forwardSetup()));
            }
        } else if (this.disjMod.containsArc(ct.getDestination(), ct.getOrigin())) {
            this.delete(ct);
            this.replaceBy(ct.getDirection(), Choco.ZERO);
        }
    }
}

