/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.common.util.preprocessor.detector.scheduling;

import choco.Choco;
import choco.cp.common.util.preprocessor.detector.scheduling.DisjunctiveGraph;
import choco.kernel.common.IDotty;
import choco.kernel.model.Model;
import choco.kernel.model.ModelException;
import choco.kernel.model.constraints.TemporalConstraint;
import choco.kernel.model.variables.MultipleVariables;
import choco.kernel.model.variables.integer.IntegerVariable;
import choco.kernel.model.variables.scheduling.TaskVariable;
import java.util.Iterator;

public class DisjunctiveModel
extends DisjunctiveGraph<TemporalConstraint> {
    public final Model model;

    public DisjunctiveModel(Model model) {
        super(model.getNbStoredMultipleVars());
        this.model = model;
    }

    public final Model getModel() {
        return this.model;
    }

    public final int setupTime(TaskVariable i, TaskVariable j) {
        return this.setupTime(i.getHook(), j.getHook());
    }

    public final boolean containsArc(TaskVariable i, TaskVariable j) {
        return this.containsArc(i.getHook(), j.getHook());
    }

    public final boolean containsEdge(TaskVariable i, TaskVariable j) {
        return this.containsEdge(i.getHook(), j.getHook());
    }

    public final boolean containsRelation(TaskVariable i, TaskVariable j) {
        return this.containsRelation(i.getHook(), j.getHook());
    }

    public final void safeAddArc(TaskVariable i, TaskVariable j) {
        this.safeAddArc(i.getHook(), j.getHook(), j.start().getLowB() - i.end().getUppB());
    }

    private boolean mergeSetupTime(int key, int setupTime) {
        if (this.setupTimes.get(key) < setupTime) {
            this.setupTimes.put(key, setupTime);
            return true;
        }
        return false;
    }

    private boolean mergeArc(int i, int j, int setupTime, TemporalConstraint c) {
        int key = this.getKey(i, j);
        if (this.mergeSetupTime(key, setupTime)) {
            TemporalConstraint cdm = (TemporalConstraint)this.storedConstraints.get(key);
            if (cdm == null) {
                this.storedConstraints.put(key, c);
                return false;
            }
            if (i == cdm.getOHook()) {
                cdm.setForwardSetup(setupTime);
            } else {
                cdm.setBackwardSetup(setupTime);
            }
        }
        return true;
    }

    public boolean safeAddArc(TemporalConstraint c) {
        assert (c.isFixed());
        int i = c.getOHook();
        int j = c.getDHook();
        if (c.getDirVal() == 0) {
            if (this.containsArc(j, i)) {
                return this.mergeArc(j, i, c.backwardSetup(), c);
            }
            this.addArc(j, i, c.backwardSetup(), c);
        } else {
            if (this.containsArc(i, j)) {
                return this.mergeArc(i, j, c.forwardSetup(), c);
            }
            this.addArc(i, j, c.forwardSetup(), c);
        }
        return false;
    }

    private void mergeFwdSetup(int key, int setupTime, TemporalConstraint dest) {
        if (this.mergeSetupTime(key, setupTime)) {
            dest.setForwardSetup(setupTime);
        }
    }

    private void mergeBwdSetup(int key, int setupTime, TemporalConstraint dest) {
        if (this.mergeSetupTime(key, setupTime)) {
            dest.setBackwardSetup(setupTime);
        }
    }

    private AddEdgeStatus mergeEdge(int i, int j, TemporalConstraint ct) {
        int key1 = this.getKey(i, j);
        int key2 = this.getKey(j, i);
        TemporalConstraint cij = (TemporalConstraint)this.storedConstraints.get(key1);
        TemporalConstraint cji = (TemporalConstraint)this.storedConstraints.get(key2);
        if (cij != null) {
            this.mergeFwdSetup(key1, ct.forwardSetup(), cij);
            this.mergeBwdSetup(key2, ct.backwardSetup(), cij);
            return new AddEdgeStatus(true, cij.getDirection());
        }
        if (cji != null) {
            this.mergeBwdSetup(key1, ct.forwardSetup(), cji);
            this.mergeFwdSetup(key2, ct.backwardSetup(), cji);
            return new AddEdgeStatus(true, null, cji.getDirection());
        }
        throw new ModelException("No Edge");
    }

    public final AddEdgeStatus safeAddEdge(TemporalConstraint c) {
        int j;
        assert (!c.getDirection().isConstant());
        int i = c.getOHook();
        if (this.containsArc(i, j = c.getDHook())) {
            return new AddEdgeStatus(this.mergeArc(i, j, c.forwardSetup(), c), Choco.ONE);
        }
        if (this.containsArc(j, i)) {
            return new AddEdgeStatus(this.mergeArc(j, i, c.backwardSetup(), c), Choco.ZERO);
        }
        if (this.containsEdge(i, j)) {
            return this.mergeEdge(i, j, c);
        }
        this.addEdge(i, j, c);
        return new AddEdgeStatus(false);
    }

    @Override
    protected void writeArcAttributes(StringBuilder b, int i, int j) {
        if (this.containsConstraint(i, j)) {
            super.writeArcAttributes(b, i, j);
        } else {
            this.writeAttributes(b, "color=forestgreen", "style=\"bold,dashed\"");
        }
    }

    @Override
    protected final StringBuilder toDottyNodes() {
        StringBuilder b = new StringBuilder();
        Iterator<MultipleVariables> iter = this.model.getMultipleVarIterator();
        while (iter.hasNext()) {
            MultipleVariables mv = iter.next();
            if (!(mv instanceof IDotty)) continue;
            b.append(((IDotty)((Object)mv)).toDotty()).append('\n');
        }
        return b;
    }

    static final class AddEdgeStatus {
        public boolean deleteC;
        public IntegerVariable repV;
        public IntegerVariable oppV;

        public AddEdgeStatus(boolean deleteC) {
            this(deleteC, null, null);
        }

        public AddEdgeStatus(boolean deleteC, IntegerVariable repV) {
            this(deleteC, repV, null);
        }

        public AddEdgeStatus(boolean deleteC, IntegerVariable repV, IntegerVariable oppV) {
            this.deleteC = deleteC;
            this.repV = repV;
            this.oppV = oppV;
        }
    }
}

