/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver;

import choco.cp.model.CPModel;
import choco.cp.solver.CPModelToCPSolver;
import choco.cp.solver.configure.LimitFactory;
import choco.cp.solver.configure.RestartFactory;
import choco.cp.solver.configure.StrategyFactory;
import choco.cp.solver.constraints.global.Occurrence;
import choco.cp.solver.constraints.global.scheduling.precedence.PrecedenceDisjoint;
import choco.cp.solver.constraints.global.scheduling.precedence.PrecedenceVDisjoint;
import choco.cp.solver.constraints.global.scheduling.precedence.PrecedenceVSDisjoint;
import choco.cp.solver.constraints.integer.EqualXC;
import choco.cp.solver.constraints.integer.EqualXYC;
import choco.cp.solver.constraints.integer.EqualXY_C;
import choco.cp.solver.constraints.integer.GreaterOrEqualXC;
import choco.cp.solver.constraints.integer.GreaterOrEqualXYC;
import choco.cp.solver.constraints.integer.GreaterOrEqualXY_C;
import choco.cp.solver.constraints.integer.LessOrEqualXC;
import choco.cp.solver.constraints.integer.LessOrEqualXY_C;
import choco.cp.solver.constraints.integer.MaxOfAList;
import choco.cp.solver.constraints.integer.NotEqualXC;
import choco.cp.solver.constraints.integer.NotEqualXYC;
import choco.cp.solver.constraints.integer.NotEqualXY_C;
import choco.cp.solver.constraints.integer.bool.sat.ClauseStore;
import choco.cp.solver.constraints.integer.extension.AC2001BinSConstraint;
import choco.cp.solver.constraints.integer.extension.AC3BinSConstraint;
import choco.cp.solver.constraints.integer.extension.AC3rmBinSConstraint;
import choco.cp.solver.constraints.integer.extension.AC3rmBitBinSConstraint;
import choco.cp.solver.constraints.integer.extension.CspLargeSConstraint;
import choco.cp.solver.constraints.integer.extension.GAC2001LargeSConstraint;
import choco.cp.solver.constraints.integer.extension.GAC2001PositiveLargeConstraint;
import choco.cp.solver.constraints.integer.extension.GAC3rmLargeConstraint;
import choco.cp.solver.constraints.integer.extension.GAC3rmPositiveLargeConstraint;
import choco.cp.solver.constraints.integer.extension.GACstrPositiveLargeSConstraint;
import choco.cp.solver.constraints.integer.intlincomb.IntLinCombFactory;
import choco.cp.solver.constraints.real.Equation;
import choco.cp.solver.constraints.real.MixedEqXY;
import choco.cp.solver.constraints.real.exp.RealCos;
import choco.cp.solver.constraints.real.exp.RealIntegerPower;
import choco.cp.solver.constraints.real.exp.RealMinus;
import choco.cp.solver.constraints.real.exp.RealMult;
import choco.cp.solver.constraints.real.exp.RealPlus;
import choco.cp.solver.constraints.real.exp.RealSin;
import choco.cp.solver.constraints.reified.ExpressionSConstraint;
import choco.cp.solver.constraints.reified.ReifiedFactory;
import choco.cp.solver.constraints.set.Disjoint;
import choco.cp.solver.constraints.set.IsIncluded;
import choco.cp.solver.constraints.set.MemberXY;
import choco.cp.solver.constraints.set.SetCard;
import choco.cp.solver.constraints.set.SetEq;
import choco.cp.solver.constraints.set.SetIntersection;
import choco.cp.solver.constraints.set.SetNotEq;
import choco.cp.solver.constraints.set.SetUnion;
import choco.cp.solver.propagation.ChocoEngine;
import choco.cp.solver.search.BranchingFactory;
import choco.cp.solver.search.GlobalSearchStrategy;
import choco.cp.solver.search.GoalSearchLoop;
import choco.cp.solver.search.integer.branching.AssignVar;
import choco.cp.solver.search.integer.branching.ImpactBasedBranching;
import choco.cp.solver.search.integer.valiterator.IncreasingDomain;
import choco.cp.solver.search.integer.valselector.RandomIntValSelector;
import choco.cp.solver.search.integer.varselector.RandomIntVarSelector;
import choco.cp.solver.search.real.AssignInterval;
import choco.cp.solver.search.real.CyclicRealVarSelector;
import choco.cp.solver.search.real.RealIncreasingDomain;
import choco.cp.solver.search.set.AssignSetVar;
import choco.cp.solver.search.set.MinDomSet;
import choco.cp.solver.search.set.MinEnv;
import choco.cp.solver.search.set.RandomSetValSelector;
import choco.cp.solver.search.set.RandomSetVarSelector;
import choco.cp.solver.variables.integer.BoolVarNot;
import choco.cp.solver.variables.integer.BooleanVarImpl;
import choco.cp.solver.variables.integer.IntDomainVarAddCste;
import choco.cp.solver.variables.integer.IntDomainVarImpl;
import choco.cp.solver.variables.integer.IntDomainVarTimePosCste;
import choco.cp.solver.variables.integer.IntTerm;
import choco.cp.solver.variables.real.RealVarImpl;
import choco.cp.solver.variables.set.SetVarImpl;
import choco.kernel.common.Constant;
import choco.kernel.common.IndexFactory;
import choco.kernel.common.logging.ChocoLogging;
import choco.kernel.common.logging.Verbosity;
import choco.kernel.common.util.iterators.DisposableIterator;
import choco.kernel.common.util.tools.MathUtils;
import choco.kernel.common.util.tools.StringUtils;
import choco.kernel.common.util.tools.VariableUtils;
import choco.kernel.memory.IEnvironment;
import choco.kernel.memory.IStateInt;
import choco.kernel.memory.structure.PartiallyStoredVector;
import choco.kernel.memory.structure.StoredBipartiteVarSet;
import choco.kernel.memory.trailing.EnvironmentTrailing;
import choco.kernel.model.Model;
import choco.kernel.model.constraints.Constraint;
import choco.kernel.model.variables.Variable;
import choco.kernel.model.variables.integer.IntegerVariable;
import choco.kernel.model.variables.real.RealVariable;
import choco.kernel.model.variables.scheduling.TaskVariable;
import choco.kernel.model.variables.set.SetVariable;
import choco.kernel.solver.Configuration;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.ResolutionPolicy;
import choco.kernel.solver.Solution;
import choco.kernel.solver.Solver;
import choco.kernel.solver.SolverException;
import choco.kernel.solver.branch.AbstractIntBranchingStrategy;
import choco.kernel.solver.branch.BranchingWithLoggingStatements;
import choco.kernel.solver.branch.VarSelector;
import choco.kernel.solver.constraints.AbstractSConstraint;
import choco.kernel.solver.constraints.SConstraint;
import choco.kernel.solver.constraints.global.MetaSConstraint;
import choco.kernel.solver.constraints.integer.AbstractIntSConstraint;
import choco.kernel.solver.constraints.integer.IntExp;
import choco.kernel.solver.constraints.integer.extension.BinRelation;
import choco.kernel.solver.constraints.integer.extension.ConsistencyRelation;
import choco.kernel.solver.constraints.integer.extension.CouplesBitSetTable;
import choco.kernel.solver.constraints.integer.extension.CouplesTable;
import choco.kernel.solver.constraints.integer.extension.ExtensionalBinRelation;
import choco.kernel.solver.constraints.integer.extension.IterLargeRelation;
import choco.kernel.solver.constraints.integer.extension.IterTuplesTable;
import choco.kernel.solver.constraints.integer.extension.LargeRelation;
import choco.kernel.solver.constraints.integer.extension.TuplesList;
import choco.kernel.solver.constraints.integer.extension.TuplesTable;
import choco.kernel.solver.constraints.real.RealExp;
import choco.kernel.solver.goals.Goal;
import choco.kernel.solver.propagation.PropagationEngine;
import choco.kernel.solver.propagation.Propagator;
import choco.kernel.solver.propagation.listener.PropagationEngineListener;
import choco.kernel.solver.propagation.listener.SetPropagator;
import choco.kernel.solver.search.AbstractGlobalSearchStrategy;
import choco.kernel.solver.search.AbstractSearchLoop;
import choco.kernel.solver.search.ISolutionDisplay;
import choco.kernel.solver.search.ValIterator;
import choco.kernel.solver.search.ValSelector;
import choco.kernel.solver.search.integer.AbstractIntVarSelector;
import choco.kernel.solver.search.limit.AbstractGlobalSearchLimit;
import choco.kernel.solver.search.limit.Limit;
import choco.kernel.solver.search.set.AbstractSetVarSelector;
import choco.kernel.solver.variables.AbstractVar;
import choco.kernel.solver.variables.Var;
import choco.kernel.solver.variables.integer.IntDomainVar;
import choco.kernel.solver.variables.integer.IntVar;
import choco.kernel.solver.variables.real.RealIntervalConstant;
import choco.kernel.solver.variables.real.RealMath;
import choco.kernel.solver.variables.real.RealVar;
import choco.kernel.solver.variables.scheduling.TaskVar;
import choco.kernel.solver.variables.set.SetVar;
import gnu.trove.TLongObjectHashMap;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.logging.Level;

public class CPSolver
implements Solver {
    private final IndexFactory indexfactory;
    private Boolean feasible = null;
    private final IEnvironment environment;
    protected PropagationEngine propagationEngine;
    private final IStateInt indexOfLastInitializedStaticConstraint;
    private boolean uniqueReading = true;
    protected CPModel model;
    private final PartiallyStoredVector<Propagator> constraints;
    final StoredBipartiteVarSet<IntDomainVar> intVars;
    final StoredBipartiteVarSet<SetVar> setVars;
    final StoredBipartiteVarSet<RealVar> floatVars;
    final StoredBipartiteVarSet<TaskVar> taskVars;
    final List<IntDomainVar> intDecisionVars;
    final List<SetVar> setDecisionVars;
    final List<RealVar> floatDecisionVars;
    final List<TaskVar> taskDecisionVars;
    private final Map<Integer, IntDomainVar> intconstantVars;
    private final Map<Double, RealIntervalConstant> realconstantVars;
    protected final TLongObjectHashMap<Var> mapvariables;
    protected final TLongObjectHashMap<SConstraint> mapconstraints;
    private Var objective;
    private IntDomainVar makespan;
    private ClauseStore nogoodStore;
    private int propNogoodWorld = -1;
    protected AbstractGlobalSearchStrategy strategy;
    private VarSelector<IntDomainVar> varIntSelector = null;
    private VarSelector<RealVar> varRealSelector = null;
    private VarSelector<SetVar> varSetSelector = null;
    private ValIterator<IntDomainVar> valIntIterator;
    private ValIterator<RealVar> valRealIterator = null;
    private ValIterator<SetVar> valSetIterator = null;
    private ValSelector<IntDomainVar> valIntSelector = null;
    private ValSelector<RealVar> valRealSelector = null;
    private ValSelector<SetVar> valSetSelector = null;
    protected CPModelToCPSolver mod2sol;
    protected AbstractIntBranchingStrategy tempGoal;
    private Goal ilogGoal = null;
    protected final Configuration configuration;
    protected long readingTime;
    private ISolutionDisplay solutionDisplay;
    public static final boolean GOAL = false;
    @Deprecated
    public static final int SILENT = 0;
    @Deprecated
    public static final int SOLUTION = 1;
    @Deprecated
    public static final int SEARCH = 2;
    @Deprecated
    public static final int PROPAGATION = 3;
    @Deprecated
    public static final int FINEST = 4;

    @Override
    @Deprecated
    public void setLoggingMaxDepth(int loggingMaxDepth) {
        ChocoLogging.setLoggingMaxDepth(loggingMaxDepth);
    }

    @Override
    @Deprecated
    public int getLoggingMaxDepth() {
        return ChocoLogging.getLoggingMaxDepth();
    }

    @Override
    @Deprecated
    public void setSolutionPoolCapacity(int capacity) {
        this.configuration.putInt("cp.solution.pool_capacity", capacity);
    }

    public CPSolver() {
        this(new EnvironmentTrailing());
    }

    public CPSolver(IEnvironment env) {
        this(env, null);
    }

    public CPSolver(Configuration configuration) {
        this(new EnvironmentTrailing(), configuration);
    }

    public CPSolver(IEnvironment env, Configuration configuration) {
        this.environment = env;
        this.configuration = configuration == null ? new Configuration() : new Configuration(configuration);
        this.mod2sol = new CPModelToCPSolver(this);
        this.mapvariables = new TLongObjectHashMap();
        this.mapconstraints = new TLongObjectHashMap();
        this.intVars = new StoredBipartiteVarSet(env);
        this.setVars = new StoredBipartiteVarSet(env);
        this.floatVars = new StoredBipartiteVarSet(env);
        this.taskVars = new StoredBipartiteVarSet(env);
        this.intDecisionVars = new ArrayList<IntDomainVar>(16);
        this.setDecisionVars = new ArrayList<SetVar>(8);
        this.floatDecisionVars = new ArrayList<RealVar>(8);
        this.taskDecisionVars = new ArrayList<TaskVar>(8);
        this.intconstantVars = new HashMap<Integer, IntDomainVar>(10);
        this.realconstantVars = new HashMap<Double, RealIntervalConstant>(8);
        this.propagationEngine = new ChocoEngine(this);
        this.constraints = env.makePartiallyStoredVector();
        this.indexfactory = new IndexFactory();
        this.indexOfLastInitializedStaticConstraint = env.makeInt(PartiallyStoredVector.getFirstStaticIndex() - 1);
    }

    @Override
    public final AbstractGlobalSearchStrategy getSearchStrategy() {
        return this.strategy;
    }

    public void resetSearchStrategy() {
        this.clearGoals();
        this.strategy = null;
    }

    @Override
    public void clear() {
        this.mod2sol.clear();
        this.mapvariables.clear();
        this.mapconstraints.clear();
        this.intVars.clear();
        this.setVars.clear();
        this.floatVars.clear();
        this.taskVars.clear();
        this.intDecisionVars.clear();
        this.setDecisionVars.clear();
        this.floatDecisionVars.clear();
        this.taskDecisionVars.clear();
        this.intconstantVars.clear();
        this.realconstantVars.clear();
        this.constraints.clear();
        this.mapvariables.clear();
        this.mapconstraints.clear();
        this.environment.clear();
        this.propagationEngine.clear();
        this.indexOfLastInitializedStaticConstraint.set(PartiallyStoredVector.getFirstStaticIndex() - 1);
        this.strategy = null;
        this.feasible = null;
        this.uniqueReading = true;
        this.ilogGoal = null;
        this.tempGoal = null;
        this.propNogoodWorld = -1;
        this.nogoodStore = null;
        this.makespan = null;
        this.objective = null;
        this.varIntSelector = null;
        this.valIntIterator = null;
        this.valIntSelector = null;
        this.varSetSelector = null;
        this.valSetIterator = null;
        this.valSetIterator = null;
        this.varRealSelector = null;
        this.varRealSelector = null;
        this.model = null;
    }

    public final boolean isUniqueReading() {
        return this.uniqueReading;
    }

    public final void setUniqueReading(boolean uniqueReading) {
        this.uniqueReading = uniqueReading;
    }

    @Override
    public final void setSolutionDisplay(ISolutionDisplay prettySolution) {
        this.solutionDisplay = prettySolution;
    }

    @Override
    public final IndexFactory getIndexfactory() {
        return this.indexfactory;
    }

    public boolean contains(Variable v) {
        return this.mapvariables.containsKey(v.getIndex());
    }

    public String summaryToString() {
        StringBuilder buffer = new StringBuilder(40);
        buffer.append("Pb[");
        buffer.append(this.getNbIntVars() + this.getNbRealVars() + this.getNbSetVars()).append(" vars, ");
        buffer.append(this.getNbTaskVars()).append(" tasks, ");
        buffer.append(this.getNbIntConstraints()).append(" cons]");
        if (this.strategy != null) {
            buffer.append("\nLimits");
            buffer.append(this.strategy.runtimeStatistics());
        }
        return new String(buffer);
    }

    @Override
    public String pretty() {
        StringBuffer buf = new StringBuffer(this.summaryToString());
        buf.append('\n');
        buf.append(this.varsToString());
        buf.append(this.constraintsToString());
        return new String(buf);
    }

    public String varsToString() {
        int i;
        StringBuffer buf = new StringBuffer(40);
        buf.append("==== VARIABLES ====\n");
        for (i = 0; i < this.getNbIntVars(); ++i) {
            buf.append(this.getIntVar(i).pretty());
            buf.append('\n');
        }
        for (int i1 = 0; i1 < this.floatVars.size(); ++i1) {
            Object floatVar = this.floatVars.get(i1);
            RealVar realVar = (RealVar)floatVar;
            buf.append(realVar.pretty());
            buf.append('\n');
        }
        for (i = 0; i < this.setVars.size(); ++i) {
            buf.append(this.getSetVar(i).pretty());
            buf.append('\n');
        }
        buf.append("==== TASKS ====\n");
        buf.append(StringUtils.prettyOnePerLine(this.taskVars.toList()));
        return new String(buf);
    }

    public String constraintsToString() {
        StringBuffer buf = new StringBuffer(40);
        buf.append("==== CONSTRAINTS ====\n");
        DisposableIterator it = this.constraints.getIterator();
        while (it.hasNext()) {
            AbstractSConstraint c = (AbstractSConstraint)it.next();
            buf.append(c.pretty());
            buf.append('\n');
        }
        it.dispose();
        return new String(buf);
    }

    public String toString() {
        return this.summaryToString();
    }

    @Override
    public void read(Model m) {
        long timer = -System.currentTimeMillis();
        if (this.model == null) {
            this.model = (CPModel)m;
            this.initReading();
        } else {
            if (this.model != m) {
                LOGGER.severe("Reading two different models is forbidden!");
                throw new SolverException("Reading two different models is forbidden!");
            }
            LOGGER.warning("Reading a model twice or more is strongly inadvisable!");
        }
        this.mod2sol.readVariables(this.model);
        this.mod2sol.readDecisionVariables();
        this.mod2sol.readConstraints(this.model);
        this.readingTime = timer + System.currentTimeMillis();
    }

    protected void initReading() {
        this.environment.createSharedBipartiteSet(this.model.getNbBoolVar());
    }

    public SConstraint makeSConstraint(Constraint mc) {
        return this.mod2sol.makeSConstraint(mc);
    }

    public SConstraint makeSConstraint(Constraint mc, boolean b) {
        return this.mod2sol.makeSConstraint(mc, b);
    }

    public SConstraint[] makeSConstraintAndOpposite(Constraint mc) {
        return this.mod2sol.makeSConstraintAndOpposite(mc);
    }

    public SConstraint[] makeSConstraintAndOpposite(Constraint mc, boolean b) {
        return this.mod2sol.makeSConstraintAndOpposite(mc, b);
    }

    public void addConstraint(Constraint ... tabic) {
        this.addConstraint(false, tabic);
    }

    public void addConstraint(boolean dynamic, Constraint ... tabic) {
        Constraint[] arr$ = tabic;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Constraint aTabic;
            Constraint ic = aTabic = arr$[i$];
            DisposableIterator<Variable> it = ic.getVariableIterator();
            while (it.hasNext()) {
                Variable v = (Variable)it.next();
                if (this.mapvariables.containsKey(v.getIndex())) continue;
                this._readVariable(v);
            }
            ic.findManager(CPModel.properties);
            this.mod2sol.readConstraint(ic, this.model.getDefaultExpressionDecomposition(), dynamic);
        }
    }

    private void _readVariable(Variable v) {
        v.findManager(CPModel.properties);
        switch (v.getVariableType()) {
            case INTEGER: 
            case SET: 
            case REAL: 
            case CONSTANT_INTEGER: 
            case CONSTANT_DOUBLE: 
            case CONSTANT_SET: {
                this.mod2sol.readModelVariable(v);
                break;
            }
            case INTEGER_EXPRESSION: 
            case SET_EXPRESSION: 
            case REAL_EXPRESSION: 
            case MULTIPLE_VARIABLES: {
                DisposableIterator<Variable> it = v.getVariableIterator();
                while (it.hasNext()) {
                    this._readVariable((Variable)it.next());
                }
                break;
            }
            default: {
                throw new SolverException("unknown variable type :" + (Object)((Object)v.getVariableType()));
            }
        }
    }

    @Override
    public Model getModel() {
        return this.model;
    }

    @Override
    public void setModel(Model aModel) {
        this.model = (CPModel)aModel;
    }

    @Override
    @Deprecated
    public final void setPrecision(double aPrecision) {
        this.configuration.putDouble("cp.real.precision", aPrecision);
    }

    @Override
    @Deprecated
    public final double getPrecision() {
        return this.configuration.readDouble("cp.real.precision");
    }

    @Override
    @Deprecated
    public final void setReduction(double aReduction) {
        this.configuration.putDouble("cp.real.reduction", aReduction);
    }

    @Override
    @Deprecated
    public final double getReduction() {
        return this.configuration.readDouble("cp.real.reduction");
    }

    @Override
    public final IEnvironment getEnvironment() {
        return this.environment;
    }

    @Override
    public final void setFeasible(Boolean b) {
        this.feasible = b;
    }

    @Override
    public String solutionToString() {
        if (this.solutionDisplay == null) {
            Var v;
            StringBuffer buf = new StringBuffer(40);
            for (int i = 0; i < this.getNbIntVars(); ++i) {
                v = this.getIntVar(i);
                if (!v.isInstantiated()) continue;
                buf.append(v.toString());
                buf.append(", ");
            }
            for (int j = 0; j < this.getNbRealVars(); ++j) {
                v = this.getRealVar(j);
                if (!v.isInstantiated()) continue;
                buf.append(v.toString());
                buf.append(", ");
            }
            for (int k = 0; k < this.getNbSetVars(); ++k) {
                v = this.getSetVar(k);
                if (!v.isInstantiated()) continue;
                buf.append(v.toString());
                buf.append(", ");
            }
            return new String(buf);
        }
        return this.solutionDisplay.solutionToString();
    }

    public void setRandomSelectors(long seed) {
        this.setRandomSelectors(new Random(seed));
    }

    public void setRandomSelectors() {
        this.setRandomSelectors(new Random());
    }

    public void setRandomSelectors(Random manager) {
        Var[] v;
        if (this.intDecisionVars == null || this.intDecisionVars.isEmpty()) {
            this.setVarIntSelector(new RandomIntVarSelector((Solver)this, manager.nextLong()));
        } else {
            v = this.intDecisionVars.toArray(new IntDomainVar[this.intDecisionVars.size()]);
            this.setVarIntSelector(new RandomIntVarSelector(this, (IntDomainVar[])v, manager.nextLong()));
        }
        this.valIntSelector = new RandomIntValSelector(manager.nextLong());
        if (this.setDecisionVars == null || this.setDecisionVars.isEmpty()) {
            this.setVarSetSelector(new RandomSetVarSelector((Solver)this, manager.nextLong()));
        } else {
            v = this.setDecisionVars.toArray(new SetVar[this.setDecisionVars.size()]);
            this.setVarSetSelector(new RandomSetVarSelector(this, (SetVar[])v, manager.nextLong()));
        }
        this.valSetSelector = new RandomSetValSelector(manager.nextLong());
    }

    @Override
    public void generateSearchStrategy() {
        if (!(this.tempGoal instanceof ImpactBasedBranching) || this.strategy == null) {
            if (null == this.objective) {
                StrategyFactory.validateCSP(this);
                this.strategy = new GlobalSearchStrategy(this);
            } else {
                if (this.ilogGoal != null) {
                    throw new UnsupportedOperationException("Ilog goal are not yet available in optimization");
                }
                this.strategy = StrategyFactory.createBranchAndBound(this);
            }
        }
        assert (this.strategy != null);
        this.strategy.setSolutionPool(StrategyFactory.createSolutionPool(this.strategy));
        this.generateSearchLoop();
        this.strategy.setLimitManager(LimitFactory.createLimitManager(this.strategy));
        this.strategy.setShavingTools(StrategyFactory.createShavingTools(this));
        if (this.ilogGoal == null) {
            if (this.tempGoal == null) {
                this.generateDefaultGoal();
            } else {
                this.attachGoal(this.tempGoal);
                this.tempGoal = null;
            }
        }
        if (ChocoLogging.getBranchingLogger().isLoggable(Level.INFO)) {
            if (this.strategy.mainGoal == null) {
                LOGGER.warning("can not set logging (no goals)");
            } else {
                this.strategy.mainGoal = BranchingWithLoggingStatements.setLoggingStatement(this.strategy.mainGoal);
            }
        }
    }

    protected void generateSearchLoop() {
        AbstractSearchLoop searchLoop = this.ilogGoal != null ? new GoalSearchLoop(this.strategy, this.ilogGoal) : StrategyFactory.createSearchLoop(this.strategy);
        this.strategy.setSearchLoop(searchLoop);
    }

    public AbstractIntBranchingStrategy generateDefaultRealGoal() {
        if (this.varRealSelector == null) {
            if (this.floatDecisionVars.isEmpty()) {
                this.varRealSelector = new CyclicRealVarSelector(this);
            } else {
                RealVar[] tvars = new RealVar[this.floatDecisionVars.size()];
                this.floatDecisionVars.toArray(tvars);
                this.varRealSelector = new CyclicRealVarSelector(this, tvars);
            }
        }
        if (this.valRealIterator == null && this.valRealSelector == null) {
            this.valRealIterator = new RealIncreasingDomain();
        }
        return this.valRealIterator != null ? new AssignInterval(this.varRealSelector, this.valRealIterator) : new AssignVar(this.varRealSelector, this.valRealSelector);
    }

    public AbstractIntBranchingStrategy generateSetDefaultGoal() {
        if (this.varSetSelector == null) {
            if (this.setDecisionVars.isEmpty()) {
                this.varSetSelector = new MinDomSet(this);
            } else {
                SetVar[] t = new SetVar[this.setDecisionVars.size()];
                this.setDecisionVars.toArray(t);
                this.varSetSelector = new MinDomSet(this, t);
            }
        }
        if (this.valSetSelector == null && this.valSetIterator == null) {
            this.valSetSelector = new MinEnv();
        }
        return new AssignSetVar(this.varSetSelector, this.valSetSelector);
    }

    public AbstractIntBranchingStrategy generateDefaultIntGoal() {
        if (this.valIntIterator == null && this.valIntSelector == null) {
            this.valIntIterator = new IncreasingDomain();
        }
        if (this.varIntSelector == null) {
            if (this.intDecisionVars.isEmpty()) {
                return this.valIntIterator == null ? BranchingFactory.incDomWDegBin(this, this.valIntSelector) : BranchingFactory.incDomWDeg(this, this.valIntIterator);
            }
            IntDomainVar[] t = new IntDomainVar[this.intDecisionVars.size()];
            this.intDecisionVars.toArray(t);
            return this.valIntIterator == null ? BranchingFactory.incDomWDegBin(this, t, this.valIntSelector) : BranchingFactory.incDomWDeg(this, t, this.valIntIterator);
        }
        return this.valIntIterator == null ? new AssignVar(this.varIntSelector, this.valIntSelector) : new AssignVar(this.varIntSelector, this.valIntIterator);
    }

    protected void generateDefaultGoal() {
        boolean first = true;
        if (this.getNbSetVars() > 0 && !this.setDecisionVars.isEmpty()) {
            this.addGoal(this.generateSetDefaultGoal());
            first = false;
        }
        if (this.getNbIntVars() > 0 && !this.intDecisionVars.isEmpty()) {
            if (first) {
                this.addGoal(this.generateDefaultIntGoal());
                first = false;
            } else {
                this.addGoal(this.generateDefaultIntGoal());
            }
        }
        if (this.getNbRealVars() > 0 && !this.floatDecisionVars.isEmpty()) {
            if (first) {
                this.addGoal(this.generateDefaultRealGoal());
            } else {
                this.addGoal(this.generateDefaultRealGoal());
            }
        }
    }

    @Override
    @Deprecated
    public void attachGoal(AbstractIntBranchingStrategy branching) {
        this.clearGoals();
        this.addGoal(branching);
    }

    @Override
    public void addGoal(AbstractIntBranchingStrategy branching) {
        if (this.strategy == null) {
            if (this.tempGoal == null) {
                this.tempGoal = branching;
            } else {
                AbstractIntBranchingStrategy br = this.tempGoal;
                while (br.getNextBranching() != null) {
                    br = (AbstractIntBranchingStrategy)br.getNextBranching();
                }
                br.setNextBranching(branching);
            }
        } else {
            branching.setSolver(this.strategy);
            if (this.strategy.mainGoal == null) {
                for (AbstractIntBranchingStrategy br = branching; br != null; br = (AbstractIntBranchingStrategy)br.getNextBranching()) {
                    br.setSolver(this.strategy);
                }
                this.strategy.mainGoal = branching;
            } else {
                AbstractIntBranchingStrategy br = this.strategy.mainGoal;
                while (br.getNextBranching() != null) {
                    br = (AbstractIntBranchingStrategy)br.getNextBranching();
                }
                br.setNextBranching(branching);
            }
        }
    }

    @Override
    public void clearGoals() {
        if (this.strategy == null) {
            AbstractIntBranchingStrategy br = this.tempGoal;
            while (br != null) {
                AbstractIntBranchingStrategy tmp = (AbstractIntBranchingStrategy)br.getNextBranching();
                br.setNextBranching(null);
                br = tmp;
            }
        } else {
            AbstractIntBranchingStrategy br = this.strategy.mainGoal;
            while (br != null) {
                if (this.strategy.mainGoal instanceof PropagationEngineListener) {
                    ((PropagationEngineListener)((Object)this.strategy.mainGoal)).safeDelete();
                }
                AbstractIntBranchingStrategy tmp = (AbstractIntBranchingStrategy)br.getNextBranching();
                br.setNextBranching(null);
                br = tmp;
            }
        }
    }

    @Override
    public final void setIlogGoal(Goal anIlogGoal) {
        this.ilogGoal = anIlogGoal;
    }

    @Override
    public void launch() {
        this.strategy.incrementalRun();
    }

    @Override
    public int getNbSolutions() {
        return this.strategy.getSolutionCount();
    }

    @Override
    @Deprecated
    public void monitorTimeLimit(boolean b) {
    }

    @Override
    @Deprecated
    public void monitorNodeLimit(boolean b) {
    }

    @Override
    @Deprecated
    public void monitorBackTrackLimit(boolean b) {
    }

    @Override
    public void monitorFailLimit(boolean b) {
        if (b) {
            this.propagationEngine.getFailMeasure().safeAdd();
        } else {
            this.propagationEngine.getFailMeasure().safeDelete();
        }
    }

    @Override
    public void setTimeLimit(int timeLimit) {
        LimitFactory.setSearchLimit(this, Limit.TIME, timeLimit);
    }

    @Override
    public void setNodeLimit(int nodeLimit) {
        LimitFactory.setSearchLimit(this, Limit.NODE, nodeLimit);
    }

    @Override
    public void setBackTrackLimit(int backTrackLimit) {
        LimitFactory.setSearchLimit(this, Limit.BACKTRACK, backTrackLimit);
    }

    @Override
    public void setFailLimit(int failLimit) {
        LimitFactory.setSearchLimit(this, Limit.FAIL, failLimit);
    }

    @Override
    public void setRestartLimit(int restartLimit) {
        LimitFactory.setRestartLimit(this, Limit.RESTART, restartLimit);
    }

    @Override
    public int getReadingTimeCount() {
        return this.model == null ? 0 : (int)this.readingTime;
    }

    @Override
    public int getInitialPropagationTimeCount() {
        return this.strategy == null ? 0 : 0;
    }

    @Override
    public final int getTimeCount() {
        return this.strategy == null ? 0 : this.strategy.getTimeCount();
    }

    @Override
    public final int getNodeCount() {
        return this.strategy == null ? 0 : this.strategy.getNodeCount();
    }

    @Override
    public final int getBackTrackCount() {
        return this.strategy == null ? 0 : this.strategy.getBackTrackCount();
    }

    @Override
    public final int getFailCount() {
        return this.strategy == null ? 0 : this.strategy.getFailCount();
    }

    @Override
    public final int getRestartCount() {
        return this.strategy == null ? 0 : this.strategy.getRestartCount();
    }

    @Override
    public final int getSolutionCount() {
        return this.strategy == null ? 0 : this.strategy.getSolutionCount();
    }

    @Override
    public final Number getObjectiveValue() {
        if (this.strategy.getObjectiveManager() != null && this.existsSolution()) {
            return this.strategy.getObjectiveManager().getBestObjectiveValue();
        }
        return null;
    }

    @Override
    public boolean isObjectiveOptimal() {
        boolean firstSolution = this.configuration.readBoolean("cp.resolution.stop_at_first_solution");
        return this.existsSolution() && !firstSolution && !this.isEncounteredLimit();
    }

    @Override
    public boolean existsSolution() {
        return this.strategy != null && this.strategy.existsSolution();
    }

    @Override
    public final boolean getFirstSolution() {
        return this.configuration.readBoolean("cp.resolution.stop_at_first_solution");
    }

    @Override
    public final void setFirstSolution(boolean stopAtFirstSolution) {
        this.configuration.putBoolean("cp.resolution.stop_at_first_solution", stopAtFirstSolution);
    }

    @Override
    public void setVarIntSelector(VarSelector<IntDomainVar> varSelector) {
        if (this.varIntSelector != null && this.varIntSelector instanceof PropagationEngineListener) {
            ((PropagationEngineListener)((Object)this.varIntSelector)).safeDelete();
        }
        this.varIntSelector = varSelector;
        IntDomainVar[] vars = ((AbstractIntVarSelector)varSelector).getVars();
        if (vars != null) {
            this.intDecisionVars.clear();
            this.intDecisionVars.addAll(Arrays.asList(vars));
        } else if (!this.intDecisionVars.isEmpty()) {
            vars = new IntDomainVar[this.intDecisionVars.size()];
            this.intDecisionVars.toArray(vars);
            ((AbstractIntVarSelector)varSelector).setVars(vars);
        } else {
            this.intDecisionVars.addAll(this.intVars.toList());
        }
    }

    @Override
    public void setVarRealSelector(VarSelector<RealVar> realVarSelector) {
        this.varRealSelector = realVarSelector;
        this.floatDecisionVars.addAll(this.floatVars.toList());
    }

    @Override
    public void setVarSetSelector(VarSelector<SetVar> setVarSelector) {
        this.varSetSelector = setVarSelector;
        SetVar[] vars = ((AbstractSetVarSelector)setVarSelector).getVars();
        if (vars != null) {
            this.setDecisionVars.clear();
            this.setDecisionVars.addAll(Arrays.asList(vars));
        } else if (!this.setDecisionVars.isEmpty()) {
            vars = new SetVar[this.setDecisionVars.size()];
            this.setDecisionVars.toArray(vars);
            ((AbstractSetVarSelector)setVarSelector).setVars(vars);
        } else {
            this.setDecisionVars.addAll(this.setVars.toList());
        }
    }

    @Override
    public void setValIntIterator(ValIterator<IntDomainVar> valIterator) {
        this.valIntIterator = valIterator;
    }

    @Override
    public void setValRealIterator(ValIterator<RealVar> realValIterator) {
        this.valRealIterator = realValIterator;
    }

    @Override
    public void setValSetIterator(ValIterator<SetVar> valIterator) {
        this.valSetIterator = valIterator;
    }

    @Override
    public void setValIntSelector(ValSelector<IntDomainVar> valSelector) {
        this.valIntSelector = valSelector;
    }

    @Override
    public void setValRealSelector(ValSelector<RealVar> valSelector) {
        this.valRealSelector = valSelector;
    }

    @Override
    public void setValSetSelector(ValSelector<SetVar> setValIntSelector) {
        this.valSetSelector = setValIntSelector;
    }

    public void setGeometricRestart(int base, double grow) {
        RestartFactory.setGeometricalRestartPolicy(this, base, grow);
    }

    public void setGeometricRestart(int base, double grow, int restartLimit) {
        RestartFactory.setGeometricalRestartPolicy(this, base, grow);
        LimitFactory.setRestartLimit(this, Limit.RESTART, restartLimit);
    }

    public void setLubyRestart(int base, int grow, int restartLimit) {
        RestartFactory.setLubyRestartPolicy(this, base, grow);
        LimitFactory.setRestartLimit(this, Limit.RESTART, restartLimit);
    }

    public void setLubyRestart(int base, int grow) {
        RestartFactory.setLubyRestartPolicy(this, base, grow);
    }

    public void setRecordNogoodFromRestart(boolean recordNogoodFromRestart) {
        this.configuration.putBoolean("cp.restart.nogood_recording", recordNogoodFromRestart);
    }

    @Override
    public void setRestart(boolean restart) {
        this.configuration.putBoolean("cp.restart.after_solution", restart);
    }

    @Override
    @Deprecated
    public void setDoMaximize(boolean maximize) {
        StrategyFactory.setDoOptimize(this, maximize);
    }

    @Override
    public void setObjective(Var anObjective) {
        if (this.strategy == null) {
            this.objective = anObjective;
        } else if (this.objective != anObjective) {
            throw new SolverException("Set the objective before the generation of the strategy.");
        }
    }

    @Override
    public final Var getObjective() {
        return this.objective;
    }

    @Override
    public boolean isOptimizationSolver() {
        return this.objective != null;
    }

    @Override
    @Deprecated
    public Number getOptimumValue() {
        return this.getObjectiveValue();
    }

    @Override
    public void setHorizon(int horizon) {
        if (this.makespan != null) {
            throw new SolverException("cant set the scheduling horizon: makespan variable already exists.");
        }
        this.configuration.putInt("cp.scheduling.horizon", horizon);
    }

    @Override
    public final int getHorizon() {
        return this.configuration.readInt("cp.scheduling.horizon");
    }

    protected void setMakespan(Var makespan) {
        if (this.makespan != null) {
            throw new SolverException("duplicate makespan variable.");
        }
        this.makespan = (IntDomainVar)makespan;
    }

    public IntDomainVar createMakespan() {
        if (this.makespan == null) {
            int horizon = this.configuration.readInt("cp.scheduling.horizon");
            this.makespan = this.createBoundIntVar("makespan", 0, horizon);
        }
        return this.makespan;
    }

    @Override
    public final IntDomainVar getMakespan() {
        return this.makespan;
    }

    @Override
    public int getMakespanValue() {
        int horizon = this.configuration.readInt("cp.scheduling.horizon");
        return this.makespan == null ? horizon : this.makespan.getVal();
    }

    protected SConstraint makeMapespanConstraint() {
        IntDomainVar[] vars = new IntDomainVar[this.getNbTaskVars() + 1];
        vars[0] = this.makespan;
        for (int i = 0; i < this.getNbTaskVars(); ++i) {
            vars[i + 1] = this.getTaskVar(i).end();
        }
        return new MaxOfAList(this.environment, vars);
    }

    public void postMakespanConstraint() {
        if (this.getNbTaskVars() > 0) {
            if (this.makespan != null) {
                IntDomainVar[] vars = new IntDomainVar[this.getNbTaskVars() + 1];
                vars[0] = this.makespan;
                for (int i = 0; i < this.getNbTaskVars(); ++i) {
                    vars[i + 1] = this.getTaskVar(i).end();
                }
                this.post((SConstraint)new MaxOfAList(this.environment, vars));
            } else {
                int horizon = this.configuration.readInt("cp.scheduling.horizon");
                if (horizon < 21474836) {
                    for (TaskVar t : this.taskVars) {
                        t.postHorizonConstraint(this, horizon);
                    }
                }
            }
        } else if (this.makespan != null) {
            throw new SolverException("Unused makespan variable");
        }
    }

    public void postTaskConsistencyConstraints() {
        for (int i = 0; i < this.getNbTaskVars(); ++i) {
            this.getTaskVar(i).detectOrPostConsistencyConstraint(this);
        }
    }

    @Override
    public boolean isEncounteredLimit() {
        return this.strategy != null && this.strategy.isEncounteredLimit();
    }

    @Override
    public final AbstractGlobalSearchLimit getEncounteredLimit() {
        return this.strategy == null ? null : this.strategy.getEncounteredLimit();
    }

    @Override
    public final PropagationEngine getPropagationEngine() {
        return this.propagationEngine;
    }

    @Override
    public final IntDomainVar[] getIntDecisionVars() {
        return VariableUtils.getDecisionList(this.intDecisionVars, this.intVars.toList(), IntDomainVar.class);
    }

    @Override
    public final SetVar[] getSetDecisionVars() {
        return VariableUtils.getDecisionList(this.setDecisionVars, this.setVars.toList(), SetVar.class);
    }

    @Override
    public final RealVar[] getRealDecisionVars() {
        return VariableUtils.getDecisionList(this.floatDecisionVars, this.floatVars.toList(), RealVar.class);
    }

    @Override
    public final TaskVar[] getTaskDecisionVars() {
        return VariableUtils.getDecisionList(this.taskDecisionVars, this.taskVars.toList(), TaskVar.class);
    }

    @Override
    public final IntDomainVar getIntVar(int i) {
        return (IntDomainVar)this.intVars.get(i);
    }

    @Override
    public final IntDomainVar getIntVarQuick(int i) {
        return (IntDomainVar)this.intVars.getQuick(i);
    }

    public void addIntVar(IntDomainVar v) {
        this.intVars.add(v);
    }

    @Override
    public final Var getIntConstant(int i) {
        return this.intconstantVars.get(i);
    }

    public void addIntConstant(int value, IntDomainVar i) {
        this.intconstantVars.put(value, i);
    }

    @Override
    public final Var getRealConstant(double i) {
        return this.realconstantVars.get(i);
    }

    public void addrealConstant(double value, RealIntervalConstant i) {
        this.realconstantVars.put(value, i);
    }

    @Override
    public final Collection<Integer> getIntConstantSet() {
        return this.intconstantVars.keySet();
    }

    @Override
    public final Collection<Double> getRealConstantSet() {
        return this.realconstantVars.keySet();
    }

    public final int getNbIntConstants() {
        return this.intconstantVars.size();
    }

    public final int getNbRealConstants() {
        return this.realconstantVars.size();
    }

    @Override
    public final int getNbConstants() {
        return this.intconstantVars.size() + this.realconstantVars.size();
    }

    @Override
    public final int getIntVarIndex(IntVar c) {
        return this.intVars.indexOf((IntDomainVar)c);
    }

    public final int getIntVarIndex(IntDomainVar c) {
        return this.intVars.indexOf(c);
    }

    public final int getSetVarIndex(SetVar c) {
        return this.setVars.indexOf(c);
    }

    public final int getRealVarIndex(RealVar c) {
        return this.floatVars.indexOf(c);
    }

    @Override
    public int getNbVars() {
        return this.getNbIntVars() + this.getNbRealVars() + this.getNbSetVars() + this.getNbTaskVars();
    }

    @Override
    public final int getNbIntVars() {
        return this.intVars.size();
    }

    @Override
    public final RealVar getRealVar(int i) {
        return (RealVar)this.floatVars.get(i);
    }

    @Override
    public final RealVar getRealVarQuick(int i) {
        return (RealVar)this.floatVars.getQuick(i);
    }

    public void addRealVar(RealVar rv) {
        this.floatVars.add(rv);
    }

    @Override
    public final int getNbRealVars() {
        return this.floatVars.size();
    }

    @Override
    public final SetVar getSetVar(int i) {
        return (SetVar)this.setVars.get(i);
    }

    @Override
    public final SetVar getSetVarQuick(int i) {
        return (SetVar)this.setVars.getQuick(i);
    }

    public void addSetVar(SetVar sv) {
        this.setVars.add(sv);
    }

    @Override
    public final int getNbSetVars() {
        return this.setVars.size();
    }

    @Override
    public final int getNbTaskVars() {
        return this.taskVars.size();
    }

    @Override
    public final TaskVar getTaskVar(int i) {
        return (TaskVar)this.taskVars.get(i);
    }

    @Override
    public final TaskVar getTaskVarQuick(int i) {
        return (TaskVar)this.taskVars.getQuick(i);
    }

    @Override
    public int getNbConstraints() {
        return this.getNbIntConstraints() + (this.nogoodStore == null ? 0 : this.nogoodStore.getNbClause());
    }

    @Override
    public final int getNbIntConstraints() {
        return this.constraints.size();
    }

    @Override
    @Deprecated
    public final AbstractIntSConstraint getIntConstraint(int i) {
        return (AbstractIntSConstraint)this.constraints.get(i);
    }

    @Override
    public final DisposableIterator<IntDomainVar> getIntVarIterator() {
        return this.intVars.quickIterator();
    }

    @Override
    public final DisposableIterator<SetVar> getSetVarIterator() {
        return this.setVars.quickIterator();
    }

    @Override
    public final DisposableIterator<RealVar> getRealVarIterator() {
        return this.floatVars.quickIterator();
    }

    @Override
    public DisposableIterator<TaskVar> getTaskVarIterator() {
        return this.taskVars.quickIterator();
    }

    @Override
    @Deprecated
    public final DisposableIterator<SConstraint> getIntConstraintIterator() {
        return this.constraints.getIterator();
    }

    @Override
    public final DisposableIterator<SConstraint> getConstraintIterator() {
        return this.constraints.getIterator();
    }

    @Override
    public final Boolean isFeasible() {
        return this.feasible;
    }

    public boolean isConsistent() {
        DisposableIterator<SConstraint> ctit = this.getConstraintIterator();
        while (ctit.hasNext()) {
            if (((AbstractSConstraint)ctit.next()).isConsistent()) continue;
            return false;
        }
        ctit.dispose();
        return true;
    }

    public boolean isCompletelyInstantiated() {
        int n = this.getNbIntVars();
        for (int i = 0; i < n; ++i) {
            if (this.getIntVar(i).isInstantiated()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void eraseConstraint(SConstraint c) {
        this.constraints.remove(c);
        ((AbstractSConstraint)c).setPassive();
        for (int i = 0; i < c.getNbVars(); ++i) {
            AbstractVar v = (AbstractVar)c.getVar(i);
            v.eraseConstraint(c);
        }
    }

    protected void post(SConstraint cc, boolean dynamicPost) {
        if (cc instanceof Propagator) {
            if (!(cc.equals(Constant.TRUE) && this.constraints.contains(Constant.TRUE) || cc.equals(Constant.FALSE) && this.constraints.contains(Constant.FALSE))) {
                Propagator c = (Propagator)((Object)cc);
                c.activate(this.environment);
                c.setPropagationEngine(this.propagationEngine);
                if (dynamicPost) {
                    this.constraints.add(c);
                } else {
                    int idx = this.constraints.staticAdd(c);
                    this.indexOfLastInitializedStaticConstraint.set(idx);
                }
                c.addListener(dynamicPost);
                this.propagationEngine.registerPropagator(c);
                this.propagationEngine.postConstAwake(c, true);
                this.postRedundantSetConstraints(cc);
                if (this.strategy != null) {
                    this.strategy.initMainGoal(cc);
                }
            }
        } else if (cc instanceof ExpressionSConstraint) {
            ExpressionSConstraint p = (ExpressionSConstraint)cc;
            p.setScope(this);
            this.decisionOnExpression(p);
        } else if (cc instanceof MetaSConstraint) {
            MetaSConstraint p = (MetaSConstraint)cc;
            p.addListener(true);
            int nbc = p.getNbSubConstraints();
            for (int i = 0; i < nbc; ++i) {
                this.post(p.getSubConstraints(i), true);
            }
        } else {
            throw new SolverException("impossible to post constraint : " + (cc == null ? "(null)" : cc.getClass().getSimpleName()));
        }
    }

    @Override
    public void postCut(SConstraint cc) {
        this.post(cc, false);
    }

    @Override
    public void post(SConstraint cc) {
        this.post(cc, true);
    }

    public void post(SConstraint ... ccs) {
        for (SConstraint cc : ccs) {
            this.post(cc);
        }
    }

    protected void decisionOnExpression(ExpressionSConstraint exp) {
        Boolean forceDecomp = exp.isDecomposeExp();
        boolean canBeDecomp = exp.checkDecompositionIsPossible();
        if (forceDecomp != null) {
            if (forceDecomp.booleanValue() && canBeDecomp) {
                this.post(exp.getDecomposition(this));
            } else {
                this.post(exp.getExtensionnal(this));
            }
        } else if (exp.getNbVars() == 0) {
            if (exp.checkTuple(new int[0])) {
                this.post((SConstraint)Constant.TRUE);
            } else {
                this.post((SConstraint)Constant.FALSE);
            }
        } else if (canBeDecomp) {
            this.post(exp.getDecomposition(this));
        } else {
            this.post(exp.getExtensionnal(this));
        }
    }

    public void postRedundantSetConstraints(SConstraint p) {
        if (this.configuration.readBoolean("cp.propagation.cardinality_reasonning") && p instanceof SetPropagator && p.getNbVars() > 1) {
            if (p instanceof MemberXY) {
                IntDomainVar card0 = ((SetVar)p.getVar(1)).getCard();
                this.post(this.geq((IntExp)card0, 1));
            } else if (p instanceof IsIncluded) {
                IntDomainVar card0 = ((SetVar)p.getVar(0)).getCard();
                IntDomainVar card1 = ((SetVar)p.getVar(1)).getCard();
                this.post(this.leq((IntExp)card0, (IntExp)card1));
            } else if (p instanceof SetUnion) {
                IntDomainVar card0 = ((SetVar)p.getVar(0)).getCard();
                IntDomainVar card1 = ((SetVar)p.getVar(1)).getCard();
                IntDomainVar card3 = ((SetVar)p.getVar(2)).getCard();
                this.post(this.geq(this.plus((IntExp)card0, (IntExp)card1), (IntExp)card3));
            } else if (p instanceof SetIntersection) {
                IntDomainVar card0 = ((SetVar)p.getVar(0)).getCard();
                IntDomainVar card1 = ((SetVar)p.getVar(1)).getCard();
                IntDomainVar card3 = ((SetVar)p.getVar(2)).getCard();
                this.post(this.geq((IntExp)card0, (IntExp)card3));
                this.post(this.geq((IntExp)card1, (IntExp)card3));
            } else if (p instanceof Disjoint) {
                IntDomainVar card0 = ((SetVar)p.getVar(0)).getCard();
                IntDomainVar card1 = ((SetVar)p.getVar(1)).getCard();
                int ub = Math.max(((SetVar)p.getVar(0)).getEnveloppeSup(), ((SetVar)p.getVar(1)).getEnveloppeSup());
                int lb = Math.min(((SetVar)p.getVar(0)).getEnveloppeInf(), ((SetVar)p.getVar(1)).getEnveloppeInf());
                SetVar z = this.createBoundSetVar(StringUtils.randomName(), lb, ub);
                this.setVars.add(z);
                this.intVars.add(z.getCard());
                this.post((SConstraint)new SetUnion((SetVar)p.getVar(0), (SetVar)p.getVar(1), z));
                this.post(this.eq(this.plus((IntExp)card0, (IntExp)card1), (IntExp)z.getCard()));
            }
        }
    }

    public void addNogood(IntDomainVar[] poslit, IntDomainVar[] neglit) {
        if (this.nogoodStore == null) {
            this.nogoodStore = new ClauseStore(this.getBooleanVariables(), this.environment);
            this.postCut(this.nogoodStore);
        }
        this.nogoodStore.addNoGood(poslit, neglit);
        this.propNogoodWorld = this.getWorldIndex();
        this.nogoodStore.constAwake(false);
    }

    public void initNogoodBase() {
        if (this.nogoodStore != null) {
            this.nogoodStore.setActiveSilently();
            this.nogoodStore.constAwake(false);
        }
    }

    public final ClauseStore getNogoodStore() {
        return this.nogoodStore;
    }

    @Override
    public final int getNbBooleanVars() {
        int cpt = 0;
        for (int i = 0; i < this.getNbIntVars(); ++i) {
            IntDomainVar v = this.getIntVar(i);
            if (!v.hasBooleanDomain()) continue;
            ++cpt;
        }
        return cpt;
    }

    public IntDomainVar[] getBooleanVariables() {
        ArrayList<IntDomainVar> bvs = new ArrayList<IntDomainVar>(16);
        for (int i = 0; i < this.getNbIntVars(); ++i) {
            IntDomainVar v = this.getIntVarQuick(i);
            if (!v.hasBooleanDomain()) continue;
            bvs.add(v);
        }
        IntDomainVar[] boolvars = new IntDomainVar[bvs.size()];
        bvs.toArray(boolvars);
        return boolvars;
    }

    @Override
    public void propagate() throws ContradictionException {
        this.propagationEngine.propagateEvents();
    }

    @Override
    public void worldPush() {
        this.environment.worldPush();
    }

    @Override
    public void worldPop() {
        this.environment.worldPop();
        this.propagationEngine.flushEvents();
        int lastStaticIdx = this.constraints.getLastStaticIndex();
        for (int i = this.indexOfLastInitializedStaticConstraint.get() + 1; i <= lastStaticIdx; ++i) {
            Propagator c = this.constraints.get(i);
            if (c == null) continue;
            c.setPassive();
            c.constAwake(true);
        }
        if (this.propNogoodWorld > this.getWorldIndex()) {
            this.nogoodStore.setActiveSilently();
            this.nogoodStore.constAwake(false);
            this.propNogoodWorld = this.getWorldIndex();
        }
    }

    @Override
    public void worldPopUntil(int n) {
        while (this.environment.getWorldIndex() > n) {
            this.worldPop();
        }
    }

    @Override
    public void worldPushDuringPropagation() {
        this.propagationEngine.freeze();
        this.environment.worldPush();
    }

    @Override
    public void worldPopDuringPropagation() {
        this.environment.worldPop();
        this.propagationEngine.flushEvents();
        this.propagationEngine.unfreeze();
    }

    @Override
    public final int getWorldIndex() {
        return this.environment.getWorldIndex();
    }

    @Override
    public Boolean solve(boolean all) {
        this.setFirstSolution(!all);
        this.generateSearchStrategy();
        this.launch();
        return this.feasible;
    }

    @Override
    public Boolean solve() {
        return this.solve(false);
    }

    @Override
    public Boolean solveAll() {
        return this.solve(true);
    }

    @Override
    public Boolean nextSolution() {
        return this.strategy.nextSolution();
    }

    @Override
    public Boolean checkSolution() {
        return this.checkSolution(true);
    }

    public Boolean checkSolution(boolean enableConsistency) {
        DEFAULT_SOLUTION_CHECKER.setEnableConsistency(enableConsistency);
        return DEFAULT_SOLUTION_CHECKER.inspectSolution(this);
    }

    @Override
    public boolean checkDecisionVariables() {
        boolean isOk = true;
        if (this.intDecisionVars != null) {
            for (IntDomainVar intDecisionVar : this.intDecisionVars) {
                isOk &= intDecisionVar.isInstantiated();
            }
        }
        if (this.setDecisionVars != null) {
            for (SetVar setDecisionVar : this.setDecisionVars) {
                isOk &= setDecisionVar.isInstantiated();
            }
        }
        if (this.floatDecisionVars != null) {
            for (RealVar floatDecisionVar : this.floatDecisionVars) {
                isOk &= floatDecisionVar.isInstantiated();
            }
        }
        return isOk;
    }

    @Override
    public void printRuntimeStatistics() {
        LOGGER.info(this.runtimeStatistics());
    }

    @Override
    public String runtimeStatistics() {
        if (this.strategy != null) {
            return StringUtils.pretty(this.strategy) + " - " + this.strategy.limitManager.pretty();
        }
        return "";
    }

    @Override
    public Boolean minimize(Var obj, boolean restart) {
        return this.optimize(false, obj, restart);
    }

    @Override
    public Boolean minimize(boolean restart) {
        if (this.objective == null) {
            throw new SolverException("No objective variable defined");
        }
        return this.optimize(false, this.objective, restart);
    }

    @Override
    public Boolean maximize(Var obj, boolean restart) {
        return this.optimize(true, obj, restart);
    }

    @Override
    public Boolean maximize(boolean restart) {
        if (this.objective == null) {
            throw new SolverException("No objective variable defined");
        }
        return this.optimize(true, this.objective, restart);
    }

    protected Boolean optimize(boolean maximize, Var obj, boolean restart) {
        this.setDoMaximize(maximize);
        this.setObjective(obj);
        this.setRestart(restart);
        this.setFirstSolution(false);
        this.generateSearchStrategy();
        this.launch();
        return this.feasible;
    }

    @Deprecated
    public void setMinimizationObjective(IntVar obj) {
        this.objective = obj;
        this.configuration.putEnum("cp.resolution.policy", ResolutionPolicy.MINIMIZE);
    }

    @Deprecated
    public void setMaximizationObjective(IntVar obj) {
        this.objective = obj;
        this.configuration.putEnum("cp.resolution.policy", ResolutionPolicy.MAXIMIZE);
    }

    @Deprecated
    public boolean useRecomputation() {
        return this.configuration.readInt("cp.recomputation.gap") > 1;
    }

    @Deprecated
    public void setRecomputation(boolean on) {
        this.configuration.putInt("cp.recomputation.gap", on ? 10 : 1);
    }

    @Deprecated
    public final int getRecomputationGap() {
        return this.configuration.readInt("cp.recomputation.gap");
    }

    @Deprecated
    public void setRecomputationGap(int aRecomputationGap) {
        this.configuration.putInt("cp.recomputation.gap", aRecomputationGap);
    }

    @Override
    public final <MV extends Variable, SV extends Var> SV _to(MV mv, SV sv) {
        sv = this.mapvariables.get(mv.getIndex());
        return sv;
    }

    @Override
    public final <MV extends Variable, SV extends Var> SV[] _to(MV[] mv, SV[] sv) {
        for (int i = 0; i < mv.length; ++i) {
            sv[i] = this.mapvariables.get(mv[i].getIndex());
        }
        return sv;
    }

    @Override
    public final <MV extends Variable, SV extends Var> SV getVar(MV v) {
        return (SV)this.mapvariables.get(v.getIndex());
    }

    @Override
    public final <MV extends Variable, SV extends Var> SV[] getVar(Class<SV> clazz, MV[] mv) {
        Var[] svs = (Var[])Array.newInstance(clazz, mv.length);
        for (int i = 0; i < mv.length; ++i) {
            svs[i] = this.mapvariables.get(mv[i].getIndex());
        }
        return svs;
    }

    @Override
    public final IntDomainVar getVar(IntegerVariable v) {
        return (IntDomainVar)this.mapvariables.get(v.getIndex());
    }

    @Override
    public final IntDomainVar[] getVar(IntegerVariable ... v) {
        IntDomainVar[] vs = new IntDomainVar[v.length];
        return this._to((Variable)v, (Var)vs);
    }

    @Override
    public final RealVar getVar(RealVariable v) {
        return (RealVar)this.mapvariables.get(v.getIndex());
    }

    @Override
    public final RealVar[] getVar(RealVariable ... v) {
        RealVar[] vs = new RealVar[v.length];
        return this._to((Variable)v, (Var)vs);
    }

    @Override
    public final SetVar getVar(SetVariable v) {
        return (SetVar)this.mapvariables.get(v.getIndex());
    }

    @Override
    public final SetVar[] getVar(SetVariable ... v) {
        SetVar[] vs = new SetVar[v.length];
        return this._to((Variable)v, (Var)vs);
    }

    @Override
    public final TaskVar getVar(TaskVariable v) {
        return (TaskVar)this.mapvariables.get(v.getIndex());
    }

    @Override
    public final TaskVar[] getVar(TaskVariable ... v) {
        TaskVar[] vs = new TaskVar[v.length];
        return this._to((Variable)v, (Var)vs);
    }

    @Override
    public final SConstraint getCstr(Constraint ic) {
        return this.mapconstraints.get(ic.getIndex());
    }

    @Override
    @Deprecated
    public final void setCardReasoning(boolean creas) {
        this.configuration.putBoolean("cp.propagation.cardinality_reasonning", creas);
    }

    @Override
    public Solution recordSolution() {
        Solution sol = new Solution(this);
        this.strategy.writeSolution(sol);
        return sol;
    }

    @Override
    public void restoreSolution(Solution sol) {
        try {
            int i;
            int nbv = this.getNbIntVars();
            for (i = 0; i < nbv; ++i) {
                if (sol.getIntValue(i) == Integer.MAX_VALUE) continue;
                this.getIntVarQuick(i).setVal(sol.getIntValue(i));
            }
            nbv = this.getNbSetVars();
            for (i = 0; i < nbv; ++i) {
                this.getSetVarQuick(i).setVal(sol.getSetValue(i));
            }
            nbv = this.getNbRealVars();
            for (i = 0; i < nbv; ++i) {
                this.getRealVarQuick(i).intersect(sol.getRealValue(i));
            }
        }
        catch (ContradictionException e) {
            LOGGER.severe("BUG in restoring solution !!");
            throw new SolverException("Restored solution not consistent !!");
        }
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Deprecated
    public static void setVerbosity(int verbosity) {
        switch (verbosity) {
            case 1: {
                ChocoLogging.setVerbosity(Verbosity.SOLUTION);
                break;
            }
            case 2: {
                ChocoLogging.setVerbosity(Verbosity.SEARCH);
                break;
            }
            case 3: {
                ChocoLogging.setVerbosity(Verbosity.FINEST);
                break;
            }
            case 4: {
                ChocoLogging.setVerbosity(Verbosity.FINEST);
                break;
            }
            case 0: {
                ChocoLogging.setVerbosity(Verbosity.SILENT);
                break;
            }
            default: {
                ChocoLogging.setVerbosity(Verbosity.SILENT);
            }
        }
    }

    @Deprecated
    public static void flushLogs() {
        ChocoLogging.flushLogs();
    }

    @Override
    public IntDomainVar createIntVar(String name, int domainType, int min, int max) {
        IntDomainVarImpl v = new IntDomainVarImpl(this, name, domainType, min, max);
        this.intVars.add(v);
        return v;
    }

    @Override
    public IntDomainVar createBooleanVar(String name) {
        BooleanVarImpl v = new BooleanVarImpl(this, name);
        this.intVars.add(v);
        this.intDecisionVars.add(v);
        return v;
    }

    public IntDomainVar createNotBooleanVar(String name, IntDomainVar variable) {
        BoolVarNot v = new BoolVarNot((Solver)this, name, (BooleanVarImpl)variable);
        this.intVars.add(v);
        this.intDecisionVars.add(v);
        return v;
    }

    @Override
    public IntDomainVar createBoundIntVar(String name, int min, int max) {
        IntDomainVarImpl v = new IntDomainVarImpl(this, name, 1, min, max);
        this.intVars.add(v);
        this.intDecisionVars.add(v);
        return v;
    }

    @Override
    public IntDomainVar createEnumIntVar(String name, int min, int max) {
        IntDomainVarImpl v = new IntDomainVarImpl(this, name, 0, min, max);
        this.intVars.add(v);
        this.intDecisionVars.add(v);
        return v;
    }

    @Override
    public IntDomainVar createEnumIntVar(String name, int[] sortedValues) {
        IntDomainVarImpl v = new IntDomainVarImpl(this, name, 0, sortedValues);
        this.intVars.add(v);
        this.intDecisionVars.add(v);
        return v;
    }

    public IntDomainVar createIntVarAddCste(String name, IntDomainVar variable, int constant) {
        IntDomainVarAddCste v = new IntDomainVarAddCste(this, name, variable, constant);
        this.intVars.add(v);
        this.intDecisionVars.add(v);
        return v;
    }

    public IntDomainVar createIntVarTimeCste(String name, IntDomainVar variable, int constant) {
        IntDomainVarTimePosCste v = new IntDomainVarTimePosCste(this, name, variable, constant);
        this.intVars.add(v);
        this.intDecisionVars.add(v);
        return v;
    }

    @Override
    public IntDomainVar createBinTreeIntVar(String name, int min, int max) {
        IntDomainVarImpl v = new IntDomainVarImpl(this, name, 3, min, max);
        this.intVars.add(v);
        this.intDecisionVars.add(v);
        return v;
    }

    @Override
    public IntDomainVar createBinTreeIntVar(String name, int[] sortedValues) {
        IntDomainVarImpl v = new IntDomainVarImpl(this, name, 3, sortedValues);
        this.intVars.add(v);
        this.intDecisionVars.add(v);
        return v;
    }

    public IntDomainVar createListIntVar(String name, int min, int max) {
        IntDomainVarImpl v = new IntDomainVarImpl(this, name, 2, min, max);
        this.intVars.add(v);
        this.intDecisionVars.add(v);
        return v;
    }

    public IntDomainVar createListIntVar(String name, int[] sortedValues) {
        IntDomainVarImpl v = new IntDomainVarImpl(this, name, 2, sortedValues);
        this.intVars.add(v);
        this.intDecisionVars.add(v);
        return v;
    }

    @Override
    public RealVar createRealVal(String name, double min, double max) {
        RealVarImpl v = new RealVarImpl(this, name, min, max, 0);
        this.floatVars.add(v);
        this.floatDecisionVars.add(v);
        return v;
    }

    @Override
    public RealIntervalConstant createRealIntervalConstant(double a, double b) {
        return new RealIntervalConstant(a, b);
    }

    @Override
    public RealIntervalConstant cst(double d) {
        return this.createRealIntervalConstant(d, d);
    }

    @Override
    public RealIntervalConstant cst(double a, double b) {
        return this.createRealIntervalConstant(a, b);
    }

    public SetVar createSetVar(String name, int a, int b, IntDomainVar card) {
        SetVarImpl s = new SetVarImpl((Solver)this, name, a, b, card);
        this.setVars.add(s);
        this.setDecisionVars.add(s);
        this.post((SConstraint)new SetCard(s, s.getCard(), true, true));
        return s;
    }

    @Override
    public SetVar createSetVar(String name, int a, int b, int type) {
        SetVarImpl s = new SetVarImpl(this, name, a, b, null, type);
        this.setVars.add(s);
        this.setDecisionVars.add(s);
        this.intVars.add(s.getCard());
        this.intDecisionVars.add(s.getCard());
        this.post((SConstraint)new SetCard(s, s.getCard(), true, true));
        return s;
    }

    @Override
    public SetVar createBoundSetVar(String name, int a, int b) {
        return this.createSetVar(name, a, b, 0);
    }

    @Override
    public SetVar createEnumSetVar(String name, int a, int b) {
        return this.createSetVar(name, a, b, 1);
    }

    @Override
    public TaskVar createTaskVar(String name, IntDomainVar start, IntDomainVar end, IntDomainVar duration) {
        TaskVar t = new TaskVar(this, this.getNbTaskVars(), name, start, end, duration);
        this.taskVars.add(t);
        return t;
    }

    @Override
    public IntDomainVar createIntegerConstant(String name, int val) {
        if (this.intconstantVars.containsKey(val)) {
            return this.intconstantVars.get(val);
        }
        IntDomainVar v = this.createIntVar(name, 1, val, val);
        this.intconstantVars.put(val, v);
        return v;
    }

    @Override
    public RealIntervalConstant createRealConstant(String name, double val) {
        if (this.realconstantVars.containsKey(val)) {
            return this.realconstantVars.get(val);
        }
        RealIntervalConstant v = this.createRealIntervalConstant(val, val);
        this.realconstantVars.put(val, v);
        return v;
    }

    public IntDomainVar makeConstantIntVar(String name, int val) {
        return this.createIntegerConstant(name, val);
    }

    public IntDomainVar makeConstantIntVar(int val) {
        return this.createIntegerConstant("", val);
    }

    private static SConstraint eq(int cste) {
        return cste == 0 ? Constant.TRUE : Constant.FALSE;
    }

    private static SConstraint geq(int cste) {
        return cste <= 0 ? Constant.TRUE : Constant.FALSE;
    }

    private static SConstraint neq(int cste) {
        return cste != 0 ? Constant.TRUE : Constant.FALSE;
    }

    @Override
    public SConstraint eq(IntExp x, IntExp y) {
        if (x instanceof IntVar && y instanceof IntVar) {
            return new EqualXYC((IntDomainVar)x, (IntDomainVar)y, 0);
        }
        if ((x instanceof IntTerm || x instanceof IntVar) && (y instanceof IntTerm || y instanceof IntVar)) {
            return this.eq(CPSolver.minus(x, y), 0);
        }
        if (x == null) {
            return this.eq(y, 0);
        }
        if (y == null) {
            return this.eq(x, 0);
        }
        throw new SolverException("IntExp not a good exp");
    }

    protected static SConstraint eq(int c0, IntDomainVar v0, int cste) {
        if (c0 == 0) {
            return CPSolver.eq(cste);
        }
        if (cste % c0 == 0) {
            return new EqualXC(v0, cste / c0);
        }
        return Constant.FALSE;
    }

    protected static SConstraint eq(int c0, IntDomainVar v0, int c1, IntDomainVar v1, int cste) {
        assert (c0 != 0 && c1 != 0);
        if (c0 == -c1 && cste % c0 == 0) {
            return new EqualXYC(v0, v1, cste / c0);
        }
        if (c0 == c1) {
            return cste % c0 == 0 ? new EqualXY_C(v0, v1, cste / c0) : Constant.FALSE;
        }
        return null;
    }

    @Override
    public SConstraint eq(IntExp x, int c) {
        if (x instanceof IntTerm) {
            SConstraint cstr;
            IntTerm t = (IntTerm)x;
            int cste = c - t.getConstant();
            if (t.isConstant()) {
                return CPSolver.eq(cste);
            }
            if (t.isUnary()) {
                return CPSolver.eq(t.getCoefficient(0), t.getIntDVar(0), cste);
            }
            if (t.isBinary() && (cstr = CPSolver.eq(t.getCoefficient(0), t.getIntDVar(0), t.getCoefficient(1), t.getIntDVar(1), cste)) != null) {
                return cstr;
            }
            return IntLinCombFactory.makeIntLinComb(t, -cste, 0, this);
        }
        if (x instanceof IntDomainVar) {
            return new EqualXC((IntDomainVar)x, c);
        }
        if (x == null) {
            return CPSolver.eq(c);
        }
        throw new SolverException("IntExp " + x + ":not a term, not a var");
    }

    @Override
    public SConstraint eq(int c, IntExp x) {
        return this.eq(x, c);
    }

    @Override
    public SConstraint eq(RealVar r, IntDomainVar i) {
        return new MixedEqXY(r, i);
    }

    public SConstraint eqCard(SetVar s, IntDomainVar i) {
        return this.eq((IntExp)s.getCard(), (IntExp)i);
    }

    public SConstraint eqCard(SetVar s, int i) {
        return this.eq((IntExp)s.getCard(), i);
    }

    @Override
    public SConstraint geq(IntExp x, IntExp y) {
        if (x instanceof IntVar && y instanceof IntVar) {
            return new GreaterOrEqualXYC((IntDomainVar)x, (IntDomainVar)y, 0);
        }
        if ((x instanceof IntTerm || x instanceof IntVar) && (y instanceof IntTerm || y instanceof IntVar)) {
            return this.geq(CPSolver.minus(x, y), 0);
        }
        if (y == null) {
            return this.geq(x, 0);
        }
        if (x == null) {
            return this.geq(0, y);
        }
        throw new SolverException("IntExp not a good exp");
    }

    protected static SConstraint geq(int c0, IntDomainVar v0, int c1, IntDomainVar v1, int cste) {
        if (c0 == -c1 && cste % c0 == 0) {
            if (c0 > 0) {
                return new GreaterOrEqualXYC(v0, v1, cste / c0);
            }
            assert (c0 < 0);
            return new GreaterOrEqualXYC(v1, v0, cste / c1);
        }
        if (c0 == c1) {
            if (c0 > 0) {
                return new GreaterOrEqualXY_C(v0, v1, MathUtils.divCeil(cste, c0));
            }
            assert (c0 < 0);
            return new LessOrEqualXY_C(v0, v1, MathUtils.divFloor(cste, c0));
        }
        return null;
    }

    protected static SConstraint geq(int c0, IntDomainVar v0, int cste) {
        if (c0 > 0) {
            return new GreaterOrEqualXC(v0, MathUtils.divCeil(cste, c0));
        }
        if (c0 < 0) {
            return new LessOrEqualXC(v0, MathUtils.divFloor(cste, c0));
        }
        assert (c0 == 0);
        return CPSolver.geq(cste);
    }

    @Override
    public SConstraint geq(IntExp x, int c) {
        if (x instanceof IntTerm) {
            SConstraint cstr;
            IntTerm t = (IntTerm)x;
            int cste = c - t.getConstant();
            if (t.isConstant()) {
                return CPSolver.geq(cste);
            }
            if (t.isUnary()) {
                return CPSolver.geq(t.getCoefficient(0), t.getIntDVar(0), cste);
            }
            if (t.isBinary() && (cstr = CPSolver.geq(t.getCoefficient(0), t.getIntDVar(0), t.getCoefficient(1), t.getIntDVar(1), cste)) != null) {
                return cstr;
            }
            return IntLinCombFactory.makeIntLinComb(t, -cste, 1, this);
        }
        if (x instanceof IntDomainVar) {
            return new GreaterOrEqualXC((IntDomainVar)x, c);
        }
        if (x == null) {
            return CPSolver.geq(c);
        }
        throw new SolverException("IntExp not a term, not a var");
    }

    @Override
    public SConstraint geq(int c, IntExp x) {
        if (x instanceof IntTerm) {
            return this.geq((IntExp)IntTerm.opposite((IntTerm)x), -c);
        }
        if (x instanceof IntVar) {
            return new LessOrEqualXC((IntDomainVar)x, c);
        }
        if (x == null) {
            return CPSolver.geq(c);
        }
        throw new SolverException("IntExp not a term, not a var");
    }

    public SConstraint geqCard(SetVar sv, IntDomainVar v) {
        return this.geq((IntExp)sv.getCard(), (IntExp)v);
    }

    public SConstraint geqCard(SetVar sv, int v) {
        return this.geq((IntExp)sv.getCard(), v);
    }

    @Override
    public SConstraint gt(IntExp x, IntExp y) {
        return this.geq(CPSolver.minus(x, y), 1);
    }

    @Override
    public SConstraint gt(IntExp x, int c) {
        return this.geq(x, c + 1);
    }

    @Override
    public SConstraint gt(int c, IntExp x) {
        return this.geq(c - 1, x);
    }

    @Override
    public SConstraint leq(IntExp v1, IntExp v2) {
        return this.geq(v2, v1);
    }

    @Override
    public SConstraint leq(IntExp v1, int v2) {
        return this.geq(v2, v1);
    }

    @Override
    public SConstraint leq(int v1, IntExp v2) {
        return this.geq(v2, v1);
    }

    public SConstraint leqCard(SetVar sv, IntDomainVar i) {
        return this.leq((IntExp)sv.getCard(), (IntExp)i);
    }

    public SConstraint leqCard(SetVar sv, int i) {
        return this.leq((IntExp)sv.getCard(), i);
    }

    @Override
    public SConstraint lt(IntExp v1, IntExp v2) {
        return this.gt(v2, v1);
    }

    @Override
    public SConstraint lt(IntExp v1, int v2) {
        return this.gt(v2, v1);
    }

    @Override
    public SConstraint lt(int v1, IntExp v2) {
        return this.gt(v2, v1);
    }

    public static IntExp minus(IntExp v1, IntExp v2) {
        if (v1 == IntTerm.ZERO) {
            return CPSolver.mult(-1, v2);
        }
        if (v2 == IntTerm.ZERO) {
            return v1;
        }
        if (v1 instanceof IntTerm) {
            IntTerm t1 = (IntTerm)v1;
            if (v2 instanceof IntTerm) {
                return IntTerm.minus(t1, (IntTerm)v2);
            }
            if (v2 instanceof IntVar) {
                return IntTerm.plus(t1, -1, (IntVar)v2, false);
            }
            throw new SolverException("IntExp not a term, not a var");
        }
        if (v1 instanceof IntVar) {
            if (v2 instanceof IntTerm) {
                return IntTerm.minus(1, (IntVar)v1, (IntTerm)v2);
            }
            if (v2 instanceof IntVar) {
                IntTerm t = new IntTerm(2);
                t.setCoefficient(0, 1);
                t.setCoefficient(1, -1);
                t.setVariable(0, (IntVar)v1);
                t.setVariable(1, (IntVar)v2);
                t.setConstant(0);
                return t;
            }
            throw new SolverException("IntExp not a term, not a var");
        }
        throw new SolverException("IntExp not a term, not a var");
    }

    public static IntExp minus(IntExp t, int c) {
        if (t == IntTerm.ZERO) {
            IntTerm t2 = new IntTerm(0);
            t2.setConstant(-c);
            return t2;
        }
        if (t instanceof IntTerm) {
            IntTerm t2 = new IntTerm((IntTerm)t);
            t2.setConstant(((IntTerm)t).getConstant() - c);
            return t2;
        }
        if (t instanceof IntVar) {
            IntTerm t2 = new IntTerm(1);
            t2.setCoefficient(0, 1);
            t2.setVariable(0, (IntVar)t);
            t2.setConstant(-c);
            return t2;
        }
        throw new SolverException("IntExp not a term, not a var");
    }

    public static IntExp minus(int c, IntExp t) {
        if (t instanceof IntTerm) {
            IntTerm t1 = (IntTerm)t;
            int n = t1.getSize();
            IntTerm t2 = new IntTerm(n);
            for (int i = 0; i < n; ++i) {
                t2.setCoefficient(i, -t1.getCoefficient(i));
                t2.setVariable(i, t1.getVariable(i));
            }
            t2.setConstant(c - t1.getConstant());
            return t2;
        }
        if (t instanceof IntVar) {
            IntTerm t2 = new IntTerm(1);
            t2.setCoefficient(0, -1);
            t2.setVariable(0, (IntVar)t);
            t2.setConstant(c);
            return t2;
        }
        throw new SolverException("IntExp not a term, not a var");
    }

    @Override
    public IntExp plus(IntExp v1, IntExp v2) {
        if (v1 == IntTerm.ZERO) {
            return v2;
        }
        if (v2 == IntTerm.ZERO) {
            return v1;
        }
        if (v1 instanceof IntTerm) {
            IntTerm t1 = (IntTerm)v1;
            if (v2 instanceof IntTerm) {
                return IntTerm.plus(t1, (IntTerm)v2);
            }
            if (v2 instanceof IntVar) {
                return IntTerm.plus(t1, 1, (IntVar)v2, false);
            }
            throw new SolverException("IntExp not a term, not a var");
        }
        if (v1 instanceof IntVar) {
            if (v2 instanceof IntTerm) {
                return IntTerm.plus((IntTerm)v2, 1, (IntVar)v1, true);
            }
            if (v2 instanceof IntVar) {
                IntTerm t = new IntTerm(2);
                t.setCoefficient(0, 1);
                t.setCoefficient(1, 1);
                t.setVariable(0, (IntVar)v1);
                t.setVariable(1, (IntVar)v2);
                t.setConstant(0);
                return t;
            }
            throw new SolverException("IntExp not a term, not a var");
        }
        throw new SolverException("IntExp not a term, not a var");
    }

    @Override
    public IntExp plus(IntExp t, int c) {
        if (t == IntTerm.ZERO) {
            IntTerm t2 = new IntTerm(0);
            t2.setConstant(c);
            return t2;
        }
        if (t instanceof IntTerm) {
            IntTerm t2 = new IntTerm((IntTerm)t);
            t2.setConstant(((IntTerm)t).getConstant() + c);
            return t2;
        }
        if (t instanceof IntVar) {
            IntTerm t2 = new IntTerm(1);
            t2.setCoefficient(0, 1);
            t2.setVariable(0, (IntVar)t);
            t2.setConstant(c);
            return t2;
        }
        throw new SolverException("IntExp not a term, not a var");
    }

    @Override
    public IntExp plus(int c, IntExp t1) {
        return this.plus(t1, c);
    }

    protected static IntExp plus(int[] coeffs1, IntVar[] vars1, int cste1, int[] coeffs2, IntVar[] vars2, int cste2) {
        int i;
        int n1 = vars1.length;
        int n2 = vars2.length;
        IntTerm t = new IntTerm(n1 + n2);
        for (i = 0; i < n1; ++i) {
            t.setVariable(i, vars1[i]);
            t.setCoefficient(i, coeffs1[i]);
        }
        for (i = 0; i < n2; ++i) {
            t.setVariable(n1 + i, vars2[i]);
            t.setCoefficient(n1 + i, coeffs2[i]);
        }
        t.setConstant(cste1 + cste2);
        return t;
    }

    public static IntExp mult(int a, IntExp x) {
        if (a != 0 && x != IntTerm.ZERO) {
            IntTerm t = new IntTerm(1);
            t.setCoefficient(0, a);
            t.setVariable(0, (IntVar)x);
            return t;
        }
        return IntTerm.ZERO;
    }

    protected static SConstraint neq(int c0, IntDomainVar v0, int c1, IntDomainVar v1, int cste) {
        assert (c0 != 0 && c1 != 0);
        if (c0 == -c1 && cste % c0 == 0) {
            return new NotEqualXYC(v0, v1, cste / c0);
        }
        if (c0 == c1) {
            return cste % c0 == 0 ? new NotEqualXY_C(v0, v1, cste / c0) : Constant.TRUE;
        }
        return null;
    }

    protected static SConstraint neq(int c0, IntDomainVar v0, int cste) {
        if (c0 == 0) {
            return CPSolver.neq(cste);
        }
        if (cste % c0 == 0) {
            return new NotEqualXC(v0, cste / c0);
        }
        return Constant.TRUE;
    }

    @Override
    public SConstraint neq(IntExp x, int c) {
        if (x instanceof IntTerm) {
            SConstraint cstr;
            IntTerm t = (IntTerm)x;
            int cste = c - t.getConstant();
            if (t.isConstant()) {
                return CPSolver.neq(cste);
            }
            if (t.isUnary()) {
                return CPSolver.neq(t.getCoefficient(0), t.getIntDVar(0), cste);
            }
            if (t.isBinary() && (cstr = CPSolver.neq(t.getCoefficient(0), t.getIntDVar(0), t.getCoefficient(1), t.getIntDVar(1), cste)) != null) {
                return cstr;
            }
            return IntLinCombFactory.makeIntLinComb(t, -cste, 2, this);
        }
        if (x instanceof IntVar) {
            return new NotEqualXC((IntDomainVar)x, c);
        }
        if (x == null) {
            return CPSolver.neq(c);
        }
        throw new SolverException("IntExp not a term, not a var");
    }

    @Override
    public SConstraint neq(int c, IntExp x) {
        return this.neq(x, c);
    }

    @Override
    public SConstraint neq(IntExp x, IntExp y) {
        if (x instanceof IntTerm) {
            return this.neq(CPSolver.minus(x, y), 0);
        }
        if (x instanceof IntVar) {
            if (y instanceof IntTerm) {
                return this.neq(CPSolver.minus(x, y), 0);
            }
            if (y instanceof IntVar) {
                return new NotEqualXYC((IntDomainVar)x, (IntDomainVar)y, 0);
            }
            if (y == null) {
                return this.neq(x, 0);
            }
            throw new SolverException("IntExp not a term, not a var");
        }
        if (x == null) {
            return this.neq(0, y);
        }
        throw new SolverException("IntExp not a term, not a var");
    }

    public static SConstraint eq(SetVar s1, SetVar s2) {
        return new SetEq(s1, s2);
    }

    public static SConstraint neq(SetVar s1, SetVar s2) {
        return new SetNotEq(s1, s2);
    }

    public SConstraint occurence(IntDomainVar[] vars, IntDomainVar occ, int value) {
        IntDomainVar[] tmpvars = new IntDomainVar[vars.length + 1];
        System.arraycopy(vars, 0, tmpvars, 0, vars.length);
        tmpvars[tmpvars.length - 1] = occ;
        return new Occurrence(tmpvars, value, true, true, this.environment);
    }

    public SConstraint preceding(TaskVar t1, int k1, TaskVar t2) {
        return this.leq(t1.duration().isInstantiated() ? this.plus((IntExp)t1.start(), t1.duration().getVal() + k1) : this.plus((IntExp)t1.end(), k1), (IntExp)t2.start());
    }

    public SConstraint preceding(IntDomainVar direction, TaskVar t1, TaskVar t2) {
        return this.preceding(direction, t1, 0, t2, 0);
    }

    public SConstraint preceding(IntDomainVar direction, TaskVar t1, int k1, TaskVar t2, int k2) {
        if (direction == null) {
            direction = VariableUtils.createDirVar(this, t1, t2);
        } else if (!direction.hasBooleanDomain()) {
            throw new SolverException("The direction variable " + direction.pretty() + "is not a boolean variable for the precedence (" + t1 + ',' + t2 + ')');
        }
        if (direction.isInstantiatedTo(1)) {
            return this.preceding(t1, k1, t2);
        }
        if (direction.isInstantiatedTo(0)) {
            return this.preceding(t2, k2, t1);
        }
        if (t1.duration().isInstantiated() && t2.duration().isInstantiated()) {
            return new PrecedenceDisjoint(t1, t1.duration().getVal() + k1, t2, t2.duration().getVal() + k2, direction);
        }
        if (k1 != 0 || k2 != 0) {
            return new PrecedenceVSDisjoint(direction, t1, k1, t2, k2);
        }
        return new PrecedenceVDisjoint(direction, t1, t2);
    }

    public SConstraint makeEquation(RealExp exp, RealIntervalConstant cst) {
        HashSet<RealVar> collectedVars = new HashSet<RealVar>(16);
        exp.collectVars(collectedVars);
        RealVar[] tmpVars = new RealVar[]{};
        tmpVars = collectedVars.toArray(tmpVars);
        return this.createEquation(tmpVars, exp, cst);
    }

    public SConstraint eq(RealExp exp1, RealExp exp2) {
        if (exp1 instanceof RealIntervalConstant) {
            return this.makeEquation(exp2, (RealIntervalConstant)exp1);
        }
        if (exp2 instanceof RealIntervalConstant) {
            return this.makeEquation(exp1, (RealIntervalConstant)exp2);
        }
        return this.makeEquation(this.minus(exp1, exp2), this.cst(0.0));
    }

    public SConstraint eq(RealExp exp, double cst) {
        return this.makeEquation(exp, this.cst(cst));
    }

    public SConstraint eq(double cst, RealExp exp) {
        return this.makeEquation(exp, this.cst(cst));
    }

    public SConstraint leq(RealExp exp1, RealExp exp2) {
        if (exp1 instanceof RealIntervalConstant) {
            return this.makeEquation(exp2, this.cst(exp1.getInf(), Double.POSITIVE_INFINITY));
        }
        if (exp2 instanceof RealIntervalConstant) {
            return this.makeEquation(exp1, this.cst(Double.NEGATIVE_INFINITY, exp2.getSup()));
        }
        return this.makeEquation(this.minus(exp1, exp2), this.cst(Double.NEGATIVE_INFINITY, 0.0));
    }

    public SConstraint leq(RealExp exp, double cst) {
        return this.makeEquation(exp, this.cst(Double.NEGATIVE_INFINITY, cst));
    }

    public SConstraint leq(double cst, RealExp exp) {
        return this.makeEquation(exp, this.cst(cst, Double.POSITIVE_INFINITY));
    }

    public SConstraint geq(RealExp exp1, RealExp exp2) {
        return this.leq(exp2, exp1);
    }

    public SConstraint geq(RealExp exp, double cst) {
        return this.leq(cst, exp);
    }

    public SConstraint geq(double cst, RealExp exp) {
        return this.leq(exp, cst);
    }

    public RealExp plus(RealExp exp1, RealExp exp2) {
        return this.createRealPlus(exp1, exp2);
    }

    public RealExp minus(RealExp exp1, RealExp exp2) {
        return this.createRealMinus(exp1, exp2);
    }

    public RealExp mult(RealExp exp1, RealExp exp2) {
        return this.createRealMult(exp1, exp2);
    }

    public RealExp power(RealExp exp, int power) {
        return this.createRealIntegerPower(exp, power);
    }

    public RealExp cos(RealExp exp) {
        return this.createRealCos(exp);
    }

    public RealExp sin(RealExp exp) {
        return this.createRealSin(exp);
    }

    public RealIntervalConstant around(double d) {
        return this.cst(RealMath.prevFloat(d), RealMath.nextFloat(d));
    }

    protected RealExp createRealSin(RealExp exp) {
        return new RealSin(this, exp);
    }

    protected RealExp createRealCos(RealExp exp) {
        return new RealCos(this, exp);
    }

    protected RealExp createRealPlus(RealExp exp1, RealExp exp2) {
        return new RealPlus(this, exp1, exp2);
    }

    protected RealExp createRealMinus(RealExp exp1, RealExp exp2) {
        return new RealMinus(this, exp1, exp2);
    }

    protected RealExp createRealMult(RealExp exp1, RealExp exp2) {
        return new RealMult(this, exp1, exp2);
    }

    protected RealExp createRealIntegerPower(RealExp exp, int power) {
        return new RealIntegerPower(this, exp, power);
    }

    protected SConstraint createEquation(RealVar[] tmpVars, RealExp exp, RealIntervalConstant cst) {
        return new Equation(this, tmpVars, exp, cst);
    }

    @Override
    public IntExp scalar(int[] lc, IntDomainVar[] lv) {
        int nbNonNullCoeffs = 0;
        for (int i = 0; i < lc.length; ++i) {
            if (lc[i] == 0) continue;
            ++nbNonNullCoeffs;
        }
        if (nbNonNullCoeffs == 0) {
            return IntTerm.ZERO;
        }
        if (nbNonNullCoeffs == lc.length) {
            return new IntTerm(lc, lv);
        }
        IntTerm res = new IntTerm(nbNonNullCoeffs);
        int idx = 0;
        for (int i = 0; i < lc.length; ++i) {
            if (lc[i] == 0) continue;
            res.setCoefficient(idx, lc[i]);
            res.setVariable(idx, lv[i]);
            ++idx;
        }
        return res;
    }

    @Override
    public IntExp scalar(IntDomainVar[] lv, int[] lc) {
        return this.scalar(lc, lv);
    }

    public static IntExp sum(IntVar ... lv) {
        return new IntTerm(lv);
    }

    @Override
    public IntExp sum(IntExp ... lv) {
        int n = lv.length;
        IntTerm t = new IntTerm(n);
        for (int i = 0; i < n; ++i) {
            t.setCoefficient(i, 1);
            if (!(lv[i] instanceof IntVar)) {
                throw new SolverException("unexpected kind of IntExp");
            }
            t.setVariable(i, (IntVar)lv[i]);
        }
        return t;
    }

    public SConstraint feasiblePairAC(IntDomainVar v1, IntDomainVar v2, boolean[][] mat, int ac) {
        return this.makePairAC(v1, v2, mat, true, ac);
    }

    public SConstraint feasiblePairAC(IntDomainVar v1, IntDomainVar v2, List<int[]> mat, int ac) {
        return this.makePairAC(v1, v2, mat, true, ac);
    }

    public SConstraint infeasiblePairAC(IntDomainVar v1, IntDomainVar v2, boolean[][] mat, int ac) {
        return this.makePairAC(v1, v2, mat, false, ac);
    }

    public SConstraint infeasiblePairAC(IntDomainVar v1, IntDomainVar v2, List<int[]> mat, int ac) {
        return this.makePairAC(v1, v2, mat, false, ac);
    }

    @Override
    public BinRelation makeBinRelation(int[] min, int[] max, List<int[]> mat, boolean feas, boolean bitset) {
        int n1 = max[0] - min[0] + 1;
        int n2 = max[1] - min[1] + 1;
        ConsistencyRelation relation = bitset ? new CouplesBitSetTable(feas, min[0], min[1], n1, n2) : new CouplesTable(feas, min[0], min[1], n1, n2);
        for (int[] couple : mat) {
            if (couple.length != 2) {
                throw new SolverException("Wrong dimension : " + couple.length + " for a couple");
            }
            relation.setCouple(couple[0], couple[1]);
        }
        return relation;
    }

    @Override
    public BinRelation makeBinRelation(int[] min, int[] max, List<int[]> mat, boolean feas) {
        return this.makeBinRelation(min, max, mat, feas, false);
    }

    public static BinRelation makeBinRelation(IntDomainVar v1, IntDomainVar v2, boolean[][] mat, boolean feas, boolean bitset) {
        int n1 = v1.getSup() - v1.getInf() + 1;
        int n2 = v2.getSup() - v2.getInf() + 1;
        if (n1 == mat.length && n2 == mat[0].length) {
            ExtensionalBinRelation relation = (ExtensionalBinRelation)((Object)(bitset ? new CouplesBitSetTable(feas, v1.getInf(), v2.getInf(), n1, n2) : new CouplesTable(feas, v1.getInf(), v2.getInf(), n1, n2)));
            for (int i = 0; i < n1; ++i) {
                for (int j = 0; j < n2; ++j) {
                    if (!mat[i][j]) continue;
                    relation.setCouple(i + v1.getInf(), j + v2.getInf());
                }
            }
            return relation;
        }
        throw new SolverException("Wrong dimension for the matrix of consistency : " + mat.length + " X " + mat[0].length + " instead of " + n1 + 'X' + n2);
    }

    public static BinRelation makeBinRelation(IntDomainVar v1, IntDomainVar v2, boolean[][] mat, boolean feas) {
        return CPSolver.makeBinRelation(v1, v2, mat, feas, false);
    }

    private SConstraint makePairAC(IntDomainVar x, IntDomainVar y, List<int[]> mat, boolean feas, int ac) {
        int[] min = new int[]{x.getInf(), y.getInf()};
        int[] max = new int[]{x.getSup(), y.getSup()};
        BinRelation relation = this.makeBinRelation(min, max, mat, feas, ac == 322);
        return this.relationPairAC(x, y, relation, ac);
    }

    public SConstraint makeTupleAC(IntDomainVar[] vs, List<int[]> tuples, boolean feas) {
        int[] min = new int[vs.length];
        int[] max = new int[vs.length];
        for (int i = 0; i < vs.length; ++i) {
            min[i] = vs[i].getInf();
            max[i] = vs[i].getSup();
        }
        LargeRelation relation = this.makeLargeRelation(min, max, tuples, feas);
        return this.relationTupleAC(vs, relation);
    }

    private SConstraint makePairAC(IntDomainVar v1, IntDomainVar v2, boolean[][] mat, boolean feas, int ac) {
        BinRelation relation = CPSolver.makeBinRelation(v1, v2, mat, feas, ac == 322);
        return this.relationPairAC(v1, v2, relation, ac);
    }

    public SConstraint feasibleTupleAC(IntDomainVar[] vars, List<int[]> tuples) {
        return this.feasibleTupleAC(vars, tuples, 32);
    }

    public SConstraint infeasibleTupleAC(IntDomainVar[] vars, List<int[]> tuples) {
        return this.infeasibleTupleAC(vars, tuples, 32);
    }

    public SConstraint feasibleTupleAC(IntDomainVar[] vars, List<int[]> tuples, int ac) {
        LargeRelation relation = this.makeRelation(vars, tuples, true);
        if (ac == 2001) {
            return new GAC2001PositiveLargeConstraint(this.environment, vars, (IterTuplesTable)relation);
        }
        if (ac == 32) {
            return new GAC3rmPositiveLargeConstraint(vars, (IterTuplesTable)relation);
        }
        throw new SolverException("unknown ac algorithm, must be 32 or 2001");
    }

    public SConstraint infeasibleTupleAC(IntDomainVar[] vars, List<int[]> tuples, int ac) {
        LargeRelation relation = this.makeRelation(vars, tuples, false);
        if (ac == 2001) {
            return new GAC2001PositiveLargeConstraint(this.environment, vars, (IterTuplesTable)relation);
        }
        if (ac == 32) {
            return new GAC3rmPositiveLargeConstraint(vars, (IterTuplesTable)relation);
        }
        throw new SolverException("unknown ac algorithm, must be 32 or 2001");
    }

    public SConstraint relationPairAC(IntDomainVar v1, IntDomainVar v2, BinRelation binR, int ac) {
        if (ac == 3) {
            return new AC3BinSConstraint(v1, v2, binR);
        }
        if (ac == 4) {
            throw new SolverException("ac4 not implemented in choco2");
        }
        if (ac == 2001) {
            return new AC2001BinSConstraint(v1, v2, binR, this.environment);
        }
        if (ac == 32) {
            return new AC3rmBinSConstraint(v1, v2, binR);
        }
        if (ac == 322) {
            return new AC3rmBitBinSConstraint(v1, v2, (CouplesBitSetTable)binR);
        }
        throw new UnsupportedOperationException("Ac " + ac + " algorithm not yet implemented");
    }

    @Deprecated
    public LargeRelation makeRelation(IntVar[] vs, List<int[]> tuples, boolean feas) {
        int[] min = new int[vs.length];
        int[] max = new int[vs.length];
        for (int i = 0; i < vs.length; ++i) {
            min[i] = ((IntDomainVar)vs[i]).getInf();
            max[i] = ((IntDomainVar)vs[i]).getSup();
        }
        return this.makeLargeRelation(min, max, tuples, feas);
    }

    @Override
    public LargeRelation makeLargeRelation(int[] min, int[] max, List<int[]> tuples, boolean feas) {
        return this.makeLargeRelation(min, max, tuples, feas, feas ? 0 : 1);
    }

    @Override
    public LargeRelation makeLargeRelation(int[] min, int[] max, List<int[]> tuples, boolean feas, int scheme) {
        LargeRelation relation;
        int n = min.length;
        int[] offsets = new int[n];
        int[] sizes = new int[n];
        for (int i = 0; i < n; ++i) {
            sizes[i] = max[i] - min[i] + 1;
            offsets[i] = min[i];
        }
        if (scheme == 0) {
            relation = new IterTuplesTable(tuples, offsets, sizes);
        } else if (scheme == 1) {
            relation = new TuplesTable(feas, offsets, sizes);
            for (int[] tuple1 : tuples) {
                if (tuple1.length != n) {
                    throw new SolverException("Wrong dimension : " + tuple1.length + " for a tuple (should be " + n + ')');
                }
                ((TuplesTable)relation).setTuple(tuple1);
            }
        } else {
            relation = new TuplesList(tuples);
        }
        return relation;
    }

    public static SConstraint makeTupleFC(IntDomainVar[] vs, List<int[]> tuples, boolean feas) {
        int n = vs.length;
        int[] offsets = new int[n];
        int[] sizes = new int[n];
        for (int i = 0; i < n; ++i) {
            IntDomainVar vi = vs[i];
            sizes[i] = vi.getSup() - vi.getInf() + 1;
            offsets[i] = vi.getInf();
        }
        TuplesTable relation = new TuplesTable(feas, offsets, sizes);
        for (int[] tuple1 : tuples) {
            if (tuple1.length != n) {
                throw new SolverException("Wrong dimension : " + tuple1.length + " for a tuple (should be " + n + ')');
            }
            relation.setTuple(tuple1);
        }
        return CPSolver.createFCLargeConstraint(vs, relation);
    }

    public static SConstraint feasibleTupleFC(IntDomainVar[] vars, TuplesTable tuples) {
        return new CspLargeSConstraint(vars, tuples);
    }

    public static SConstraint infeasibleTupleFC(IntDomainVar[] vars, TuplesTable tuples) {
        return new CspLargeSConstraint(vars, tuples);
    }

    public static SConstraint infeasTupleFC(IntDomainVar[] vars, List<int[]> tuples) {
        return CPSolver.makeTupleFC(vars, tuples, false);
    }

    public static SConstraint feasTupleFC(IntDomainVar[] vars, List<int[]> tuples) {
        return CPSolver.makeTupleFC(vars, tuples, true);
    }

    public SConstraint infeasTupleAC(IntDomainVar[] vars, List<int[]> tuples) {
        return this.makeTupleAC(vars, tuples, false);
    }

    public SConstraint feasTupleAC(IntDomainVar[] vars, List<int[]> tuples) {
        return this.makeTupleAC(vars, tuples, true);
    }

    public static SConstraint relationTupleFC(IntDomainVar[] vs, LargeRelation rela) {
        return CPSolver.createFCLargeConstraint(vs, rela);
    }

    protected static SConstraint createFCLargeConstraint(IntDomainVar[] vars, LargeRelation relation) {
        IntDomainVar[] tmpVars = new IntDomainVar[vars.length];
        System.arraycopy(vars, 0, tmpVars, 0, vars.length);
        return new CspLargeSConstraint(tmpVars, relation);
    }

    @Override
    public SConstraint relationTupleAC(IntDomainVar[] vs, LargeRelation rela) {
        return this.relationTupleAC(vs, rela, 32);
    }

    @Override
    public SConstraint relationTupleAC(IntDomainVar[] vs, LargeRelation rela, int ac) {
        if (rela instanceof IterLargeRelation) {
            if (ac == 32) {
                return new GAC3rmPositiveLargeConstraint(vs, (IterTuplesTable)rela);
            }
            if (ac == 2001) {
                return new GAC2001PositiveLargeConstraint(this.environment, vs, (IterTuplesTable)rela);
            }
            throw new SolverException("GAC algo unknown, choose between 32 or 2001");
        }
        if (ac == 32) {
            return new GAC3rmLargeConstraint(vs, rela);
        }
        if (ac == 2001) {
            return new GAC2001LargeSConstraint(vs, rela, this.environment);
        }
        if (ac == 2008) {
            return new GACstrPositiveLargeSConstraint(vs, rela, this.environment);
        }
        throw new SolverException("GAC algo unknown, choose between 32, 2001, 2008");
    }

    public SConstraint relationPairAC(IntDomainVar v1, IntDomainVar v2, BinRelation binR) {
        return this.relationPairAC(v1, v2, binR, binR instanceof CouplesBitSetTable ? 322 : 32);
    }

    public SConstraint infeasPairAC(IntDomainVar v1, IntDomainVar v2, List<int[]> mat) {
        return this.makePairAC(v1, v2, mat, false, 322);
    }

    public SConstraint infeasPairAC(IntDomainVar v1, IntDomainVar v2, List<int[]> mat, int ac) {
        return this.makePairAC(v1, v2, mat, false, ac);
    }

    public SConstraint feasPairAC(IntDomainVar v1, IntDomainVar v2, List<int[]> mat) {
        return this.makePairAC(v1, v2, mat, true, 322);
    }

    public SConstraint feasPairAC(IntDomainVar v1, IntDomainVar v2, List<int[]> mat, int ac) {
        return this.makePairAC(v1, v2, mat, true, ac);
    }

    public SConstraint infeasPairAC(IntDomainVar v1, IntDomainVar v2, boolean[][] mat) {
        return this.makePairAC(v1, v2, mat, false, 322);
    }

    public SConstraint infeasPairAC(IntDomainVar v1, IntDomainVar v2, boolean[][] mat, int ac) {
        return this.makePairAC(v1, v2, mat, false, ac);
    }

    public SConstraint feasPairAC(IntDomainVar v1, IntDomainVar v2, boolean[][] mat) {
        return this.makePairAC(v1, v2, mat, true, 322);
    }

    public SConstraint feasPairAC(IntDomainVar v1, IntDomainVar v2, boolean[][] mat, int ac) {
        return this.makePairAC(v1, v2, mat, true, ac);
    }

    public SConstraint reifiedIntConstraint(IntDomainVar binVar, SConstraint c) {
        return ReifiedFactory.builder(binVar, c, this);
    }

    public static SConstraint reifiedIntConstraint(IntDomainVar binVar, SConstraint c, SConstraint opc, Solver solver) {
        return ReifiedFactory.builder(binVar, c, opc, solver);
    }
}

