/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global.automata.fast_costregular;

import choco.cp.solver.constraints.global.automata.fast_costregular.CostRegular;
import choco.kernel.common.util.iterators.DisposableIntIterator;
import choco.kernel.model.constraints.automaton.FA.IAutomaton;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.Solver;
import choco.kernel.solver.constraints.global.automata.fast_costregular.structure.Arc;
import choco.kernel.solver.constraints.global.automata.fast_costregular.structure.Node;
import choco.kernel.solver.constraints.global.automata.fast_costregular.structure.StoredValuedDirectedMultiGraph;
import choco.kernel.solver.variables.integer.IntDomainVar;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntIterator;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashSet;
import org.jgrapht.graph.DirectedMultigraph;

public final class CostKnapSack
extends CostRegular {
    IntDomainVar bVar;
    int[] cost;
    int[] gain;

    private static IntDomainVar[] merge(IntDomainVar[] vars, IntDomainVar bound, IntDomainVar cost) {
        IntDomainVar[] nyv = new IntDomainVar[vars.length + 2];
        System.arraycopy(vars, 0, nyv, 0, vars.length);
        nyv[vars.length] = bound;
        nyv[vars.length + 1] = cost;
        return nyv;
    }

    public CostKnapSack(IntDomainVar[] vars, IntDomainVar bVar, IntDomainVar cVar, int[] cost, int[] gain, Solver solver) {
        super(CostKnapSack.merge(vars, bVar, cVar), (IAutomaton)null, (int[][])null, solver);
        this.bVar = bVar;
        this.cost = cost;
        this.gain = gain;
    }

    @Override
    public void awake() throws ContradictionException {
        this.initGraph();
        this.prefilter();
    }

    public void initGraph() throws ContradictionException {
        Object a;
        int k;
        TIntIterator layerIter;
        int j;
        DisposableIntIterator varIter;
        int i;
        int aid = 0;
        int nid = 0;
        int[] offsets = new int[this.vs.length];
        int[] sizes = new int[this.vs.length];
        int[] starts = new int[this.vs.length];
        int totalSizes = 0;
        starts[0] = 0;
        for (int i2 = 0; i2 < this.vs.length; ++i2) {
            offsets[i2] = this.vs[i2].getInf();
            sizes[i2] = this.vs[i2].getSup() - this.vs[i2].getInf() + 1;
            if (i2 > 0) {
                starts[i2] = sizes[i2 - 1] + starts[i2 - 1];
            }
            totalSizes += sizes[i2];
        }
        int n = this.vs.length;
        DirectedMultigraph<Node, Arc> graph = new DirectedMultigraph<Node, Arc>(new Arc.ArcFacroty());
        ArrayList tmp = new ArrayList(totalSizes);
        for (i = 0; i < totalSizes; ++i) {
            tmp.add(new HashSet());
        }
        ArrayList<TIntHashSet> layer = new ArrayList<TIntHashSet>();
        TIntHashSet[] tmpQ = new TIntHashSet[totalSizes];
        for (i = 0; i <= n; ++i) {
            layer.add(new TIntHashSet());
        }
        ((TIntHashSet)layer.get(0)).add(0);
        for (i = 0; i < n; ++i) {
            varIter = this.vs[i].getDomain().getIterator();
            while (varIter.hasNext()) {
                j = varIter.next();
                layerIter = ((TIntHashSet)layer.get(i)).iterator();
                while (layerIter.hasNext()) {
                    k = layerIter.next();
                    int succ = this.delta(i, j, k);
                    if (succ < 0) continue;
                    ((TIntHashSet)layer.get(i + 1)).add(succ);
                    int idx = starts[i] + j - offsets[i];
                    if (tmpQ[idx] == null) {
                        tmpQ[idx] = new TIntHashSet();
                    }
                    tmpQ[idx].add(k);
                }
            }
            varIter.dispose();
        }
        layerIter = ((TIntHashSet)layer.get(n)).iterator();
        while (layerIter.hasNext()) {
            k = layerIter.next();
            if (this.isAccepting(k)) continue;
            layerIter.remove();
        }
        int nbNodes = this.bVar.getSup() + 1;
        BitSet mark = new BitSet(nbNodes);
        Node[] in = new Node[nbNodes * (n + 1)];
        Node tink = new Node(nbNodes + 1, n + 1, nid++);
        graph.addVertex(tink);
        for (i = n - 1; i >= 0; --i) {
            mark.clear(0, nbNodes);
            varIter = this.vs[i].getDomain().getIterator();
            while (varIter.hasNext()) {
                j = varIter.next();
                int idx = starts[i] + j - offsets[i];
                TIntHashSet l = tmpQ[idx];
                if (l == null) continue;
                TIntIterator qijIter = l.iterator();
                while (qijIter.hasNext()) {
                    k = qijIter.next();
                    int qn = this.delta(i, j, k);
                    if (((TIntHashSet)layer.get(i + 1)).contains(qn)) {
                        Node b;
                        a = in[i * nbNodes + k];
                        if (a == null) {
                            in[i * nbNodes + k] = a = new Node(k, i, nid++);
                            graph.addVertex((Node)a);
                        }
                        if ((b = in[(i + 1) * nbNodes + qn]) == null) {
                            in[(i + 1) * nbNodes + qn] = b = new Node(qn, i + 1, nid++);
                            graph.addVertex(b);
                        }
                        Arc arc = new Arc((Node)a, b, j, aid++, this.getCost(i, j));
                        graph.addEdge((Node)a, b, arc);
                        ((HashSet)tmp.get(idx)).add(arc);
                        mark.set(k);
                        continue;
                    }
                    qijIter.remove();
                }
            }
            varIter.dispose();
            layerIter = ((TIntHashSet)layer.get(i)).iterator();
            while (layerIter.hasNext()) {
                if (mark.get(layerIter.next())) continue;
                layerIter.remove();
            }
        }
        TIntHashSet th = new TIntHashSet();
        int[][] intLayer = new int[n + 2][];
        for (k = 0; k < nbNodes; ++k) {
            Node o = in[n * nbNodes + k];
            if (o == null) continue;
            a = new Arc(o, tink, 0, aid++, 0.0);
            graph.addEdge(o, tink, (Arc)a);
        }
        for (i = 0; i <= n; ++i) {
            th.clear();
            for (k = 0; k < nbNodes; ++k) {
                Node o = in[i * nbNodes + k];
                if (o == null) continue;
                th.add(o.id);
            }
            intLayer[i] = th.toArray();
        }
        intLayer[n + 1] = new int[]{tink.id};
        if (intLayer[0].length > 0) {
            this.graph = new StoredValuedDirectedMultiGraph(this.solver.getEnvironment(), this, graph, intLayer, starts, offsets, totalSizes);
        } else {
            this.fail();
        }
    }

    protected int delta(int i, int j, int k) {
        if (i == this.vs.length - 1) {
            return j == k ? 0 : -1;
        }
        int lgth = k + this.cost[i] * j;
        if (lgth <= this.bVar.getSup()) {
            return lgth;
        }
        return -1;
    }

    protected int getCost(int i, int j) {
        if (i >= this.vs.length - 1) {
            return 0;
        }
        return j * this.gain[i];
    }

    protected final boolean isAccepting(int idx) {
        return idx == 0;
    }
}

