/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global.scheduling.disjunctive;

import choco.cp.solver.constraints.global.scheduling.AbstractResourceSConstraint;
import choco.cp.solver.constraints.global.scheduling.disjunctive.DisjRules;
import choco.cp.solver.constraints.global.scheduling.disjunctive.IDisjRules;
import choco.kernel.common.util.bitmask.StringMask;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.Solver;
import choco.kernel.solver.variables.integer.IntDomainVar;
import choco.kernel.solver.variables.scheduling.TaskVar;
import java.util.List;

public class Disjunctive
extends AbstractResourceSConstraint {
    private static final long serialVersionUID = -5081383350524112067L;
    public static final StringMask OVERLOAD_CHECKING = new StringMask("cp:disjunctive:overload_checking", 1L);
    public static final StringMask NF_NL = new StringMask("cp:disjunctive:not_first_not_last", 4L);
    public static final StringMask DETECTABLE_PRECEDENCE = new StringMask("cp:disjunctive:detectable_precedence", 8L);
    public static final StringMask EDGE_FINDING_D = new StringMask("cp:disjunctive:edge_finding", 16L);
    protected Policy policy = Policy.DEFAULT;
    protected IDisjRules rules;
    private boolean noFixPoint;

    protected Disjunctive(Solver solver, String name, TaskVar[] taskvars, int nbOptionalTasks, boolean enableHypotheticalDomain, IntDomainVar[] intvars) {
        super(solver, name, taskvars, nbOptionalTasks, false, enableHypotheticalDomain, intvars);
    }

    public Disjunctive(String name, TaskVar[] taskvars, IntDomainVar makespan, Solver solver) {
        super(solver, name, taskvars, makespan);
        this.rules = new DisjRules(this.rtasks, this.makespan);
    }

    @Override
    public void readOptions(List<String> options) {
        this.flags.read(options, OVERLOAD_CHECKING, NF_NL, DETECTABLE_PRECEDENCE, EDGE_FINDING_D);
        if (this.flags.isEmpty()) {
            this.flags.set(NF_NL, DETECTABLE_PRECEDENCE, EDGE_FINDING_D);
        }
        this.policy = options.contains("cp:disjunctive:vilim_filtering") ? Policy.VILIM : Policy.DEFAULT;
    }

    @Override
    public boolean isTaskConsistencyEnforced() {
        return true;
    }

    public final void setFilteringPolicy(Policy rule) {
        this.policy = rule;
    }

    public final void noSingleRule() {
        this.policy = Policy.DEFAULT;
    }

    protected final boolean applySingleRule() throws ContradictionException {
        switch (this.policy) {
            case NOT_FIRST: {
                return this.rules.notFirst();
            }
            case NOT_LAST: {
                return this.rules.notLast();
            }
            case DP_EST: {
                return this.rules.detectablePrecedenceEST();
            }
            case DP_LCT: {
                return this.rules.detectablePrecedenceLCT();
            }
            case EF_EST: {
                return this.rules.edgeFindingEST();
            }
            case EF_LCT: {
                return this.rules.edgeFindingLCT();
            }
        }
        throw new IllegalArgumentException("no rule activated in Disjunctive constraint");
    }

    protected final void singleRuleFiltering() throws ContradictionException {
        do {
            this.rules.fireDomainChanged();
            this.noFixPoint = this.applySingleRule();
        } while (this.noFixPoint);
    }

    protected final void defaultFiltering() throws ContradictionException {
        do {
            this.noFixPoint = false;
            this.rules.fireDomainChanged();
            if (this.flags.contains(EDGE_FINDING_D)) {
                this.noFixPoint |= this.rules.edgeFinding();
            } else if (this.flags.contains(OVERLOAD_CHECKING)) {
                this.rules.overloadChecking();
            }
            if (this.flags.contains(NF_NL)) {
                this.noFixPoint |= this.rules.notLast();
                if (this.flags.contains(DETECTABLE_PRECEDENCE)) {
                    this.noFixPoint |= this.rules.detectablePrecedenceEST();
                    this.noFixPoint |= this.rules.notFirst();
                    this.noFixPoint |= this.rules.detectablePrecedenceLCT();
                    continue;
                }
                this.noFixPoint |= this.rules.notFirst();
                continue;
            }
            if (!this.flags.contains(DETECTABLE_PRECEDENCE)) continue;
            this.noFixPoint |= this.rules.detectablePrecedenceEST();
            this.noFixPoint |= this.rules.detectablePrecedenceLCT();
        } while (this.noFixPoint);
    }

    protected final void vilimFiltering() throws ContradictionException {
        boolean noGlobalFixPoint;
        do {
            noGlobalFixPoint = false;
            if (this.flags.contains(EDGE_FINDING_D)) {
                do {
                    this.rules.fireDomainChanged();
                    this.noFixPoint = this.rules.edgeFinding();
                } while (this.noFixPoint);
            } else if (this.flags.contains(OVERLOAD_CHECKING)) {
                this.rules.overloadChecking();
            }
            if (this.flags.contains(NF_NL)) {
                do {
                    this.rules.fireDomainChanged();
                    this.noFixPoint = this.rules.notFirstNotLast();
                    noGlobalFixPoint |= this.noFixPoint;
                } while (this.noFixPoint);
            }
            if (!this.flags.contains(DETECTABLE_PRECEDENCE)) continue;
            do {
                this.rules.fireDomainChanged();
                this.noFixPoint = this.rules.detectablePrecedence();
                noGlobalFixPoint |= this.noFixPoint;
            } while (this.noFixPoint);
        } while (noGlobalFixPoint);
    }

    @Override
    public void propagate() throws ContradictionException {
        if (this.rules.isActive()) {
            this.rules.initialize();
            switch (this.policy) {
                case DEFAULT: {
                    this.defaultFiltering();
                    break;
                }
                case VILIM: {
                    this.vilimFiltering();
                    break;
                }
                default: {
                    this.singleRuleFiltering();
                }
            }
        }
    }

    @Override
    public boolean isSatisfied(int[] tuple) {
        return this.isCumulativeSatisfied(tuple, 0, 1);
    }

    public static enum Policy {
        DEFAULT,
        VILIM,
        NOT_FIRST,
        NOT_LAST,
        DP_EST,
        DP_LCT,
        EF_EST,
        EF_LCT;

    }
}

