/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global.scheduling.trees;

import choco.cp.solver.constraints.global.scheduling.trees.AbstractThetaTree;
import choco.cp.solver.constraints.global.scheduling.trees.AbstractVilimStatus;
import choco.cp.solver.constraints.global.scheduling.trees.AbstractVilimTree;
import choco.cp.solver.constraints.global.scheduling.trees.IThetaLambdaTree;
import choco.cp.solver.constraints.global.scheduling.trees.ThetaTreeLeaf;
import choco.cp.solver.constraints.global.scheduling.trees.status.ThetaLambdaStatus;
import choco.kernel.common.opres.graph.IBinaryNode;
import choco.kernel.solver.SolverException;
import choco.kernel.solver.variables.scheduling.IRTask;
import choco.kernel.solver.variables.scheduling.ITask;
import java.util.List;

public class DisjTreeTL
extends AbstractThetaTree
implements IThetaLambdaTree {
    public DisjTreeTL(List<? extends ITask> tasks) {
        super(tasks);
    }

    protected final ThetaLambdaStatus getRootStatus() {
        return (ThetaLambdaStatus)this.getNodeStatus(this.getRoot()).getStatus();
    }

    protected final DisjStatusTL getNodeStatus(IBinaryNode node) {
        return (DisjStatusTL)node.getNodeStatus();
    }

    @Override
    public final int getGrayTime() {
        return this.getRootStatus().getGrayTime();
    }

    @Override
    public final Object getResponsibleTask() {
        return this.getRootStatus().getRespGrayTime();
    }

    @Override
    public final boolean insertInLambda(IRTask rtask) {
        IBinaryNode leaf = this.getLeaf(rtask.getHTask());
        DisjStatusTL status = this.getNodeStatus(leaf);
        if (status.getType() == AbstractVilimTree.NodeType.NIL) {
            status.insertInLambda(rtask);
            leaf.fireStatusChanged();
            return true;
        }
        return false;
    }

    @Override
    public final boolean removeFromLambda(ITask task) {
        IBinaryNode leaf = this.getLeaf(task);
        DisjStatusTL status = this.getNodeStatus(leaf);
        if (status.getType() == AbstractVilimTree.NodeType.LAMBDA) {
            status.removeFromLambda();
            leaf.fireStatusChanged();
            return true;
        }
        return false;
    }

    private boolean removeFromThetaAndInsertInLambda(ITask task, Object resp) {
        IBinaryNode leaf = this.getLeaf(task);
        DisjStatusTL status = this.getNodeStatus(leaf);
        if (status.getType() == AbstractVilimTree.NodeType.THETA) {
            status.insertInLambda(resp);
            leaf.fireStatusChanged();
            return true;
        }
        return false;
    }

    @Override
    public final boolean removeFromThetaAndInsertInLambda(ITask task) {
        return this.removeFromThetaAndInsertInLambda(task, task);
    }

    @Override
    public final boolean removeFromThetaAndInsertInLambda(IRTask rtask) {
        return this.removeFromThetaAndInsertInLambda(rtask.getHTask(), rtask);
    }

    @Override
    public final int getTime() {
        return this.getRootStatus().getTime();
    }

    @Override
    public void insert(ITask task) {
        this.insertTask(task, new DisjStatusTL(AbstractVilimTree.NodeType.NIL), new DisjStatusTL(AbstractVilimTree.NodeType.INTERNAL));
    }

    protected class DisjStatusTL
    extends AbstractVilimStatus<ThetaLambdaStatus>
    implements ThetaTreeLeaf {
        public DisjStatusTL(AbstractVilimTree.NodeType type) {
            super(type, new ThetaLambdaStatus());
        }

        @Override
        public final void insertInTheta(IRTask rtask) {
            this.insertInTheta();
        }

        protected final int getLeafTime() {
            return DisjTreeTL.this.getMode().value() ? this.task.getEST() + this.task.getMinDuration() : this.task.getLCT() - this.task.getMinDuration();
        }

        @Override
        public final void removeFromTheta() {
            this.setType(AbstractVilimTree.NodeType.NIL);
            ((ThetaLambdaStatus)this.status).setTime(this.getResetIntValue(DisjTreeTL.this.getMode()));
            ((ThetaLambdaStatus)this.status).setDuration(0);
            ((ThetaLambdaStatus)this.status).setGrayTime(this.getResetIntValue(DisjTreeTL.this.getMode()));
            ((ThetaLambdaStatus)this.status).setGrayDuration(0);
        }

        @Override
        public final void insertInTheta() {
            this.setType(AbstractVilimTree.NodeType.THETA);
            ((ThetaLambdaStatus)this.getStatus()).setTime(this.getLeafTime());
            ((ThetaLambdaStatus)this.getStatus()).setDuration(this.task.getMinDuration());
            ((ThetaLambdaStatus)this.getStatus()).setGrayTime(((ThetaLambdaStatus)this.getStatus()).getTime());
            ((ThetaLambdaStatus)this.getStatus()).setGrayDuration(((ThetaLambdaStatus)this.getStatus()).getDuration());
        }

        public final void insertInLambda(Object resp) {
            this.setType(AbstractVilimTree.NodeType.LAMBDA);
            ((ThetaLambdaStatus)this.status).setTime(this.getResetIntValue(DisjTreeTL.this.getMode()));
            ((ThetaLambdaStatus)this.status).setDuration(0);
            ((ThetaLambdaStatus)this.getStatus()).setGrayTime(this.getLeafTime());
            ((ThetaLambdaStatus)this.getStatus()).setGrayDuration(this.task.getMinDuration());
            ((ThetaLambdaStatus)this.status).setRespGrayTime(resp);
            ((ThetaLambdaStatus)this.status).setRespGrayDuration(resp);
        }

        public final void removeFromLambda() {
            this.setType(AbstractVilimTree.NodeType.NIL);
            ((ThetaLambdaStatus)this.status).setGrayTime(this.getResetIntValue(DisjTreeTL.this.getMode()));
            ((ThetaLambdaStatus)this.status).setGrayDuration(0);
            ((ThetaLambdaStatus)this.status).setRespGrayTime(null);
            ((ThetaLambdaStatus)this.status).setRespGrayDuration(null);
        }

        @Override
        public void reset() {
            this.insertInTheta();
        }

        @Override
        public final void setTask(ITask task) {
            super.setTask(task);
        }

        @Override
        protected final void writeDotStatus(StringBuilder buffer) {
            this.writeRow(buffer, DisjTreeTL.this.getMode().label(), this.format(((ThetaLambdaStatus)this.status).getTime()), "P", String.valueOf(((ThetaLambdaStatus)this.status).getDuration()));
            buffer.append('|');
            this.writeRow(buffer, "Gr" + DisjTreeTL.this.getMode().label(), this.format(((ThetaLambdaStatus)this.status).getGrayTime()), "GrP", String.valueOf(((ThetaLambdaStatus)this.status).getGrayDuration()));
            if (this.getType() == AbstractVilimTree.NodeType.INTERNAL) {
                buffer.append('|');
                String t1 = ((ThetaLambdaStatus)this.status).getRespGrayTime() == null ? "?" : ((ThetaLambdaStatus)this.status).getRespGrayTime().toString();
                String t2 = ((ThetaLambdaStatus)this.status).getRespGrayDuration() == null ? "?" : ((ThetaLambdaStatus)this.status).getRespGrayDuration().toString();
                this.writeRow(buffer, "Gr" + DisjTreeTL.this.getMode().label(), t1, "GrP", t2);
            }
        }

        @Override
        public void updateInternalNode(IBinaryNode node) {
            if (node.getLeftChild().getNodeStatus() instanceof DisjStatusTL) {
                ThetaLambdaStatus left = (ThetaLambdaStatus)((DisjStatusTL)node.getLeftChild().getNodeStatus()).getStatus();
                if (node.getRightChild().getNodeStatus() instanceof DisjStatusTL) {
                    ThetaLambdaStatus right = (ThetaLambdaStatus)((DisjStatusTL)node.getRightChild().getNodeStatus()).getStatus();
                    ((ThetaLambdaStatus)this.status).update(DisjTreeTL.this.getMode(), left, right);
                    return;
                }
            }
            throw new SolverException("cant update node");
        }
    }
}

