/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.set;

import choco.kernel.common.util.iterators.DisposableIntIterator;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.constraints.set.AbstractBinSetIntSConstraint;
import choco.kernel.solver.variables.integer.IntDomainVar;
import choco.kernel.solver.variables.set.SetVar;

public final class SetCard
extends AbstractBinSetIntSConstraint {
    protected boolean inf = false;
    protected boolean sup = false;

    public SetCard(SetVar sv, IntDomainVar iv, boolean inf, boolean sup) {
        super(iv, sv);
        this.inf = inf;
        this.sup = sup;
    }

    @Override
    public int getFilteredEventMask(int idx) {
        if (idx == 0) {
            return 15;
        }
        return 7;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reactOnInfAndEnvEvents(int envSize) throws ContradictionException {
        if (this.v0.getInf() > envSize) {
            this.fail();
        } else if (this.v0.getInf() == envSize) {
            DisposableIntIterator it = this.v1.getDomain().getOpenDomainIterator();
            try {
                while (it.hasNext()) {
                    this.v1.addToKernel(it.next(), this, false);
                }
            }
            finally {
                it.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reactOnSupAndKerEvents(int kerSize) throws ContradictionException {
        if (this.v0.getSup() < kerSize) {
            this.fail();
        } else if (this.v0.getSup() == kerSize) {
            DisposableIntIterator it = this.v1.getDomain().getOpenDomainIterator();
            try {
                while (it.hasNext()) {
                    this.v1.remFromEnveloppe(it.next(), this, false);
                }
            }
            finally {
                it.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void filter() throws ContradictionException {
        int envSize = this.v1.getEnveloppeDomainSize();
        int kerSize = this.v1.getKernelDomainSize();
        if (this.inf && this.sup) {
            if (this.v0.getSup() < kerSize || this.v0.getInf() > envSize) {
                this.fail();
            } else if (kerSize < envSize) {
                if (this.v0.getInf() == envSize) {
                    DisposableIntIterator it = this.v1.getDomain().getOpenDomainIterator();
                    try {
                        while (it.hasNext()) {
                            this.v1.addToKernel(it.next(), this, false);
                        }
                    }
                    finally {
                        it.dispose();
                    }
                } else if (this.v0.getSup() == kerSize) {
                    DisposableIntIterator it = this.v1.getDomain().getOpenDomainIterator();
                    try {
                        while (it.hasNext()) {
                            this.v1.remFromEnveloppe(it.next(), this, false);
                        }
                    }
                    finally {
                        it.dispose();
                    }
                }
            }
        } else if (this.inf) {
            if (this.v0.getSup() < kerSize) {
                this.fail();
            } else if (kerSize < envSize && this.v0.getSup() == kerSize) {
                DisposableIntIterator it = this.v1.getDomain().getOpenDomainIterator();
                try {
                    while (it.hasNext()) {
                        this.v1.remFromEnveloppe(it.next(), this, false);
                    }
                }
                finally {
                    it.dispose();
                }
            }
        } else if (this.v0.getInf() > envSize) {
            this.fail();
        } else if (kerSize < envSize && this.v0.getInf() == envSize) {
            DisposableIntIterator it = this.v1.getDomain().getOpenDomainIterator();
            try {
                while (it.hasNext()) {
                    this.v1.addToKernel(it.next(), this, false);
                }
            }
            finally {
                it.dispose();
            }
        }
    }

    @Override
    public void awakeOnInf(int idx) throws ContradictionException {
        if (this.inf) {
            this.reactOnInfAndEnvEvents(this.v1.getEnveloppeDomainSize());
        }
    }

    @Override
    public void awakeOnSup(int idx) throws ContradictionException {
        if (this.sup) {
            this.reactOnSupAndKerEvents(this.v1.getKernelDomainSize());
        }
    }

    @Override
    public void awakeOnRemovals(int idx, DisposableIntIterator deltaDomain) throws ContradictionException {
        this.filter();
    }

    @Override
    public void awakeOnkerAdditions(int idx, DisposableIntIterator deltaDomain) throws ContradictionException {
        if (this.inf) {
            int kerSize = this.v1.getKernelDomainSize();
            this.v0.updateInf(kerSize, this, false);
            this.reactOnSupAndKerEvents(kerSize);
        }
    }

    @Override
    public void awakeOnEnvRemovals(int idx, DisposableIntIterator deltaDomain) throws ContradictionException {
        if (this.sup) {
            int envSize = this.v1.getEnveloppeDomainSize();
            this.v0.updateSup(envSize, this, false);
            this.reactOnInfAndEnvEvents(envSize);
        }
    }

    @Override
    public void awakeOnInst(int varIdx) throws ContradictionException {
        if (varIdx == 1) {
            int kerSize = this.v1.getKernelDomainSize();
            if (this.inf && this.sup) {
                this.v0.instantiate(kerSize, this, false);
            } else if (this.inf) {
                this.v0.updateInf(kerSize, this, false);
            } else {
                this.v0.updateSup(kerSize, this, false);
            }
        } else {
            this.filter();
        }
    }

    @Override
    public boolean isSatisfied() {
        if (this.inf && this.sup) {
            return this.v1.getKernelDomainSize() == this.v0.getVal();
        }
        if (this.inf) {
            return this.v1.getKernelDomainSize() <= this.v0.getVal();
        }
        return this.v1.getKernelDomainSize() >= this.v0.getVal();
    }

    @Override
    public String toString() {
        if (this.inf && !this.sup) {
            return " |" + this.v1 + "| <= " + this.v0;
        }
        if (!this.inf && this.sup) {
            return " |" + this.v1 + "| >= " + this.v0;
        }
        return " |" + this.v1 + "| = " + this.v0;
    }

    @Override
    public String pretty() {
        if (this.inf && !this.sup) {
            return " |" + this.v1.pretty() + "| <= " + this.v0.pretty();
        }
        if (!this.inf && this.sup) {
            return " |" + this.v1.pretty() + "| >= " + this.v0.pretty();
        }
        return " |" + this.v1.pretty() + "| = " + this.v0.pretty();
    }

    @Override
    public void awake() throws ContradictionException {
        if (this.inf && this.sup) {
            this.v0.updateInf(this.v1.getKernelDomainSize(), this, false);
            this.v0.updateSup(this.v1.getEnveloppeDomainSize(), this, false);
        } else if (this.inf) {
            this.v0.updateInf(this.v1.getKernelDomainSize(), this, false);
        } else {
            this.v0.updateSup(this.v1.getEnveloppeDomainSize(), this, false);
        }
        this.propagate();
    }

    @Override
    public void propagate() throws ContradictionException {
        this.filter();
    }

    @Override
    public boolean isConsistent() {
        return this.v1.isInstantiated() && this.v0.isInstantiated() && this.isSatisfied();
    }

    @Override
    public Boolean isEntailed() {
        if (this.inf & this.sup) {
            if (this.v0.getInf() > this.v1.getEnveloppeDomainSize()) {
                return Boolean.FALSE;
            }
            if (this.v0.getSup() < this.v1.getKernelDomainSize()) {
                return Boolean.FALSE;
            }
            if (this.v0.isInstantiated() && this.v1.isInstantiated()) {
                return Boolean.TRUE;
            }
            return null;
        }
        if (this.inf) {
            if (this.v0.getSup() < this.v1.getKernelDomainSize()) {
                return Boolean.FALSE;
            }
            if (this.v0.isInstantiated() && this.v1.isInstantiated()) {
                return Boolean.TRUE;
            }
            return null;
        }
        if (this.v0.getInf() > this.v1.getEnveloppeDomainSize()) {
            return Boolean.FALSE;
        }
        if (this.v0.isInstantiated() && this.v1.isInstantiated()) {
            return Boolean.TRUE;
        }
        return null;
    }
}

