/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.variables.integer;

import choco.cp.solver.variables.integer.AbstractIntDomain;
import choco.kernel.common.util.iterators.DisposableIntIterator;
import choco.kernel.common.util.iterators.OneValueIterator;
import choco.kernel.solver.propagation.PropagationEngine;
import choco.kernel.solver.variables.integer.IntDomainVar;

final class OneValueIntDomain
extends AbstractIntDomain {
    private final int value;
    private final boolean isBoolean;

    OneValueIntDomain(IntDomainVar aVariable, int theValue, PropagationEngine propagationEngine) {
        super(aVariable, propagationEngine);
        this.value = theValue;
        this.isBoolean = this.value == 0 || this.value == 1;
    }

    @Override
    public int getInf() {
        return this.value;
    }

    @Override
    public int getSup() {
        return this.value;
    }

    @Override
    public int updateInf(int x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int updateSup(int x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean contains(int x) {
        return x == this.value;
    }

    @Override
    public boolean remove(int x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void restrict(int x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getSize() {
        return 1;
    }

    @Override
    public DisposableIntIterator getIterator() {
        return OneValueIterator.getIterator(this.value);
    }

    @Override
    public int getNextValue(int x) {
        if (x < this.value) {
            return this.value;
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public int getPrevValue(int x) {
        if (x > this.value) {
            return this.value;
        }
        return Integer.MIN_VALUE;
    }

    @Override
    public boolean hasNextValue(int x) {
        return x < this.value;
    }

    @Override
    public boolean hasPrevValue(int x) {
        return x > this.value;
    }

    @Override
    public int getRandomValue() {
        return this.value;
    }

    @Override
    public boolean isEnumerated() {
        return true;
    }

    @Override
    public boolean isBoolean() {
        return this.isBoolean;
    }

    @Override
    public String pretty() {
        return String.valueOf(91 + this.value + 93);
    }
}

