/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.memory.copy;

import choco.kernel.common.util.iterators.DisposableIntIterator;
import choco.kernel.memory.IStateDoubleVector;
import choco.kernel.memory.copy.EnvironmentCopying;
import choco.kernel.memory.copy.RcInt;
import choco.kernel.memory.copy.RecomputableElement;

public class RcDoubleVector
implements IStateDoubleVector,
RecomputableElement {
    public static final int MIN_CAPACITY = 8;
    private double[] elementData;
    private RcInt size;
    private final EnvironmentCopying environment;
    private int timeStamp;

    public RcDoubleVector(EnvironmentCopying env, int initialSize, double initialValue) {
        int initialCapacity = 8;
        if (initialCapacity < initialSize) {
            initialCapacity = initialSize;
        }
        this.environment = env;
        this.timeStamp = this.environment.getWorldIndex();
        this.elementData = new double[initialCapacity];
        for (int i = 0; i < initialSize; ++i) {
            this.elementData[i] = initialValue;
        }
        this.size = new RcInt(env, initialSize);
        env.add(this);
    }

    public RcDoubleVector(EnvironmentCopying env, double[] entries) {
        int initialCapacity = 8;
        int initialSize = entries.length;
        if (initialCapacity < initialSize) {
            initialCapacity = initialSize;
        }
        this.environment = env;
        this.elementData = new double[initialCapacity];
        System.arraycopy(entries, 0, this.elementData, 0, initialSize);
        this.size = new RcInt(env, initialSize);
        env.add(this);
        this.timeStamp = this.environment.getWorldIndex();
    }

    public RcDoubleVector(EnvironmentCopying env) {
        this(env, 0, 0.0);
    }

    @Override
    public int size() {
        return this.size.get();
    }

    @Override
    public boolean isEmpty() {
        return this.size.get() == 0;
    }

    public void ensureCapacity(int minCapacity) {
        int oldCapacity = this.elementData.length;
        if (minCapacity > oldCapacity) {
            double[] oldData = this.elementData;
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.elementData = new double[newCapacity];
            System.arraycopy(oldData, 0, this.elementData, 0, this.size.get());
        }
    }

    @Override
    public void add(double i) {
        this.timeStamp = this.environment.getWorldIndex();
        int newsize = this.size.get() + 1;
        this.ensureCapacity(newsize);
        this.size.set(newsize);
        this.elementData[newsize - 1] = i;
    }

    @Override
    public void removeLast() {
        this.timeStamp = this.environment.getWorldIndex();
        int newsize = this.size.get() - 1;
        if (newsize >= 0) {
            this.size.set(newsize);
        }
    }

    @Override
    public double get(int index) {
        if (index < this.size.get() && index >= 0) {
            return this.elementData[index];
        }
        throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size.get());
    }

    @Override
    public final double quickGet(int index) {
        return this.elementData[index];
    }

    @Override
    public double set(int index, double val) {
        if (index < this.size.get() && index >= 0) {
            double oldValue = this.elementData[index];
            if (val != oldValue) {
                this.elementData[index] = val;
            }
            this.timeStamp = this.environment.getWorldIndex();
            return oldValue;
        }
        throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size.get());
    }

    @Override
    public double quickSet(int index, double val) {
        double oldValue = this.elementData[index];
        if (val != oldValue) {
            this.elementData[index] = val;
        }
        this.timeStamp = this.environment.getWorldIndex();
        return oldValue;
    }

    @Override
    public void remove(int i) {
    }

    public void _set(double[] vals) {
        this.timeStamp = this.environment.getWorldIndex();
        System.arraycopy(vals, 0, this.elementData, 0, vals.length);
    }

    public void _set(double[] vals, int timeStamp) {
        this.timeStamp = timeStamp;
        System.arraycopy(vals, 0, this.elementData, 0, vals.length);
    }

    public double[] deepCopy() {
        double[] ret = new double[this.size.get()];
        System.arraycopy(this.elementData, 0, ret, 0, this.size.get());
        return ret;
    }

    @Override
    public int getType() {
        return 5;
    }

    @Override
    public int getTimeStamp() {
        return this.timeStamp;
    }

    @Override
    public DisposableIntIterator getIterator() {
        throw new UnsupportedOperationException("not yet implemented");
    }
}

