/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.model.constraints;

import choco.IPretty;
import choco.kernel.common.IIndex;
import choco.kernel.common.util.tools.ArrayUtils;
import choco.kernel.common.util.tools.StringUtils;
import choco.kernel.model.constraints.AbstractConstraint;
import choco.kernel.model.constraints.Constraint;
import choco.kernel.model.constraints.ConstraintType;
import choco.kernel.model.variables.Variable;
import java.util.Properties;

public final class MetaConstraint<E extends Constraint>
extends AbstractConstraint {
    private static final Variable[] EMPTY_ARRAY = new Variable[0];
    protected E[] constraints;

    public MetaConstraint(ConstraintType type, E ... constraints) {
        super(type, EMPTY_ARRAY);
        this.constraints = (Constraint[])constraints.clone();
    }

    public MetaConstraint(Class metaManager, E ... constraints) {
        super(metaManager.getName(), EMPTY_ARRAY);
        this.constraints = (Constraint[])constraints.clone();
    }

    public MetaConstraint(String metaManager, E ... constraints) {
        super(metaManager, EMPTY_ARRAY);
        this.constraints = (Constraint[])constraints.clone();
    }

    public E[] getConstraints() {
        return this.constraints;
    }

    public final E getConstraint(int idx) {
        return this.constraints[idx];
    }

    @Override
    public Variable[] doExtractVariables() {
        IIndex[] listVars = new Variable[]{};
        for (E c : this.constraints) {
            listVars = ArrayUtils.append(listVars, c.extractVariables());
        }
        return (Variable[])ArrayUtils.getNonRedundantObjects(Variable.class, (IIndex[])listVars);
    }

    @Override
    public void findManager(Properties propertiesFile) {
        super.findManager(propertiesFile);
        for (int i = 0; i < this.constraints.length; ++i) {
            E constraint = this.constraints[i];
            constraint.findManager(propertiesFile);
        }
    }

    private void constraintsPrettyPrint(StringBuilder buffer) {
        buffer.append(StringUtils.pretty((IPretty[])this.getConstraints(), 0, this.getConstraints().length));
    }

    @Override
    public String pretty() {
        StringBuilder st = new StringBuilder(this.getName());
        st.append(" ( ");
        this.constraintsPrettyPrint(st);
        st.append(" ) ");
        return st.toString();
    }
}

