/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.model.constraints.automaton.penalty;

import choco.kernel.common.util.iterators.DisposableIntIterator;
import choco.kernel.model.constraints.automaton.penalty.IPenaltyFunction;
import choco.kernel.solver.variables.integer.IntDomainVar;

public abstract class AbstractPenaltyFunction
implements IPenaltyFunction {
    @Override
    public abstract int penalty(int var1);

    @Override
    public double minGHat(double lambda, IntDomainVar var) {
        DisposableIntIterator valIter = var.getDomain().getIterator();
        double ghat = Double.POSITIVE_INFINITY;
        while (valIter.hasNext()) {
            int val = valIter.next();
            ghat = Math.min(ghat, (double)this.penalty(val) - lambda * (double)val);
        }
        valIter.dispose();
        return ghat;
    }

    @Override
    public double maxGHat(double lambda, IntDomainVar var) {
        DisposableIntIterator valIter = var.getDomain().getIterator();
        double ghat = Double.NEGATIVE_INFINITY;
        while (valIter.hasNext()) {
            int val = valIter.next();
            ghat = Math.max(ghat, (double)this.penalty(val) - lambda * (double)val);
        }
        valIter.dispose();
        return ghat;
    }
}

