/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.solver.search.restart;

import choco.kernel.solver.search.restart.UniversalRestartStrategy;

public abstract class AbstractRestartStrategy
implements UniversalRestartStrategy {
    private final String name;
    protected int scaleFactor = 1;
    protected double geometricalFactor = 1.0;

    public AbstractRestartStrategy(String name, int scaleFactor, double geometricalFactor) {
        this.name = name;
        this.setScaleFactor(scaleFactor);
        this.setGeometricalFactor(geometricalFactor);
    }

    protected static final void checkPositiveValue(double value) {
        if (value <= 0.0) {
            throw new IllegalArgumentException("arguments should be strictly positive.");
        }
    }

    @Override
    public double getGeometricalFactor() {
        return this.geometricalFactor;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final int getScaleFactor() {
        return this.scaleFactor;
    }

    @Override
    public void setGeometricalFactor(double geometricalFactor) {
        AbstractRestartStrategy.checkPositiveValue(geometricalFactor);
        this.geometricalFactor = geometricalFactor;
    }

    @Override
    public final void setScaleFactor(int scaleFactor) {
        AbstractRestartStrategy.checkPositiveValue(scaleFactor);
        this.scaleFactor = scaleFactor;
    }

    @Override
    public String pretty() {
        return this.getName() + '(' + this.getScaleFactor() + ',' + this.getGeometricalFactor() + ')';
    }

    public int[] getSequenceExample(int length) {
        int[] res = new int[length];
        for (int i = 0; i < res.length; ++i) {
            res[i] = this.getNextCutoff(i);
        }
        return res;
    }
}

