/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.solver.variables.scheduling;

import choco.kernel.common.util.tools.TaskUtils;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.variables.integer.IntDomainVar;
import choco.kernel.solver.variables.scheduling.IRTask;
import choco.kernel.solver.variables.scheduling.TaskVar;

public abstract class AbstractRTask
implements IRTask {
    public final int taskIdx;
    public TaskVar taskvar;
    public IntDomainVar usage;
    public IntDomainVar height;
    protected int value;

    public AbstractRTask(int taskIdx) {
        this.taskIdx = taskIdx;
    }

    @Override
    public final int getMaxHeight() {
        return this.getHeight().getSup();
    }

    @Override
    public final int getMinHeight() {
        return this.getHeight().getInf();
    }

    @Override
    public final long getMaxConsumption() {
        return TaskUtils.getMaxConsumption(this);
    }

    @Override
    public final long getMinConsumption() {
        return TaskUtils.getMinConsumption(this);
    }

    @Override
    public final int getTaskIndex() {
        return this.taskIdx;
    }

    @Override
    public final int getStoredValue() {
        return this.value;
    }

    @Override
    public void storeValue(int val) {
        this.value = val;
    }

    @Override
    public final boolean updateECT() throws ContradictionException {
        return this.updateECT(this.value);
    }

    @Override
    public final boolean updateEST() throws ContradictionException {
        return this.updateEST(this.value);
    }

    @Override
    public final boolean updateLCT() throws ContradictionException {
        return this.updateLCT(this.value);
    }

    @Override
    public final boolean updateLST() throws ContradictionException {
        return this.updateLST(this.value);
    }
}

