/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.experimental.touchgraph;

import com.touchgraph.graphlayout.GLPanel;
import com.touchgraph.graphlayout.Node;
import com.touchgraph.graphlayout.TGException;
import com.touchgraph.graphlayout.TGLensSet;
import com.touchgraph.graphlayout.TGPanel;
import com.touchgraph.graphlayout.interaction.HVScroll;
import com.touchgraph.graphlayout.interaction.HyperScroll;
import com.touchgraph.graphlayout.interaction.LocalityScroll;
import com.touchgraph.graphlayout.interaction.RotateScroll;
import com.touchgraph.graphlayout.interaction.ZoomScroll;
import java.awt.Color;
import java.util.Hashtable;
import org.jgrapht.Graph;
import org.jgrapht.experimental.touchgraph.TouchgraphConverter;

public class TouchgraphPanel<V, E>
extends GLPanel {
    private static final long serialVersionUID = -7441058429719746032L;
    private Color defaultBackColor = new Color(1, 17, 68);
    private Color defaultBorderBackColor = new Color(2, 53, 129);
    private Color defaultForeColor = new Color(0.95f, 0.85f, 0.55f);
    Graph<V, E> graph;
    boolean selfReferencesAllowed = true;

    public TouchgraphPanel(Graph<V, E> graph, boolean bl) {
        this.graph = graph;
        this.selfReferencesAllowed = bl;
        this.preinitialize();
        this.initialize();
    }

    public void preinitialize() {
        this.setBackground(this.defaultBorderBackColor);
        this.setForeground(this.defaultForeColor);
        this.scrollBarHash = new Hashtable();
        this.tgLensSet = new TGLensSet();
        this.tgPanel = new TGPanel();
        this.tgPanel.setBackColor(this.defaultBackColor);
        this.hvScroll = new HVScroll(this.tgPanel, this.tgLensSet);
        this.zoomScroll = new ZoomScroll(this.tgPanel);
        this.hyperScroll = new HyperScroll(this.tgPanel);
        this.rotateScroll = new RotateScroll(this.tgPanel);
        this.localityScroll = new LocalityScroll(this.tgPanel);
    }

    public void initialize() {
        this.buildPanel();
        this.buildLens();
        this.tgPanel.setLensSet(this.tgLensSet);
        this.addUIs();
        try {
            if (this.graph == null) {
                this.randomGraph();
            } else {
                TouchgraphConverter<V, E> touchgraphConverter = new TouchgraphConverter<V, E>();
                Node node = touchgraphConverter.convertToTouchGraph(this.graph, this.tgPanel, this.selfReferencesAllowed);
                this.getHVScroll().slowScrollToCenter(node);
                this.tgPanel.setLocale(node, Integer.MAX_VALUE);
            }
        }
        catch (TGException tGException) {
            System.err.println(tGException.getMessage());
            tGException.printStackTrace(System.err);
        }
        this.setVisible(true);
    }
}

