/*
 * Decompiled with CFR 0.152.
 */
package com.qarks.util.security;

import com.qarks.util.security.FileEncryptor;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;

public class RSAEncryptor
extends FileEncryptor {
    private Key publicKey;
    private Key privateKey;
    private boolean isEncryptInitialized;
    private boolean isDecryptInitialized;

    public RSAEncryptor(String string) throws FileNotFoundException, IOException, ClassNotFoundException, InvalidKeyException {
        ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(string));
        Object object = objectInputStream.readObject();
        objectInputStream.close();
        if (object instanceof PublicKey) {
            this.publicKey = (Key)object;
            this.isEncryptInitialized = true;
        } else if (object instanceof PrivateKey) {
            this.privateKey = (Key)object;
            this.isDecryptInitialized = true;
        } else {
            throw new InvalidKeyException("The file does not contain a valid key");
        }
    }

    public RSAEncryptor(File file) throws FileNotFoundException, IOException, ClassNotFoundException, InvalidKeyException {
        ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(file));
        Object object = objectInputStream.readObject();
        objectInputStream.close();
        if (object instanceof PublicKey) {
            this.publicKey = (Key)object;
            this.isEncryptInitialized = true;
        } else if (object instanceof PrivateKey) {
            this.privateKey = (Key)object;
            this.isDecryptInitialized = true;
        } else {
            throw new InvalidKeyException("The file does not contain a valid key");
        }
    }

    public RSAEncryptor(PublicKey publicKey) {
        this.publicKey = publicKey;
        this.isEncryptInitialized = true;
    }

    public RSAEncryptor(PrivateKey privateKey) {
        this.privateKey = privateKey;
        this.isDecryptInitialized = true;
    }

    public RSAEncryptor(String string, String string2) throws FileNotFoundException, IOException, ClassNotFoundException, InvalidKeyException {
        ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(string));
        Object object = objectInputStream.readObject();
        objectInputStream.close();
        objectInputStream = new ObjectInputStream(new FileInputStream(string2));
        Object object2 = objectInputStream.readObject();
        objectInputStream.close();
        if (!(object instanceof PublicKey) || !(object2 instanceof PrivateKey)) {
            throw new InvalidKeyException("Some of the files don't contains a valid key");
        }
        this.publicKey = (Key)object;
        this.isEncryptInitialized = true;
        this.privateKey = (Key)object2;
        this.isDecryptInitialized = true;
    }

    public RSAEncryptor(File file, File file2) throws FileNotFoundException, IOException, ClassNotFoundException {
        ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(file));
        this.publicKey = (Key)objectInputStream.readObject();
        this.isEncryptInitialized = true;
        objectInputStream.close();
        objectInputStream = new ObjectInputStream(new FileInputStream(file2));
        this.privateKey = (Key)objectInputStream.readObject();
        this.isDecryptInitialized = true;
        objectInputStream.close();
    }

    public RSAEncryptor(PublicKey publicKey, PrivateKey privateKey) {
        this.publicKey = publicKey;
        this.isEncryptInitialized = true;
        this.privateKey = privateKey;
        this.isDecryptInitialized = true;
    }

    public RSAEncryptor(KeyPair keyPair) {
        this(keyPair.getPublic(), keyPair.getPrivate());
    }

    public PublicKey getPublicKey() {
        return (PublicKey)this.publicKey;
    }

    public void setPublicKey(PublicKey publicKey) {
        this.publicKey = publicKey;
    }

    public PrivateKey getPrivateKey() {
        return (PrivateKey)this.privateKey;
    }

    public static RSAEncryptor getInstance(int n) {
        return new RSAEncryptor(RSAEncryptor.generateKeys(n));
    }

    public static RSAEncryptor getInstance(int n, String string, String string2) throws IOException {
        return new RSAEncryptor(RSAEncryptor.generateAndSaveKeys(n, string, string2));
    }

    public static RSAEncryptor getInstance(int n, File file, File file2) throws IOException {
        return new RSAEncryptor(RSAEncryptor.generateAndSaveKeys(n, file, file2));
    }

    public static KeyPair generateKeys(int n) {
        KeyPairGenerator keyPairGenerator = null;
        try {
            keyPairGenerator = KeyPairGenerator.getInstance("RSA");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
        }
        SecureRandom secureRandom = new SecureRandom();
        keyPairGenerator.initialize(n, secureRandom);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        return keyPair;
    }

    public static KeyPair generateAndSaveKeys(int n, String string, String string2) throws IOException {
        return RSAEncryptor.generateAndSaveKeys(n, new File(string), new File(string2));
    }

    public static KeyPair generateAndSaveKeys(int n, File file, File file2) throws IOException {
        KeyPair keyPair = RSAEncryptor.generateKeys(n);
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(file));
        objectOutputStream.writeObject(keyPair.getPublic());
        objectOutputStream.close();
        objectOutputStream = new ObjectOutputStream(new FileOutputStream(file2));
        objectOutputStream.writeObject(keyPair.getPrivate());
        objectOutputStream.close();
        return keyPair;
    }

    @Override
    public void encryptStream(InputStream inputStream, OutputStream outputStream) throws InvalidKeyException, IOException {
        if (!this.isEncryptInitialized) {
            throw new IllegalStateException("The underlying encryptor is not initialized in encrypt mode. You must specify a public key.");
        }
        KeyGenerator keyGenerator = null;
        Cipher cipher = null;
        Cipher cipher2 = null;
        try {
            keyGenerator = KeyGenerator.getInstance("AES");
            cipher = Cipher.getInstance("RSA");
            cipher2 = Cipher.getInstance("AES");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            noSuchPaddingException.printStackTrace();
        }
        SecureRandom secureRandom = new SecureRandom();
        keyGenerator.init(secureRandom);
        SecretKey secretKey = keyGenerator.generateKey();
        cipher.init(3, this.publicKey);
        byte[] byArray = null;
        try {
            byArray = cipher.wrap(secretKey);
        }
        catch (InvalidKeyException invalidKeyException) {
            invalidKeyException.printStackTrace();
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            illegalBlockSizeException.printStackTrace();
        }
        Integer n = byArray.length;
        DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
        dataOutputStream.writeInt(n);
        dataOutputStream.write(byArray);
        cipher2.init(1, secretKey);
        super.crypt(inputStream, dataOutputStream, cipher2);
    }

    @Override
    public void decryptStream(InputStream inputStream, OutputStream outputStream) throws IOException, InvalidKeyException {
        if (!this.isDecryptInitialized) {
            throw new IllegalStateException("The underlying encryptor is not initialized in decrypt mode. You must specify a private key.");
        }
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        int n = dataInputStream.readInt();
        if (n > 10480) {
            throw new InvalidKeyException("invalid key");
        }
        byte[] byArray = new byte[n];
        inputStream.read(byArray, 0, n);
        Cipher cipher = null;
        Cipher cipher2 = null;
        Key key = null;
        try {
            cipher = Cipher.getInstance("RSA");
            cipher2 = Cipher.getInstance("AES");
            cipher.init(4, this.privateKey);
            key = cipher.unwrap(byArray, "AES", 3);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            noSuchPaddingException.printStackTrace();
        }
        cipher2.init(2, key);
        super.crypt(dataInputStream, outputStream, cipher2);
    }
}

