/*
 * Decompiled with CFR 0.152.
 */
package com.qarks.util.ui.swing.table;

import com.qarks.util.ui.swing.table.SingleObjectTableColumn;
import com.qarks.util.ui.swing.table.SingleObjectTableSorterModel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class SingleObjectSortedTable
extends JTable {
    private SingleObjectTableSorterModel sorterModel = (SingleObjectTableSorterModel)this.getModel();
    private TableColumnModel columnModel = new DefaultTableColumnModel();

    public SingleObjectSortedTable() {
        this(true);
    }

    public SingleObjectSortedTable(boolean bl) {
        super(new SingleObjectTableSorterModel());
        if (bl) {
            this.sorterModel.addMouseListenerToHeaderInTable(this);
        }
        this.setColumnModel(this.columnModel);
    }

    public void addColumn(SingleObjectTableColumn singleObjectTableColumn, String string) {
        this.columnModel.addColumn(singleObjectTableColumn);
        singleObjectTableColumn.setCellRenderer(singleObjectTableColumn.getCellRenderer());
        singleObjectTableColumn.setHeaderValue(string);
        this.sorterModel.addColumn(singleObjectTableColumn);
    }

    public void addColumn(SingleObjectTableColumn singleObjectTableColumn, String string, int n) {
        this.columnModel.addColumn(singleObjectTableColumn);
        singleObjectTableColumn.setCellRenderer(singleObjectTableColumn.getCellRenderer());
        singleObjectTableColumn.setHeaderValue(string);
        this.sorterModel.addColumn(singleObjectTableColumn);
        singleObjectTableColumn.setWidth(n);
    }

    public int indexOf(Object object) {
        return this.sorterModel.indexOf(object, -1);
    }

    public void setRowCount(int n) {
        this.sorterModel.setRowCount(n);
    }

    public void addRow(Object object) {
        Object[] objectArray = this.storeSelectedObjectsForAddRows();
        this.sorterModel.addRow(object);
        this.restoreSelectedObjectsAfterRowsAdded(objectArray);
    }

    public Object getRow(int n) {
        return this.sorterModel.getSingleObjectAt(n);
    }

    public void addRows(Object[] objectArray) {
        Object[] objectArray2 = this.storeSelectedObjectsForAddRows();
        this.sorterModel.addRows(objectArray);
        this.restoreSelectedObjectsAfterRowsAdded(objectArray2);
    }

    public void removeRows(Object[] objectArray) {
        int[] nArray = new int[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            nArray[i] = this.sorterModel.indexOf(objectArray[i], -1);
        }
        this.removeRows(nArray);
    }

    public void removeRow(Object object) {
        int n = this.sorterModel.indexOf(object, -1);
        if (n > -1) {
            this.removeRow(n);
        }
    }

    public void removeAllRows() {
        this.getSelectionModel().clearSelection();
        int n = this.getRowCount();
        int[] nArray = new int[n];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = i;
        }
        this.removeRows(nArray);
        this.repaint();
    }

    public void removeRows(int[] nArray) {
        ListSelectionModel listSelectionModel = this.getSelectionModel();
        listSelectionModel.setValueIsAdjusting(true);
        int[] nArray2 = this.getSelectedRows();
        this.sorterModel.removeRows(nArray);
        int n = -1;
        for (int i = 0; i < nArray2.length; ++i) {
            n = Math.max(n, nArray2[i]);
        }
        if ((n = Math.min(n, this.sorterModel.getRowCount() - 1)) > -1) {
            this.addRowSelectionInterval(n, n);
        } else {
            this.clearSelection();
        }
        listSelectionModel.setValueIsAdjusting(false);
    }

    public void removeRow(int n) {
        ListSelectionModel listSelectionModel = this.getSelectionModel();
        listSelectionModel.setValueIsAdjusting(true);
        int[] nArray = this.getSelectedRows();
        this.sorterModel.removeRow(n);
        int n2 = -1;
        for (int i = 0; i < nArray.length; ++i) {
            n2 = Math.max(n2, nArray[i]);
        }
        if ((n2 = Math.min(n2, this.sorterModel.getRowCount() - 1)) > -1) {
            this.addRowSelectionInterval(n2, n2);
        } else {
            this.clearSelection();
        }
        listSelectionModel.setValueIsAdjusting(false);
    }

    @Override
    public void setModel(TableModel tableModel) {
        if (!(tableModel instanceof SingleObjectTableSorterModel)) {
            throw new IllegalArgumentException("cannot change table model on singleObjectSortedTable");
        }
        super.setModel(tableModel);
    }

    private Object[] storeSelectedObjectsForAddRows() {
        Object[] objectArray = new Object[]{};
        int[] nArray = this.getSelectedRows();
        objectArray = new Object[nArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = this.getValueAt(nArray[i], -1);
        }
        ListSelectionModel listSelectionModel = this.getSelectionModel();
        listSelectionModel.setValueIsAdjusting(true);
        return objectArray;
    }

    private void restoreSelectedObjectsAfterRowsAdded(Object[] objectArray) {
        for (int i = 0; i < objectArray.length; ++i) {
            int n = this.sorterModel.indexOf(objectArray[i], -1);
            if (n <= -1) continue;
            this.addRowSelectionInterval(n, n);
        }
        ListSelectionModel listSelectionModel = this.getSelectionModel();
        listSelectionModel.setValueIsAdjusting(false);
    }
}

