/*
 * Decompiled with CFR 0.152.
 */
package org.ipea.r5r.Scenario;

import com.conveyal.r5.analyst.scenario.Modification;
import com.conveyal.r5.streets.EdgeStore;
import com.conveyal.r5.transit.TransportNetwork;
import gnu.trove.TIntCollection;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.list.array.TLongArrayList;
import gnu.trove.set.hash.TLongHashSet;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoadCongestionOSM
extends Modification {
    private static final Logger LOG = LoggerFactory.getLogger(RoadCongestionOSM.class);
    public float defaultScaling = 1.0f;
    public HashMap<Long, Float> speedMap;
    public boolean absoluteMode = false;

    public boolean resolve(TransportNetwork network) {
        TLongHashSet osmIdSet = new TLongHashSet();
        for (int i = 0; i < network.streetLayer.edgeStore.osmids.size(); ++i) {
            osmIdSet.add(network.streetLayer.edgeStore.osmids.get(i));
        }
        TLongArrayList badIds = new TLongArrayList();
        for (Long osmId : this.speedMap.keySet()) {
            if (osmIdSet.contains(osmId.longValue())) continue;
            badIds.add(osmId.longValue());
        }
        if (!badIds.isEmpty()) {
            LOG.warn("Cannot find the following OSM IDs in network: {}", (Object)badIds);
        }
        return this.hasErrors();
    }

    public boolean apply(TransportNetwork network) {
        LOG.info("Applying road congestion by OSM id...");
        EdgeStore edgeStore = network.streetLayer.edgeStore;
        EdgeStore.Edge edge = edgeStore.getCursor();
        network.streetLayer.edgeStore.flags = new TIntArrayList((TIntCollection)network.streetLayer.edgeStore.flags);
        while (edge.advance()) {
            float scaling;
            Float value = this.speedMap.get(edge.getOSMID());
            float f = scaling = value == null ? this.defaultScaling : value.floatValue();
            if (scaling == 0.0f) {
                edge.clearFlag(EdgeStore.EdgeFlag.ALLOWS_CAR);
                continue;
            }
            if (value != null && this.absoluteMode) {
                edge.setSpeedKph((double)value.floatValue());
                continue;
            }
            edge.setSpeed((short)((float)edge.getSpeed() * scaling));
        }
        return this.hasErrors();
    }

    public int getSortOrder() {
        return 95;
    }

    public boolean affectsStreetLayer() {
        return true;
    }

    public boolean affectsTransitLayer() {
        return false;
    }
}

