/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk;

import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import org.openscience.cdk.ChemObjectRef;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObject;

public class BondRef
extends ChemObjectRef
implements IBond {
    private final IBond bond;

    public BondRef(IBond bond) {
        super((IChemObject)bond);
        this.bond = bond;
    }

    public static IBond deref(IBond bond) {
        while (bond instanceof BondRef) {
            bond = ((BondRef)bond).deref();
        }
        return bond;
    }

    public IBond deref() {
        return this.bond;
    }

    public Integer getElectronCount() {
        return this.bond.getElectronCount();
    }

    public void setElectronCount(Integer count) {
        this.bond.setElectronCount(count);
    }

    public Iterable<IAtom> atoms() {
        return this.bond.atoms();
    }

    public void setAtoms(IAtom[] atoms) {
        this.bond.setAtoms(atoms);
    }

    public IAtom getBegin() {
        return this.bond.getBegin();
    }

    public IAtom getEnd() {
        return this.bond.getEnd();
    }

    public int getIndex() {
        return this.bond.getIndex();
    }

    public IAtomContainer getContainer() {
        return this.bond.getContainer();
    }

    public int getAtomCount() {
        return this.bond.getAtomCount();
    }

    public IAtom getAtom(int position) {
        return this.bond.getAtom(position);
    }

    public IAtom getConnectedAtom(IAtom atom) {
        return this.bond.getConnectedAtom(atom);
    }

    public IAtom getOther(IAtom atom) {
        return this.bond.getOther(atom);
    }

    public IAtom[] getConnectedAtoms(IAtom atom) {
        return this.bond.getConnectedAtoms(atom);
    }

    public boolean contains(IAtom atom) {
        return this.bond.contains(atom);
    }

    public void setAtom(IAtom atom, int position) {
        this.bond.setAtom(atom, position);
    }

    public IBond.Order getOrder() {
        return this.bond.getOrder();
    }

    public void setOrder(IBond.Order order) {
        this.bond.setOrder(order);
    }

    public IBond.Stereo getStereo() {
        return this.bond.getStereo();
    }

    public void setStereo(IBond.Stereo stereo) {
        this.bond.setStereo(stereo);
    }

    public IBond.Display getDisplay() {
        return this.bond.getDisplay();
    }

    public void setDisplay(IBond.Display display) {
        this.bond.setDisplay(display);
    }

    public Point2d get2DCenter() {
        return this.bond.get2DCenter();
    }

    public Point3d get3DCenter() {
        return this.bond.get3DCenter();
    }

    public boolean compare(Object object) {
        return this.bond.compare(object);
    }

    public boolean isConnectedTo(IBond bond) {
        return this.bond.isConnectedTo(bond);
    }

    public boolean isAromatic() {
        return this.bond.isAromatic();
    }

    public void setIsAromatic(boolean arom) {
        this.bond.setIsAromatic(arom);
    }

    public boolean isInRing() {
        return this.bond.isInRing();
    }

    public void setIsInRing(boolean ring) {
        this.bond.setIsInRing(ring);
    }

    public int hashCode() {
        return this.bond.hashCode();
    }

    public boolean equals(Object obj) {
        return this.bond.equals(obj);
    }

    public IBond clone() throws CloneNotSupportedException {
        return this.bond.clone();
    }

    public String toString() {
        return "BondRef{" + this.bond + "}";
    }
}

