/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class ASCIIUtility {
    private ASCIIUtility() {
    }

    public static int parseInt(byte[] b, int start, int end, int radix) throws NumberFormatException {
        if (b == null) {
            throw new NumberFormatException("null");
        }
        int result2 = 0;
        boolean negative = false;
        int i = start;
        if (end > start) {
            int digit2;
            int limit;
            if (b[i] == 45) {
                negative = true;
                limit = Integer.MIN_VALUE;
                ++i;
            } else {
                limit = -2147483647;
            }
            int multmin = limit / radix;
            if (i < end) {
                if ((digit2 = Character.digit((char)b[i++], radix)) < 0) {
                    throw new NumberFormatException("illegal number: " + ASCIIUtility.toString(b, start, end));
                }
                result2 = -digit2;
            }
            while (i < end) {
                if ((digit2 = Character.digit((char)b[i++], radix)) < 0) {
                    throw new NumberFormatException("illegal number");
                }
                if (result2 < multmin) {
                    throw new NumberFormatException("illegal number");
                }
                if ((result2 *= radix) < limit + digit2) {
                    throw new NumberFormatException("illegal number");
                }
                result2 -= digit2;
            }
        } else {
            throw new NumberFormatException("illegal number");
        }
        if (negative) {
            if (i > start + 1) {
                return result2;
            }
            throw new NumberFormatException("illegal number");
        }
        return -result2;
    }

    public static int parseInt(byte[] b, int start, int end) throws NumberFormatException {
        return ASCIIUtility.parseInt(b, start, end, 10);
    }

    public static long parseLong(byte[] b, int start, int end, int radix) throws NumberFormatException {
        if (b == null) {
            throw new NumberFormatException("null");
        }
        long result2 = 0L;
        boolean negative = false;
        int i = start;
        if (end > start) {
            int digit2;
            long limit;
            if (b[i] == 45) {
                negative = true;
                limit = Long.MIN_VALUE;
                ++i;
            } else {
                limit = -9223372036854775807L;
            }
            long multmin = limit / (long)radix;
            if (i < end) {
                if ((digit2 = Character.digit((char)b[i++], radix)) < 0) {
                    throw new NumberFormatException("illegal number: " + ASCIIUtility.toString(b, start, end));
                }
                result2 = -digit2;
            }
            while (i < end) {
                if ((digit2 = Character.digit((char)b[i++], radix)) < 0) {
                    throw new NumberFormatException("illegal number");
                }
                if (result2 < multmin) {
                    throw new NumberFormatException("illegal number");
                }
                if ((result2 *= (long)radix) < limit + (long)digit2) {
                    throw new NumberFormatException("illegal number");
                }
                result2 -= (long)digit2;
            }
        } else {
            throw new NumberFormatException("illegal number");
        }
        if (negative) {
            if (i > start + 1) {
                return result2;
            }
            throw new NumberFormatException("illegal number");
        }
        return -result2;
    }

    public static long parseLong(byte[] b, int start, int end) throws NumberFormatException {
        return ASCIIUtility.parseLong(b, start, end, 10);
    }

    public static String toString(byte[] b, int start, int end) {
        int size2 = end - start;
        char[] theChars = new char[size2];
        int i = 0;
        int j = start;
        while (i < size2) {
            theChars[i++] = (char)(b[j++] & 0xFF);
        }
        return new String(theChars);
    }

    public static String toString(ByteArrayInputStream is) {
        int size2 = is.available();
        char[] theChars = new char[size2];
        byte[] bytes = new byte[size2];
        is.read(bytes, 0, size2);
        int i = 0;
        while (i < size2) {
            theChars[i] = (char)(bytes[i++] & 0xFF);
        }
        return new String(theChars);
    }

    public static byte[] getBytes(String s) {
        char[] chars = s.toCharArray();
        int size2 = chars.length;
        byte[] bytes = new byte[size2];
        int i = 0;
        while (i < size2) {
            bytes[i] = (byte)chars[i++];
        }
        return bytes;
    }

    public static byte[] getBytes(InputStream is) throws IOException {
        byte[] buf;
        int size2 = 1024;
        if (is instanceof ByteArrayInputStream) {
            size2 = is.available();
            buf = new byte[size2];
            int len = is.read(buf, 0, size2);
        } else {
            int len;
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            buf = new byte[size2];
            while ((len = is.read(buf, 0, size2)) != -1) {
                bos.write(buf, 0, len);
            }
            buf = bos.toByteArray();
        }
        return buf;
    }
}

