/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.subgroup.quality.functions;

import org.vikamine.kernel.subgroup.quality.functions.StandardQF;

public class BinomialQF
extends StandardQF {
    private static final String ID = "BinomialQF";
    private static final String NAME = "Binomial";

    public BinomialQF() {
        super(0.5);
    }

    @Override
    public String getID() {
        return ID;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public StandardQF clone() {
        return new BinomialQF();
    }

    @Override
    public double evaluateBin(double subgroupSize, double tp, double definedPopulationCount, double populationPositives) {
        return this.getPenalty(subgroupSize, definedPopulationCount) * super.evaluateBin(subgroupSize, tp, definedPopulationCount, populationPositives);
    }

    @Override
    public double evaluateNum(double subgroupSize, double sgMean, double definedPopulationCount, double populationMean) {
        return this.getPenalty(subgroupSize, definedPopulationCount) * super.evaluateNum(subgroupSize, sgMean, definedPopulationCount, populationMean);
    }

    private double getPenalty(double subgroupSize, double definedPopulationCount) {
        return Math.sqrt(definedPopulationCount / (definedPopulationCount - subgroupSize));
    }

    @Override
    public double estimateQuality(double subgroupSize, double subgroupPositives, double populationSize, double populationPositives) {
        return Math.pow(subgroupPositives, this.a) * (1.0 - populationPositives / populationSize) * this.getPenalty(subgroupSize, populationSize);
    }
}

